// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.x.ref.services.syncbase.store.watchable;

/**
 * LogEntry represents a single store operation. This operation may have been
 * part of a transaction, as signified by the Continued boolean. Read-only
 * operations (and read-only transactions) are not logged.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/x/ref/services/syncbase/store/watchable.LogEntry")
public class LogEntry extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Op", index = 0)
  private io.v.v23.vdl.VdlAny op;

  @io.v.v23.vdl.GeneratedFromVdl(name = "CommitTimestamp", index = 1)
  private long commitTimestamp;

  @io.v.v23.vdl.GeneratedFromVdl(name = "FromSync", index = 2)
  private boolean fromSync;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Continued", index = 3)
  private boolean continued;

  /**
   * Vdl type for {@link LogEntry}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(LogEntry.class);

  /**
   * Creates a new zero-value instance of {@link LogEntry}.
   */
  public LogEntry() {
    super(VDL_TYPE);

    this.op = new io.v.v23.vdl.VdlAny();

    this.commitTimestamp = 0L;

    this.fromSync = false;

    this.continued = false;
  }

  /**
   * Creates a new instance of {@link LogEntry} with the provided field values.
   */
  public LogEntry(
      io.v.v23.vdl.VdlAny op, long commitTimestamp, boolean fromSync, boolean continued) {
    super(VDL_TYPE);

    this.op = op;

    this.commitTimestamp = commitTimestamp;

    this.fromSync = fromSync;

    this.continued = continued;
  }

  /**
   * The store operation that was performed.
   */
  public io.v.v23.vdl.VdlAny getOp() {
    return this.op;
  }

  /**
   * The store operation that was performed.
   */
  public void setOp(io.v.v23.vdl.VdlAny op) {
    this.op = op;
  }

  /**
   * Time when the operation was committed in nanoseconds since the epoch.
   * Note: We don't use time.Time here because VDL's time.Time consists of
   * {Seconds int64, Nanos int32}, which is more expensive than a single int64.
   */
  public long getCommitTimestamp() {
    return this.commitTimestamp;
  }

  /**
   * Time when the operation was committed in nanoseconds since the epoch.
   * Note: We don't use time.Time here because VDL's time.Time consists of
   * {Seconds int64, Nanos int32}, which is more expensive than a single int64.
   */
  public void setCommitTimestamp(long commitTimestamp) {
    this.commitTimestamp = commitTimestamp;
  }

  /**
   * Operation came from sync (used for echo suppression).
   * TODO(razvanm): this field is specific to syncbase. We should add a
   * generic way to add fields and use that instead.
   */
  public boolean getFromSync() {
    return this.fromSync;
  }

  /**
   * Operation came from sync (used for echo suppression).
   * TODO(razvanm): this field is specific to syncbase. We should add a
   * generic way to add fields and use that instead.
   */
  public void setFromSync(boolean fromSync) {
    this.fromSync = fromSync;
  }

  /**
   * If true, this entry is followed by more entries that belong to the same
   * commit as this entry.
   */
  public boolean getContinued() {
    return this.continued;
  }

  /**
   * If true, this entry is followed by more entries that belong to the same
   * commit as this entry.
   */
  public void setContinued(boolean continued) {
    this.continued = continued;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    LogEntry other = (LogEntry) obj;

    if (this.op == null) {
      if (other.op != null) {
        return false;
      }
    } else if (!this.op.equals(other.op)) {
      return false;
    }

    if (this.commitTimestamp != other.commitTimestamp) {
      return false;
    }

    if (this.fromSync != other.fromSync) {
      return false;
    }

    if (this.continued != other.continued) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.op == null ? 0 : this.op.hashCode());

    result = prime * result + java.lang.Long.valueOf(this.commitTimestamp).hashCode();

    result = prime * result + java.lang.Boolean.valueOf(this.fromSync).hashCode();

    result = prime * result + java.lang.Boolean.valueOf(this.continued).hashCode();

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "op:" + this.op;

    result += ", ";

    result += "commitTimestamp:" + this.commitTimestamp;

    result += ", ";

    result += "fromSync:" + this.fromSync;

    result += ", ";

    result += "continued:" + this.continued;

    return result + "}";
  }
}
