// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: signeddata.vdl
package io.v.x.ref.services.syncbase.signing;

/**
 * WireValidatorData is the wire form of ValidatorData.
 * It excludes the unmarshalled form of the public key.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/x/ref/services/syncbase/signing.WireValidatorData")
public class WireValidatorData extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Names", index = 0)
  private java.util.List<java.lang.String> names;

  @io.v.v23.vdl.GeneratedFromVdl(name = "MarshalledPublicKey", index = 1)
  private byte[] marshalledPublicKey;

  /**
   * Vdl type for {@link WireValidatorData}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(WireValidatorData.class);

  /**
   * Creates a new zero-value instance of {@link WireValidatorData}.
   */
  public WireValidatorData() {
    super(VDL_TYPE);

    this.names = new java.util.ArrayList<java.lang.String>();

    this.marshalledPublicKey = new byte[] {};
  }

  /**
   * Creates a new instance of {@link WireValidatorData} with the provided field values.
   */
  public WireValidatorData(java.util.List<java.lang.String> names, byte[] marshalledPublicKey) {
    super(VDL_TYPE);

    this.names = names;

    this.marshalledPublicKey = marshalledPublicKey;
  }

  /**
   * Names of valid signing blessings in the Blessings referred to by BlessingsHash.
   */
  public java.util.List<java.lang.String> getNames() {
    return this.names;
  }

  /**
   * Names of valid signing blessings in the Blessings referred to by BlessingsHash.
   */
  public void setNames(java.util.List<java.lang.String> names) {
    this.names = names;
  }

  /**
   * PublicKey, marshalled with MarshalBinary().
   */
  public byte[] getMarshalledPublicKey() {
    return this.marshalledPublicKey;
  }

  /**
   * PublicKey, marshalled with MarshalBinary().
   */
  public void setMarshalledPublicKey(byte[] marshalledPublicKey) {
    this.marshalledPublicKey = marshalledPublicKey;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    WireValidatorData other = (WireValidatorData) obj;

    if (this.names == null) {
      if (other.names != null) {
        return false;
      }
    } else if (!this.names.equals(other.names)) {
      return false;
    }

    if (!java.util.Arrays.equals(this.marshalledPublicKey, other.marshalledPublicKey)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.names == null ? 0 : this.names.hashCode());

    result = prime * result + java.util.Arrays.hashCode(this.marshalledPublicKey);

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "names:" + this.names;

    result += ", ";

    result += "marshalledPublicKey:" + java.util.Arrays.toString(this.marshalledPublicKey);

    return result + "}";
  }
}
