// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: signeddata.vdl
package io.v.x.ref.services.syncbase.signing;

/**
 * An Item represents either a marshalled data item or its SHA-256 hash.
 * The Data field is a []byte, rather than an "any" to make signatures
 * determistic.  VOM encoding is not deterministic for two reasons:
 * - map elements may be marshalled in any order
 * - different versions of VOM may marshal in different ways.
 * Thus, the initial producer of a data item marshals the data once, and it is
 * this marshalled form that is transmitted from device to device.  If the
 * data were unmarshalled and then remarsahalled, the signatures might not
 * match.  The Hash field is used instead of the Data field when the recipient
 * of the DataWithSignature is not permitted to see certain Items' Data
 * fields.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/x/ref/services/syncbase/signing.Item")
public class Item extends io.v.v23.vdl.VdlUnion {
  private static final long serialVersionUID = 1L;

  /**
   * Marshalled form of data.
   */
  @io.v.v23.vdl.GeneratedFromVdl(name = "Data", index = 0)
  public static class Data extends Item {
    private static final long serialVersionUID = 1L;
    private byte[] elem;

    public Data(byte[] elem) {
      super(0, elem);
      this.elem = elem;
    }

    public Data() {
      this(new byte[] {});
    }

    @Override
    public byte[] getElem() {
      return elem;
    }

    @Override
    public int hashCode() {
      return java.util.Arrays.hashCode(elem);
    }
  }

  /**
   * Hash of what would have been in Data, as returned by SumByteVectorWithLength(Data).
   */
  @io.v.v23.vdl.GeneratedFromVdl(name = "Hash", index = 1)
  public static class Hash extends Item {
    private static final long serialVersionUID = 1L;
    private byte[] elem;

    public Hash(byte[] elem) {
      super(1, elem);
      this.elem = elem;
    }

    public Hash() {
      this(new byte[] {});
    }

    @Override
    public byte[] getElem() {
      return elem;
    }

    @Override
    public int hashCode() {
      return java.util.Arrays.hashCode(elem);
    }
  }

  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(Item.class);

  public Item(int index, Object value) {
    super(VDL_TYPE, index, value);
  }
}
