// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: signeddata.vdl
package io.v.x.ref.services.syncbase.signing;

/**
 * A DataWithSignature represents a signed, and possibily validated, collection
 * of Item structs.
 *<p>
 * If IsValidated==false and the AuthorSigned signature is valid, it means:
 *    The signer whose Blessings have hash BlessingsHash asserts Data.
 *<p>
 * If IsValidated==true and both AuthorSigned and ValidatorSigned signatures are is valid,
 * it means both:
 * 1) The signer whose Blessings b have hash BlessingsHash asserts Data.
 * 2) If vd is the ValidatorData with hash ValidatorDataHash, the owner of
 *    vd.PublicKey asserts that it checked that at least the names vd.Names[] were
 *    valid in b.
 *<p>
 * The sender obtains:
 * - BlessingsHash (and the wire form of the blessings) with ValidationCache.AddBlessings().
 * - ValidatorDataHash (and the wire form of the ValidataData)  with ValidationCache.AddValidatorData().
 *<p>
 * The receiver looks up:
 * - BlessingsHash with ValidationCache.LookupBlessingsData()
 * - ValidatorDataHash with ValidationCache.LookupValidatorData()
 *<p>
 * If not yet there, the receiver inserts the valus into its ValidationCache with:
 * - ValidationCache.AddWireBlessings()
 * - ValidationCache.AddValidatorData()
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/x/ref/services/syncbase/signing.DataWithSignature")
public class DataWithSignature extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Data", index = 0)
  private java.util.List<io.v.x.ref.services.syncbase.signing.Item> data;

  @io.v.v23.vdl.GeneratedFromVdl(name = "BlessingsHash", index = 1)
  private byte[] blessingsHash;

  @io.v.v23.vdl.GeneratedFromVdl(name = "AuthorSigned", index = 2)
  private io.v.v23.security.VSignature authorSigned;

  @io.v.v23.vdl.GeneratedFromVdl(name = "IsValidated", index = 3)
  private boolean isValidated;

  @io.v.v23.vdl.GeneratedFromVdl(name = "ValidatorDataHash", index = 4)
  private byte[] validatorDataHash;

  @io.v.v23.vdl.GeneratedFromVdl(name = "ValidatorSigned", index = 5)
  private io.v.v23.security.VSignature validatorSigned;

  /**
   * Vdl type for {@link DataWithSignature}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(DataWithSignature.class);

  /**
   * Creates a new zero-value instance of {@link DataWithSignature}.
   */
  public DataWithSignature() {
    super(VDL_TYPE);

    this.data = new java.util.ArrayList<io.v.x.ref.services.syncbase.signing.Item>();

    this.blessingsHash = new byte[] {};

    this.authorSigned = new io.v.v23.security.VSignature();

    this.isValidated = false;

    this.validatorDataHash = new byte[] {};

    this.validatorSigned = new io.v.v23.security.VSignature();
  }

  /**
   * Creates a new instance of {@link DataWithSignature} with the provided field values.
   */
  public DataWithSignature(
      java.util.List<io.v.x.ref.services.syncbase.signing.Item> data,
      byte[] blessingsHash,
      io.v.v23.security.VSignature authorSigned,
      boolean isValidated,
      byte[] validatorDataHash,
      io.v.v23.security.VSignature validatorSigned) {
    super(VDL_TYPE);

    this.data = data;

    this.blessingsHash = blessingsHash;

    this.authorSigned = authorSigned;

    this.isValidated = isValidated;

    this.validatorDataHash = validatorDataHash;

    this.validatorSigned = validatorSigned;
  }

  public java.util.List<io.v.x.ref.services.syncbase.signing.Item> getData() {
    return this.data;
  }

  public void setData(java.util.List<io.v.x.ref.services.syncbase.signing.Item> data) {
    this.data = data;
  }

  /**
   * BlessingsHash is a key for the validation cache; the corresponding
   * cached value is a security.Blessings.
   */
  public byte[] getBlessingsHash() {
    return this.blessingsHash;
  }

  /**
   * BlessingsHash is a key for the validation cache; the corresponding
   * cached value is a security.Blessings.
   */
  public void setBlessingsHash(byte[] blessingsHash) {
    this.blessingsHash = blessingsHash;
  }

  /**
   * AuthorSigned is the signature of Data and BlessingsHash using the
   * private key associated with the blessings hashed in BlessingsHash.
   */
  public io.v.v23.security.VSignature getAuthorSigned() {
    return this.authorSigned;
  }

  /**
   * AuthorSigned is the signature of Data and BlessingsHash using the
   * private key associated with the blessings hashed in BlessingsHash.
   */
  public void setAuthorSigned(io.v.v23.security.VSignature authorSigned) {
    this.authorSigned = authorSigned;
  }

  /**
   * Whether fields below are meaningful.
   */
  public boolean getIsValidated() {
    return this.isValidated;
  }

  /**
   * Whether fields below are meaningful.
   */
  public void setIsValidated(boolean isValidated) {
    this.isValidated = isValidated;
  }

  /**
   * ValidatorDataHash is a key for the validation cache returned by
   * ValidatorData.Hash(); the corresponding cached value is the
   * ValidatorData.
   */
  public byte[] getValidatorDataHash() {
    return this.validatorDataHash;
  }

  /**
   * ValidatorDataHash is a key for the validation cache returned by
   * ValidatorData.Hash(); the corresponding cached value is the
   * ValidatorData.
   */
  public void setValidatorDataHash(byte[] validatorDataHash) {
    this.validatorDataHash = validatorDataHash;
  }

  public io.v.v23.security.VSignature getValidatorSigned() {
    return this.validatorSigned;
  }

  public void setValidatorSigned(io.v.v23.security.VSignature validatorSigned) {
    this.validatorSigned = validatorSigned;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    DataWithSignature other = (DataWithSignature) obj;

    if (this.data == null) {
      if (other.data != null) {
        return false;
      }
    } else if (!this.data.equals(other.data)) {
      return false;
    }

    if (!java.util.Arrays.equals(this.blessingsHash, other.blessingsHash)) {
      return false;
    }

    if (this.authorSigned == null) {
      if (other.authorSigned != null) {
        return false;
      }
    } else if (!this.authorSigned.equals(other.authorSigned)) {
      return false;
    }

    if (this.isValidated != other.isValidated) {
      return false;
    }

    if (!java.util.Arrays.equals(this.validatorDataHash, other.validatorDataHash)) {
      return false;
    }

    if (this.validatorSigned == null) {
      if (other.validatorSigned != null) {
        return false;
      }
    } else if (!this.validatorSigned.equals(other.validatorSigned)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.data == null ? 0 : this.data.hashCode());

    result = prime * result + java.util.Arrays.hashCode(this.blessingsHash);

    result = prime * result + (this.authorSigned == null ? 0 : this.authorSigned.hashCode());

    result = prime * result + java.lang.Boolean.valueOf(this.isValidated).hashCode();

    result = prime * result + java.util.Arrays.hashCode(this.validatorDataHash);

    result = prime * result + (this.validatorSigned == null ? 0 : this.validatorSigned.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "data:" + this.data;

    result += ", ";

    result += "blessingsHash:" + java.util.Arrays.toString(this.blessingsHash);

    result += ", ";

    result += "authorSigned:" + this.authorSigned;

    result += ", ";

    result += "isValidated:" + this.isValidated;

    result += ", ";

    result += "validatorDataHash:" + java.util.Arrays.toString(this.validatorDataHash);

    result += ", ";

    result += "validatorSigned:" + this.validatorSigned;

    return result + "}";
  }
}
