// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: sync_types.vdl
package io.v.x.ref.services.syncbase.server.interfaces;

/**
 * TimeResp contains information needed by the requester to estimate the
 * difference between the two vclocks and to decide whether to incorporate the
 * peer's vclock data.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/x/ref/services/syncbase/server/interfaces.TimeResp")
public class TimeResp extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "OrigTs", index = 0)
  private org.joda.time.DateTime origTs;

  @io.v.v23.vdl.GeneratedFromVdl(name = "RecvTs", index = 1)
  private org.joda.time.DateTime recvTs;

  @io.v.v23.vdl.GeneratedFromVdl(name = "SendTs", index = 2)
  private org.joda.time.DateTime sendTs;

  @io.v.v23.vdl.GeneratedFromVdl(name = "LastNtpTs", index = 3)
  private org.joda.time.DateTime lastNtpTs;

  @io.v.v23.vdl.GeneratedFromVdl(name = "NumReboots", index = 4)
  private io.v.v23.vdl.VdlUint16 numReboots;

  @io.v.v23.vdl.GeneratedFromVdl(name = "NumHops", index = 5)
  private io.v.v23.vdl.VdlUint16 numHops;

  /**
   * Vdl type for {@link TimeResp}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(TimeResp.class);

  /**
   * Creates a new zero-value instance of {@link TimeResp}.
   */
  public TimeResp() {
    super(VDL_TYPE);

    this.origTs = null;

    this.recvTs = null;

    this.sendTs = null;

    this.lastNtpTs = null;

    this.numReboots = new io.v.v23.vdl.VdlUint16();

    this.numHops = new io.v.v23.vdl.VdlUint16();
  }

  /**
   * Creates a new instance of {@link TimeResp} with the provided field values.
   */
  public TimeResp(
      org.joda.time.DateTime origTs,
      org.joda.time.DateTime recvTs,
      org.joda.time.DateTime sendTs,
      org.joda.time.DateTime lastNtpTs,
      io.v.v23.vdl.VdlUint16 numReboots,
      io.v.v23.vdl.VdlUint16 numHops) {
    super(VDL_TYPE);

    this.origTs = origTs;

    this.recvTs = recvTs;

    this.sendTs = sendTs;

    this.lastNtpTs = lastNtpTs;

    this.numReboots = numReboots;

    this.numHops = numHops;
  }

  /**
   * when we sent request
   */
  public org.joda.time.DateTime getOrigTs() {
    return this.origTs;
  }

  /**
   * when we sent request
   */
  public void setOrigTs(org.joda.time.DateTime origTs) {
    this.origTs = origTs;
  }

  /**
   * when peer received request
   */
  public org.joda.time.DateTime getRecvTs() {
    return this.recvTs;
  }

  /**
   * when peer received request
   */
  public void setRecvTs(org.joda.time.DateTime recvTs) {
    this.recvTs = recvTs;
  }

  /**
   * when peer sent response
   */
  public org.joda.time.DateTime getSendTs() {
    return this.sendTs;
  }

  /**
   * when peer sent response
   */
  public void setSendTs(org.joda.time.DateTime sendTs) {
    this.sendTs = sendTs;
  }

  /**
   * NTP server timestamp from the most recent NTP sync, or zero value if none.
   * Note, the NTP sync may have been performed by some peer device.
   */
  public org.joda.time.DateTime getLastNtpTs() {
    return this.lastNtpTs;
  }

  /**
   * NTP server timestamp from the most recent NTP sync, or zero value if none.
   * Note, the NTP sync may have been performed by some peer device.
   */
  public void setLastNtpTs(org.joda.time.DateTime lastNtpTs) {
    this.lastNtpTs = lastNtpTs;
  }

  /**
   * Number of reboots since last NTP sync, accumulated across all hops of p2p
   * clock sync.
   */
  public io.v.v23.vdl.VdlUint16 getNumReboots() {
    return this.numReboots;
  }

  /**
   * Number of reboots since last NTP sync, accumulated across all hops of p2p
   * clock sync.
   */
  public void setNumReboots(io.v.v23.vdl.VdlUint16 numReboots) {
    this.numReboots = numReboots;
  }

  /**
   * Number of sync hops between peer's device and its source of LastNtpTs.
   */
  public io.v.v23.vdl.VdlUint16 getNumHops() {
    return this.numHops;
  }

  /**
   * Number of sync hops between peer's device and its source of LastNtpTs.
   */
  public void setNumHops(io.v.v23.vdl.VdlUint16 numHops) {
    this.numHops = numHops;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    TimeResp other = (TimeResp) obj;

    if (this.origTs == null) {
      if (other.origTs != null) {
        return false;
      }
    } else if (!this.origTs.equals(other.origTs)) {
      return false;
    }

    if (this.recvTs == null) {
      if (other.recvTs != null) {
        return false;
      }
    } else if (!this.recvTs.equals(other.recvTs)) {
      return false;
    }

    if (this.sendTs == null) {
      if (other.sendTs != null) {
        return false;
      }
    } else if (!this.sendTs.equals(other.sendTs)) {
      return false;
    }

    if (this.lastNtpTs == null) {
      if (other.lastNtpTs != null) {
        return false;
      }
    } else if (!this.lastNtpTs.equals(other.lastNtpTs)) {
      return false;
    }

    if (this.numReboots == null) {
      if (other.numReboots != null) {
        return false;
      }
    } else if (!this.numReboots.equals(other.numReboots)) {
      return false;
    }

    if (this.numHops == null) {
      if (other.numHops != null) {
        return false;
      }
    } else if (!this.numHops.equals(other.numHops)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.origTs == null ? 0 : this.origTs.hashCode());

    result = prime * result + (this.recvTs == null ? 0 : this.recvTs.hashCode());

    result = prime * result + (this.sendTs == null ? 0 : this.sendTs.hashCode());

    result = prime * result + (this.lastNtpTs == null ? 0 : this.lastNtpTs.hashCode());

    result = prime * result + (this.numReboots == null ? 0 : this.numReboots.hashCode());

    result = prime * result + (this.numHops == null ? 0 : this.numHops.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "origTs:" + this.origTs;

    result += ", ";

    result += "recvTs:" + this.recvTs;

    result += ", ";

    result += "sendTs:" + this.sendTs;

    result += ", ";

    result += "lastNtpTs:" + this.lastNtpTs;

    result += ", ";

    result += "numReboots:" + this.numReboots;

    result += ", ";

    result += "numHops:" + this.numHops;

    return result + "}";
  }
}
