// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: sync_types.vdl
package io.v.x.ref.services.syncbase.server.interfaces;

/**
 * SyncgroupMemberState contains information about a joiner and the internal bookkeeping
 * state required for resolving conflicts on this joiner's join/leave activity.
 */
@io.v.v23.vdl.GeneratedFromVdl(
  name = "v.io/x/ref/services/syncbase/server/interfaces.SyncgroupMemberState"
)
public class SyncgroupMemberState extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "WhenUpdated", index = 0)
  private long whenUpdated;

  @io.v.v23.vdl.GeneratedFromVdl(name = "HasLeft", index = 1)
  private boolean hasLeft;

  @io.v.v23.vdl.GeneratedFromVdl(name = "MemberInfo", index = 2)
  private io.v.v23.services.syncbase.SyncgroupMemberInfo memberInfo;

  /**
   * Vdl type for {@link SyncgroupMemberState}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(SyncgroupMemberState.class);

  /**
   * Creates a new zero-value instance of {@link SyncgroupMemberState}.
   */
  public SyncgroupMemberState() {
    super(VDL_TYPE);

    this.whenUpdated = 0L;

    this.hasLeft = false;

    this.memberInfo = new io.v.v23.services.syncbase.SyncgroupMemberInfo();
  }

  /**
   * Creates a new instance of {@link SyncgroupMemberState} with the provided field values.
   */
  public SyncgroupMemberState(
      long whenUpdated,
      boolean hasLeft,
      io.v.v23.services.syncbase.SyncgroupMemberInfo memberInfo) {
    super(VDL_TYPE);

    this.whenUpdated = whenUpdated;

    this.hasLeft = hasLeft;

    this.memberInfo = memberInfo;
  }

  /**
   * Timestamp of when the member last joined/left the syncgroup. This timestamp is updated
   * even when an existing member rejoins a syncgroup. Represented as Unix time.
   */
  public long getWhenUpdated() {
    return this.whenUpdated;
  }

  /**
   * Timestamp of when the member last joined/left the syncgroup. This timestamp is updated
   * even when an existing member rejoins a syncgroup. Represented as Unix time.
   */
  public void setWhenUpdated(long whenUpdated) {
    this.whenUpdated = whenUpdated;
  }

  /**
   * If set then this record indicates that this member has left the group. The SyncgroupMember
   * entry is retained after a delete so that it can be used during conflict resolution, when
   * one node indicates that the member has left the group and another says that the member
   * is still in the group.
   */
  public boolean getHasLeft() {
    return this.hasLeft;
  }

  /**
   * If set then this record indicates that this member has left the group. The SyncgroupMember
   * entry is retained after a delete so that it can be used during conflict resolution, when
   * one node indicates that the member has left the group and another says that the member
   * is still in the group.
   */
  public void setHasLeft(boolean hasLeft) {
    this.hasLeft = hasLeft;
  }

  /**
   * Information supplied when requesting a join.
   */
  public io.v.v23.services.syncbase.SyncgroupMemberInfo getMemberInfo() {
    return this.memberInfo;
  }

  /**
   * Information supplied when requesting a join.
   */
  public void setMemberInfo(io.v.v23.services.syncbase.SyncgroupMemberInfo memberInfo) {
    this.memberInfo = memberInfo;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    SyncgroupMemberState other = (SyncgroupMemberState) obj;

    if (this.whenUpdated != other.whenUpdated) {
      return false;
    }

    if (this.hasLeft != other.hasLeft) {
      return false;
    }

    if (this.memberInfo == null) {
      if (other.memberInfo != null) {
        return false;
      }
    } else if (!this.memberInfo.equals(other.memberInfo)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + java.lang.Long.valueOf(this.whenUpdated).hashCode();

    result = prime * result + java.lang.Boolean.valueOf(this.hasLeft).hashCode();

    result = prime * result + (this.memberInfo == null ? 0 : this.memberInfo.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "whenUpdated:" + this.whenUpdated;

    result += ", ";

    result += "hasLeft:" + this.hasLeft;

    result += ", ";

    result += "memberInfo:" + this.memberInfo;

    return result + "}";
  }
}
