// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  sync.vdl
package io.v.x.ref.services.syncbase.server.interfaces;

/**
 * Wrapper for {@link SyncServer}.  This wrapper is used by
 * {@link io.v.v23.rpc.ReflectInvoker} to indirectly invoke server methods.
 */
public final class SyncServerWrapper {
  private final io.v.x.ref.services.syncbase.server.interfaces.SyncServer server;

  /**
   * Creates a new {@link SyncServerWrapper} to invoke the methods of the
   * provided server.
   *
   * @param server server whose methods are to be invoked
   */
  public SyncServerWrapper(io.v.x.ref.services.syncbase.server.interfaces.SyncServer server) {
    this.server = server;
  }

  /**
   * Returns a description of this server.
   */
  public io.v.v23.vdlroot.signature.Interface signature() {
    java.util.List<io.v.v23.vdlroot.signature.Embed> embeds =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Embed>();
    java.util.List<io.v.v23.vdlroot.signature.Method> methods =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Method>();

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  io.v.x.ref.services.syncbase.server.interfaces.TimeReq.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  io.v.x.ref.services.syncbase.server.interfaces.TimeResp.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "getTime",
              "// GetTime returns metadata related to the Syncbase virtual clock, including"
                  + "// system clock values, last NTP timestamp, num reboots, etc."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  io.v.x.ref.services.syncbase.server.interfaces.DeltaReq.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  io.v.x.ref.services.syncbase.server.interfaces.DeltaFinalResp.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "getDeltas",
              "// GetDeltas returns the responder's current generation vectors and all"
                  + "// the missing log records when compared to the initiator's generation"
                  + "// vectors for one Database for either syncgroup metadata or data."
                  + "// The final result (in DeltaFinalResp) currently includes the"
                  + "// syncgroup priorities for blob ownership for the server."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  io.v.x.ref.services.syncbase.server.interfaces.Syncgroup.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  new com.google.common.reflect.TypeToken<
                      io.v.x.ref.services.syncbase.server.interfaces.GenVector>() {}.getType())));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "publishSyncgroup",
              "// PublishSyncgroup is invoked on the syncgroup name (typically served"
                  + "// by a \"central\" peer) to publish the syncgroup.  It takes the name of"
                  + "// Syncbase doing the publishing (the publisher) and returns the name"
                  + "// of the Syncbase where the syncgroup is published (the publishee)."
                  + "// This allows the publisher and the publishee to learn of each other."
                  + "// When a syncgroup is published, the publishee is given the syncgroup"
                  + "// metadata, its current version at the publisher, and the current"
                  + "// syncgroup generation vector.  The generation vector serves as a"
                  + "// checkpoint at the time of publishing.  The publishing proceeds"
                  + "// asynchronously, and the publishee learns the syncgroup history"
                  + "// through the routine p2p sync process and determines when it has"
                  + "// caught up to the level of knowledge at the time of publishing using"
                  + "// the checkpointed generation vector.  Until that point, the publishee"
                  + "// locally deems the syncgroup to be in a pending state and does not"
                  + "// mutate it.  Thus it locally rejects syncgroup joins or updates to"
                  + "// its spec until it is caught up on the syncgroup history."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.syncbase.Id.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.syncbase.Id.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  io.v.v23.services.syncbase.SyncgroupMemberInfo.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  io.v.x.ref.services.syncbase.server.interfaces.Syncgroup.class)));

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  new com.google.common.reflect.TypeToken<
                      io.v.x.ref.services.syncbase.server.interfaces.GenVector>() {}.getType())));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "joinSyncgroupAtAdmin",
              "// JoinSyncgroupAtAdmin is invoked by a prospective syncgroup member's"
                  + "// Syncbase on a syncgroup admin. It checks whether the requestor is"
                  + "// allowed to join the named syncgroup, and if so, adds the requestor to"
                  + "// the syncgroup.  It returns a copy of the updated syncgroup metadata,"
                  + "// its version, and the syncgroup generation vector at the time of the"
                  + "// join.  Similar to the PublishSyncgroup scenario, the joiner at that"
                  + "// point does not have the syncgroup history and locally deems it to be"
                  + "// in a pending state and does not mutate it.  This means it rejects"
                  + "// local updates to the syncgroup spec or, if it were also an admin on"
                  + "// the syncgroup, it would reject syncgroup joins until it is caught up"
                  + "// on the syncgroup history through p2p sync."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.syncbase.BlobRef.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.Long.class)));

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  io.v.x.ref.services.syncbase.server.interfaces.Signpost.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "haveBlob",
              "// HaveBlob verifies that the peer has the requested blob, and if"
                  + "// present, returns its size.  Otherwise, it returns -1, and the location"
                  + "// hints (the Signpost) that the peer has for the blob, filtered to"
                  + "// include only data the caller is permitted to see:"
                  + "// + Device D reveals a syncgroup SG to the caller C iff"
                  + "//   - D is in SG, and"
                  + "//   - SG is in the Signpost, and"
                  + "//   - at least one of:"
                  + "//     - SG is not private, or"
                  + "//     - C has permission to join SG."
                  + "// + Device D reveals a location hint L to caller C iff"
                  + "//   there is a syncgroup SG such that"
                  + "//   - D is in SG, and"
                  + "//   - SG is in the Signpost, and"
                  + "//   - L is in SG, and"
                  + "//   - at least one of:"
                  + "//     - SG is not private, or"
                  + "//     - C has permission to join SG, or"
                  + "//     - L is a blob server in SG."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.syncbase.BlobRef.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  new com.google.common.reflect.TypeToken<
                      io.v.x.ref.services.syncbase.server.interfaces
                          .SgPriorities>() {}.getType())));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  new com.google.common.reflect.TypeToken<
                      io.v.x.ref.services.syncbase.server.interfaces
                          .BlobSharesBySyncgroup>() {}.getType())));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "fetchBlob",
              "// FetchBlob fetches the requested blob."
                  + "// It returns a number of blob ownership shares that the server hopes"
                  + "// the client will accept using the AcceptedBlobOwnership() call."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.syncbase.BlobRef.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  new com.google.common.reflect.TypeToken<
                      io.v.x.ref.services.syncbase.server.interfaces
                          .SgPriorities>() {}.getType())));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  new com.google.common.reflect.TypeToken<
                      io.v.x.ref.services.syncbase.server.interfaces
                          .BlobSharesBySyncgroup>() {}.getType())));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "fetchBlobRecipe",
              "// Methods for incremental blob transfer. The transfer starts with the"
                  + "// receiver making a FetchBlobRecipe call to the sender for a given"
                  + "// BlobRef. The sender, in turn, sends the chunk hashes of all the"
                  + "// chunks that make up the requested blob (blob recipe). The receiver"
                  + "// looks up the chunk hashes in its local blob store, and identifies the"
                  + "// missing ones. The receiver then fetches the missing chunks using a"
                  + "// FetchChunks call from the sender. Finally, the receiver finishes the"
                  + "// blob fetch by combining the chunks obtained over the network with the"
                  + "// already available local chunks as per the blob recipe."
                  + "// callerName is the syncbase Id of the caller, expressed as a string."
                  + "// FetchBlobRecipe returns a number of blob ownership shares that the"
                  + "// server hopes the client will accept for each syncgroup using the"
                  + "// AcceptedBlobOwnership() call."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "fetchChunks", "", inArgs, outArgs, null, null, tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.syncbase.BlobRef.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  new com.google.common.reflect.TypeToken<
                      io.v.x.ref.services.syncbase.server.interfaces
                          .BlobSharesBySyncgroup>() {}.getType())));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "requestTakeBlob",
              "// RequestTakeBlob indicates that the caller wishes the server to take"
                  + "// some blob ownership shares for various syncgroups for the specified blob."
                  + "// If the server chooses to act on the request, it may call FetchBlob/FetchBlobRecipe,"
                  + "// and ultimately AcceptedBlobOwnership()."
                  + "// callerName is the syncbase Id of the caller, expressed as a string."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.syncbase.BlobRef.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  new com.google.common.reflect.TypeToken<
                      io.v.x.ref.services.syncbase.server.interfaces
                          .BlobSharesBySyncgroup>() {}.getType())));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.Boolean.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "acceptedBlobOwnership",
              "// AcceptedBlobOwnership tells the server that the client callerName (a"
                  + "// syncbase Id expressed as a string) has accepted blob ownership of a"
                  + "// specified number of shares for blob br.  The server may decrement"
                  + "// its share count by up to this number.  It is safe for the server to"
                  + "// decrement its share count by fewer than the number of shares another"
                  + "// device has taken responsibility for, but unsafe to decrement it by"
                  + "// more than that that number.  It returns a hint as to whether the"
                  + "// server is likely to keep the blob itself, plus its syncbase Id"
                  + "// expressed as a string."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    return new io.v.v23.vdlroot.signature.Interface(
        "Sync",
        "io.v.x.ref.services.syncbase.server.interfaces",
        "// Sync defines methods for data exchange between Syncbases."
            + "// TODO(hpucha): Flesh this out further."
            + "",
        embeds,
        methods);
  }

  /**
   * Returns all tags associated with the provided method or {@code null} if the method isn't
   * implemented by this server.
   *
   * @param method method whose tags are to be returned
   */
  @SuppressWarnings("unused")
  public io.v.v23.vdl.VdlValue[] getMethodTags(java.lang.String method)
      throws io.v.v23.verror.VException {

    if ("acceptedBlobOwnership".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {};

      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format(
                "Couldn't get tags for method \"acceptedBlobOwnership\": %s", e.getMessage()));
      }
    }

    if ("fetchBlob".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {};

      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"fetchBlob\": %s", e.getMessage()));
      }
    }

    if ("fetchBlobRecipe".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {};

      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"fetchBlobRecipe\": %s", e.getMessage()));
      }
    }

    if ("fetchChunks".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {};

      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"fetchChunks\": %s", e.getMessage()));
      }
    }

    if ("getDeltas".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"getDeltas\": %s", e.getMessage()));
      }
    }

    if ("getTime".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {};

      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"getTime\": %s", e.getMessage()));
      }
    }

    if ("haveBlob".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {};

      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"haveBlob\": %s", e.getMessage()));
      }
    }

    if ("joinSyncgroupAtAdmin".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format(
                "Couldn't get tags for method \"joinSyncgroupAtAdmin\": %s", e.getMessage()));
      }
    }

    if ("publishSyncgroup".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"publishSyncgroup\": %s", e.getMessage()));
      }
    }

    if ("requestTakeBlob".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {};

      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"requestTakeBlob\": %s", e.getMessage()));
      }
    }

    return null; // method not found
  }

  /**
   * GetTime returns metadata related to the Syncbase virtual clock, including
   * system clock values, last NTP timestamp, num reboots, etc.
   */
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.services.syncbase.server.interfaces.TimeResp>
      getTime(
          io.v.v23.context.VContext _ctx,
          final io.v.v23.rpc.StreamServerCall _call,
          final io.v.x.ref.services.syncbase.server.interfaces.TimeReq req,
          final java.lang.String initiator) {

    return this.server.getTime(_ctx, _call, req, initiator);
  }

  /**
   * GetDeltas returns the responder's current generation vectors and all
   * the missing log records when compared to the initiator's generation
   * vectors for one Database for either syncgroup metadata or data.
   * The final result (in DeltaFinalResp) currently includes the
   * syncgroup priorities for blob ownership for the server.
   */
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.services.syncbase.server.interfaces.DeltaFinalResp>
      getDeltas(
          io.v.v23.context.VContext _ctx,
          final io.v.v23.rpc.StreamServerCall _call,
          final io.v.x.ref.services.syncbase.server.interfaces.DeltaReq req,
          final java.lang.String initiator) {

    io.v.v23.vdl.ServerStream<
            io.v.x.ref.services.syncbase.server.interfaces.DeltaResp, java.lang.Void>
        _stream =
            new io.v.v23.vdl.ServerStream<
                io.v.x.ref.services.syncbase.server.interfaces.DeltaResp, java.lang.Void>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<Void> send(
                  io.v.x.ref.services.syncbase.server.interfaces.DeltaResp _item) {
                java.lang.reflect.Type _type =
                    io.v.x.ref.services.syncbase.server.interfaces.DeltaResp.class;
                return _call.send(_item, _type);
              }

              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> recv() {
                java.lang.reflect.Type _type = java.lang.Void.class;
                return com.google.common.util.concurrent.Futures.transform(
                    _call.recv(_type),
                    new com.google.common.base.Function<Object, java.lang.Void>() {
                      @Override
                      public java.lang.Void apply(Object result) {
                        return (java.lang.Void) result;
                      }
                    });
              }
            };

    return this.server.getDeltas(_ctx, _call, req, initiator, _stream);
  }

  /**
   * PublishSyncgroup is invoked on the syncgroup name (typically served
   * by a "central" peer) to publish the syncgroup.  It takes the name of
   * Syncbase doing the publishing (the publisher) and returns the name
   * of the Syncbase where the syncgroup is published (the publishee).
   * This allows the publisher and the publishee to learn of each other.
   * When a syncgroup is published, the publishee is given the syncgroup
   * metadata, its current version at the publisher, and the current
   * syncgroup generation vector.  The generation vector serves as a
   * checkpoint at the time of publishing.  The publishing proceeds
   * asynchronously, and the publishee learns the syncgroup history
   * through the routine p2p sync process and determines when it has
   * caught up to the level of knowledge at the time of publishing using
   * the checkpointed generation vector.  Until that point, the publishee
   * locally deems the syncgroup to be in a pending state and does not
   * mutate it.  Thus it locally rejects syncgroup joins or updates to
   * its spec until it is caught up on the syncgroup history.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.String> publishSyncgroup(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final java.lang.String publisher,
      final io.v.x.ref.services.syncbase.server.interfaces.Syncgroup sg,
      final java.lang.String version,
      final io.v.x.ref.services.syncbase.server.interfaces.GenVector genvec) {

    return this.server.publishSyncgroup(_ctx, _call, publisher, sg, version, genvec);
  }

  /**
   * JoinSyncgroupAtAdmin is invoked by a prospective syncgroup member's
   * Syncbase on a syncgroup admin. It checks whether the requestor is
   * allowed to join the named syncgroup, and if so, adds the requestor to
   * the syncgroup.  It returns a copy of the updated syncgroup metadata,
   * its version, and the syncgroup generation vector at the time of the
   * join.  Similar to the PublishSyncgroup scenario, the joiner at that
   * point does not have the syncgroup history and locally deems it to be
   * in a pending state and does not mutate it.  This means it rejects
   * local updates to the syncgroup spec or, if it were also an admin on
   * the syncgroup, it would reject syncgroup joins until it is caught up
   * on the syncgroup history through p2p sync.
   */
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.services.syncbase.server.interfaces.SyncServer.JoinSyncgroupAtAdminOut>
      joinSyncgroupAtAdmin(
          io.v.v23.context.VContext _ctx,
          final io.v.v23.rpc.StreamServerCall _call,
          final io.v.v23.services.syncbase.Id dbId,
          final io.v.v23.services.syncbase.Id sgId,
          final java.lang.String joinerName,
          final io.v.v23.services.syncbase.SyncgroupMemberInfo myInfo) {

    return this.server.joinSyncgroupAtAdmin(_ctx, _call, dbId, sgId, joinerName, myInfo);
  }

  /**
   * HaveBlob verifies that the peer has the requested blob, and if
   * present, returns its size.  Otherwise, it returns -1, and the location
   * hints (the Signpost) that the peer has for the blob, filtered to
   * include only data the caller is permitted to see:
   * + Device D reveals a syncgroup SG to the caller C iff
   *   - D is in SG, and
   *   - SG is in the Signpost, and
   *   - at least one of:
   *     - SG is not private, or
   *     - C has permission to join SG.
   * + Device D reveals a location hint L to caller C iff
   *   there is a syncgroup SG such that
   *   - D is in SG, and
   *   - SG is in the Signpost, and
   *   - L is in SG, and
   *   - at least one of:
   *     - SG is not private, or
   *     - C has permission to join SG, or
   *     - L is a blob server in SG.
   */
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.services.syncbase.server.interfaces.SyncServer.HaveBlobOut>
      haveBlob(
          io.v.v23.context.VContext _ctx,
          final io.v.v23.rpc.StreamServerCall _call,
          final io.v.v23.services.syncbase.BlobRef br) {

    return this.server.haveBlob(_ctx, _call, br);
  }

  /**
   * FetchBlob fetches the requested blob.
   * It returns a number of blob ownership shares that the server hopes
   * the client will accept using the AcceptedBlobOwnership() call.
   */
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.services.syncbase.server.interfaces.BlobSharesBySyncgroup>
      fetchBlob(
          io.v.v23.context.VContext _ctx,
          final io.v.v23.rpc.StreamServerCall _call,
          final io.v.v23.services.syncbase.BlobRef br,
          final io.v.x.ref.services.syncbase.server.interfaces.SgPriorities mySgPriorities) {

    io.v.v23.vdl.ServerStream<byte[], java.lang.Void> _stream =
        new io.v.v23.vdl.ServerStream<byte[], java.lang.Void>() {
          @Override
          public com.google.common.util.concurrent.ListenableFuture<Void> send(byte[] _item) {
            java.lang.reflect.Type _type = byte[].class;
            return _call.send(_item, _type);
          }

          @Override
          public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> recv() {
            java.lang.reflect.Type _type = java.lang.Void.class;
            return com.google.common.util.concurrent.Futures.transform(
                _call.recv(_type),
                new com.google.common.base.Function<Object, java.lang.Void>() {
                  @Override
                  public java.lang.Void apply(Object result) {
                    return (java.lang.Void) result;
                  }
                });
          }
        };

    return this.server.fetchBlob(_ctx, _call, br, mySgPriorities, _stream);
  }

  /**
   * Methods for incremental blob transfer. The transfer starts with the
   * receiver making a FetchBlobRecipe call to the sender for a given
   * BlobRef. The sender, in turn, sends the chunk hashes of all the
   * chunks that make up the requested blob (blob recipe). The receiver
   * looks up the chunk hashes in its local blob store, and identifies the
   * missing ones. The receiver then fetches the missing chunks using a
   * FetchChunks call from the sender. Finally, the receiver finishes the
   * blob fetch by combining the chunks obtained over the network with the
   * already available local chunks as per the blob recipe.
   * callerName is the syncbase Id of the caller, expressed as a string.
   * FetchBlobRecipe returns a number of blob ownership shares that the
   * server hopes the client will accept for each syncgroup using the
   * AcceptedBlobOwnership() call.
   */
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.services.syncbase.server.interfaces.BlobSharesBySyncgroup>
      fetchBlobRecipe(
          io.v.v23.context.VContext _ctx,
          final io.v.v23.rpc.StreamServerCall _call,
          final io.v.v23.services.syncbase.BlobRef br,
          final java.lang.String callerName,
          final io.v.x.ref.services.syncbase.server.interfaces.SgPriorities mySgPriorities) {

    io.v.v23.vdl.ServerStream<
            io.v.x.ref.services.syncbase.server.interfaces.ChunkHash, java.lang.Void>
        _stream =
            new io.v.v23.vdl.ServerStream<
                io.v.x.ref.services.syncbase.server.interfaces.ChunkHash, java.lang.Void>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<Void> send(
                  io.v.x.ref.services.syncbase.server.interfaces.ChunkHash _item) {
                java.lang.reflect.Type _type =
                    io.v.x.ref.services.syncbase.server.interfaces.ChunkHash.class;
                return _call.send(_item, _type);
              }

              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> recv() {
                java.lang.reflect.Type _type = java.lang.Void.class;
                return com.google.common.util.concurrent.Futures.transform(
                    _call.recv(_type),
                    new com.google.common.base.Function<Object, java.lang.Void>() {
                      @Override
                      public java.lang.Void apply(Object result) {
                        return (java.lang.Void) result;
                      }
                    });
              }
            };

    return this.server.fetchBlobRecipe(_ctx, _call, br, callerName, mySgPriorities, _stream);
  }

  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> fetchChunks(
      io.v.v23.context.VContext _ctx, final io.v.v23.rpc.StreamServerCall _call) {

    io.v.v23.vdl.ServerStream<
            io.v.x.ref.services.syncbase.server.interfaces.ChunkData,
            io.v.x.ref.services.syncbase.server.interfaces.ChunkHash>
        _stream =
            new io.v.v23.vdl.ServerStream<
                io.v.x.ref.services.syncbase.server.interfaces.ChunkData,
                io.v.x.ref.services.syncbase.server.interfaces.ChunkHash>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<Void> send(
                  io.v.x.ref.services.syncbase.server.interfaces.ChunkData _item) {
                java.lang.reflect.Type _type =
                    io.v.x.ref.services.syncbase.server.interfaces.ChunkData.class;
                return _call.send(_item, _type);
              }

              @Override
              public com.google.common.util.concurrent.ListenableFuture<
                      io.v.x.ref.services.syncbase.server.interfaces.ChunkHash>
                  recv() {
                java.lang.reflect.Type _type =
                    io.v.x.ref.services.syncbase.server.interfaces.ChunkHash.class;
                return com.google.common.util.concurrent.Futures.transform(
                    _call.recv(_type),
                    new com.google.common.base.Function<
                        Object, io.v.x.ref.services.syncbase.server.interfaces.ChunkHash>() {
                      @Override
                      public io.v.x.ref.services.syncbase.server.interfaces.ChunkHash apply(
                          Object result) {
                        return (io.v.x.ref.services.syncbase.server.interfaces.ChunkHash) result;
                      }
                    });
              }
            };

    return this.server.fetchChunks(_ctx, _call, _stream);
  }

  /**
   * RequestTakeBlob indicates that the caller wishes the server to take
   * some blob ownership shares for various syncgroups for the specified blob.
   * If the server chooses to act on the request, it may call FetchBlob/FetchBlobRecipe,
   * and ultimately AcceptedBlobOwnership().
   * callerName is the syncbase Id of the caller, expressed as a string.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> requestTakeBlob(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final io.v.v23.services.syncbase.BlobRef br,
      final java.lang.String callerName,
      final io.v.x.ref.services.syncbase.server.interfaces.BlobSharesBySyncgroup shares) {

    return this.server.requestTakeBlob(_ctx, _call, br, callerName, shares);
  }

  /**
   * AcceptedBlobOwnership tells the server that the client callerName (a
   * syncbase Id expressed as a string) has accepted blob ownership of a
   * specified number of shares for blob br.  The server may decrement
   * its share count by up to this number.  It is safe for the server to
   * decrement its share count by fewer than the number of shares another
   * device has taken responsibility for, but unsafe to decrement it by
   * more than that that number.  It returns a hint as to whether the
   * server is likely to keep the blob itself, plus its syncbase Id
   * expressed as a string.
   */
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.services.syncbase.server.interfaces.SyncServer.AcceptedBlobOwnershipOut>
      acceptedBlobOwnership(
          io.v.v23.context.VContext _ctx,
          final io.v.v23.rpc.StreamServerCall _call,
          final io.v.v23.services.syncbase.BlobRef br,
          final java.lang.String callerName,
          final io.v.x.ref.services.syncbase.server.interfaces.BlobSharesBySyncgroup shares) {

    return this.server.acceptedBlobOwnership(_ctx, _call, br, callerName, shares);
  }
}
