// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  sync.vdl
package io.v.x.ref.services.syncbase.server.interfaces;

/**
 * Implementation of the {@link SyncClient} interface.
 */
final class SyncClientImpl implements io.v.x.ref.services.syncbase.server.interfaces.SyncClient {
  private final io.v.v23.rpc.Client client;
  private final java.lang.String vName;

  /**
   * Creates a new instance of {@link SyncClientImpl}.
   *
   * @param client Vanadium client
   * @param vName  remote server name
   */
  public SyncClientImpl(io.v.v23.rpc.Client client, java.lang.String vName) {
    this.client = client;
    this.vName = vName;
  }

  private io.v.v23.rpc.Client getClient(io.v.v23.context.VContext context) {
    return this.client != null ? client : io.v.v23.V.getClient(context);
  }

  // Methods from interface SyncClient.

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.services.syncbase.server.interfaces.TimeResp>
      getTime(
          io.v.v23.context.VContext _context,
          final io.v.x.ref.services.syncbase.server.interfaces.TimeReq req,
          final java.lang.String initiator) {
    return getTime(_context, req, initiator, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.services.syncbase.server.interfaces.TimeResp>
      getTime(
          final io.v.v23.context.VContext _context,
          final io.v.x.ref.services.syncbase.server.interfaces.TimeReq req,
          final java.lang.String initiator,
          io.v.v23.Options _opts) {
    return getTime(_context, req, initiator, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.services.syncbase.server.interfaces.TimeResp>
      getTime(
          final io.v.v23.context.VContext _context,
          final io.v.x.ref.services.syncbase.server.interfaces.TimeReq req,
          final java.lang.String initiator,
          io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {req, initiator};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {
          io.v.x.ref.services.syncbase.server.interfaces.TimeReq.class, java.lang.String.class
        };
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "getTime", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall,
                io.v.x.ref.services.syncbase.server.interfaces.TimeResp>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<
                      io.v.x.ref.services.syncbase.server.interfaces.TimeResp>
                  apply(final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      io.v.x.ref.services.syncbase.server.interfaces.TimeResp.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<
                        Object[], io.v.x.ref.services.syncbase.server.interfaces.TimeResp>() {
                      @Override
                      public io.v.x.ref.services.syncbase.server.interfaces.TimeResp apply(
                          Object[] _results) {

                        return (io.v.x.ref.services.syncbase.server.interfaces.TimeResp)
                            _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public io.v.v23.vdl.ClientRecvStream<
          io.v.x.ref.services.syncbase.server.interfaces.DeltaResp,
          io.v.x.ref.services.syncbase.server.interfaces.DeltaFinalResp>
      getDeltas(
          io.v.v23.context.VContext _context,
          final io.v.x.ref.services.syncbase.server.interfaces.DeltaReq req,
          final java.lang.String initiator) {
    return getDeltas(_context, req, initiator, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public io.v.v23.vdl.ClientRecvStream<
          io.v.x.ref.services.syncbase.server.interfaces.DeltaResp,
          io.v.x.ref.services.syncbase.server.interfaces.DeltaFinalResp>
      getDeltas(
          final io.v.v23.context.VContext _context,
          final io.v.x.ref.services.syncbase.server.interfaces.DeltaReq req,
          final java.lang.String initiator,
          io.v.v23.Options _opts) {
    return getDeltas(_context, req, initiator, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public io.v.v23.vdl.ClientRecvStream<
          io.v.x.ref.services.syncbase.server.interfaces.DeltaResp,
          io.v.x.ref.services.syncbase.server.interfaces.DeltaFinalResp>
      getDeltas(
          final io.v.v23.context.VContext _context,
          final io.v.x.ref.services.syncbase.server.interfaces.DeltaReq req,
          final java.lang.String initiator,
          io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {req, initiator};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {
          io.v.x.ref.services.syncbase.server.interfaces.DeltaReq.class, java.lang.String.class
        };
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "getDeltas", _args, _argTypes, _opts);

    return new io.v.v23.vdl.ClientStream<
        java.lang.Void, io.v.x.ref.services.syncbase.server.interfaces.DeltaResp,
        io.v.x.ref.services.syncbase.server.interfaces.DeltaFinalResp>() {
      @Override
      public com.google.common.util.concurrent.ListenableFuture<Void> send(
          final java.lang.Void item) {
        final java.lang.reflect.Type type = java.lang.Void.class;
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, Void>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<Void> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return _call.send(item, type);
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<Void> close() {
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, Void>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<Void> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return _call.closeSend();
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<
              io.v.x.ref.services.syncbase.server.interfaces.DeltaResp>
          recv() {
        final java.lang.reflect.Type recvType =
            io.v.x.ref.services.syncbase.server.interfaces.DeltaResp.class;
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall,
                    io.v.x.ref.services.syncbase.server.interfaces.DeltaResp>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<
                          io.v.x.ref.services.syncbase.server.interfaces.DeltaResp>
                      apply(final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return com.google.common.util.concurrent.Futures.transform(
                        _call.recv(recvType),
                        new com.google.common.base.Function<
                            Object, io.v.x.ref.services.syncbase.server.interfaces.DeltaResp>() {
                          @Override
                          public io.v.x.ref.services.syncbase.server.interfaces.DeltaResp apply(
                              Object result) {
                            return (io.v.x.ref.services.syncbase.server.interfaces.DeltaResp)
                                result;
                          }
                        });
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<
              io.v.x.ref.services.syncbase.server.interfaces.DeltaFinalResp>
          finish() {

        final java.lang.reflect.Type[] resultTypes =
            new java.lang.reflect.Type[] {
              io.v.x.ref.services.syncbase.server.interfaces.DeltaFinalResp.class,
            };

        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall,
                    io.v.x.ref.services.syncbase.server.interfaces.DeltaFinalResp>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<
                          io.v.x.ref.services.syncbase.server.interfaces.DeltaFinalResp>
                      apply(final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return com.google.common.util.concurrent.Futures.transform(
                        _call.finish(resultTypes),
                        new com.google.common.base.Function<
                            Object[],
                            io.v.x.ref.services.syncbase.server.interfaces.DeltaFinalResp>() {
                          @Override
                          public io.v.x.ref.services.syncbase.server.interfaces.DeltaFinalResp
                              apply(Object[] _results) {

                            return (io.v.x.ref.services.syncbase.server.interfaces.DeltaFinalResp)
                                _results[0];
                          }
                        });
                  }
                }));
      }
    };
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.String> publishSyncgroup(
      io.v.v23.context.VContext _context,
      final java.lang.String publisher,
      final io.v.x.ref.services.syncbase.server.interfaces.Syncgroup sg,
      final java.lang.String version,
      final io.v.x.ref.services.syncbase.server.interfaces.GenVector genvec) {
    return publishSyncgroup(
        _context, publisher, sg, version, genvec, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.String> publishSyncgroup(
      final io.v.v23.context.VContext _context,
      final java.lang.String publisher,
      final io.v.x.ref.services.syncbase.server.interfaces.Syncgroup sg,
      final java.lang.String version,
      final io.v.x.ref.services.syncbase.server.interfaces.GenVector genvec,
      io.v.v23.Options _opts) {
    return publishSyncgroup(
        _context,
        publisher,
        sg,
        version,
        genvec,
        io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.String> publishSyncgroup(
      final io.v.v23.context.VContext _context,
      final java.lang.String publisher,
      final io.v.x.ref.services.syncbase.server.interfaces.Syncgroup sg,
      final java.lang.String version,
      final io.v.x.ref.services.syncbase.server.interfaces.GenVector genvec,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {publisher, sg, version, genvec};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {
          java.lang.String.class,
          io.v.x.ref.services.syncbase.server.interfaces.Syncgroup.class,
          java.lang.String.class,
          new com.google.common.reflect.TypeToken<
              io.v.x.ref.services.syncbase.server.interfaces.GenVector>() {}.getType()
        };
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context)
            .startCall(_context, this.vName, "publishSyncgroup", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.String>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.String> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      java.lang.String.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.String>() {
                      @Override
                      public java.lang.String apply(Object[] _results) {

                        return (java.lang.String) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.services.syncbase.server.interfaces.SyncClient.JoinSyncgroupAtAdminOut>
      joinSyncgroupAtAdmin(
          io.v.v23.context.VContext _context,
          final io.v.v23.services.syncbase.Id dbId,
          final io.v.v23.services.syncbase.Id sgId,
          final java.lang.String joinerName,
          final io.v.v23.services.syncbase.SyncgroupMemberInfo myInfo) {
    return joinSyncgroupAtAdmin(
        _context, dbId, sgId, joinerName, myInfo, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.services.syncbase.server.interfaces.SyncClient.JoinSyncgroupAtAdminOut>
      joinSyncgroupAtAdmin(
          final io.v.v23.context.VContext _context,
          final io.v.v23.services.syncbase.Id dbId,
          final io.v.v23.services.syncbase.Id sgId,
          final java.lang.String joinerName,
          final io.v.v23.services.syncbase.SyncgroupMemberInfo myInfo,
          io.v.v23.Options _opts) {
    return joinSyncgroupAtAdmin(
        _context,
        dbId,
        sgId,
        joinerName,
        myInfo,
        io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.services.syncbase.server.interfaces.SyncClient.JoinSyncgroupAtAdminOut>
      joinSyncgroupAtAdmin(
          final io.v.v23.context.VContext _context,
          final io.v.v23.services.syncbase.Id dbId,
          final io.v.v23.services.syncbase.Id sgId,
          final java.lang.String joinerName,
          final io.v.v23.services.syncbase.SyncgroupMemberInfo myInfo,
          io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {dbId, sgId, joinerName, myInfo};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {
          io.v.v23.services.syncbase.Id.class,
          io.v.v23.services.syncbase.Id.class,
          java.lang.String.class,
          io.v.v23.services.syncbase.SyncgroupMemberInfo.class
        };
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context)
            .startCall(_context, this.vName, "joinSyncgroupAtAdmin", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall,
                io.v.x.ref.services.syncbase.server.interfaces.SyncClient
                    .JoinSyncgroupAtAdminOut>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<
                      io.v.x.ref.services.syncbase.server.interfaces.SyncClient
                          .JoinSyncgroupAtAdminOut>
                  apply(final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      io.v.x.ref.services.syncbase.server.interfaces.Syncgroup.class,
                      java.lang.String.class,
                      new com.google.common.reflect.TypeToken<
                          io.v.x.ref.services.syncbase.server.interfaces.GenVector>() {}.getType(),
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<
                        Object[],
                        io.v.x.ref.services.syncbase.server.interfaces.SyncClient
                            .JoinSyncgroupAtAdminOut>() {
                      @Override
                      public io.v.x.ref.services.syncbase.server.interfaces.SyncClient
                              .JoinSyncgroupAtAdminOut
                          apply(Object[] _results) {

                        io.v.x.ref.services.syncbase.server.interfaces.SyncClient
                                .JoinSyncgroupAtAdminOut
                            _ret =
                                new io.v.x.ref.services.syncbase.server.interfaces.SyncClient
                                    .JoinSyncgroupAtAdminOut();

                        _ret.sg =
                            (io.v.x.ref.services.syncbase.server.interfaces.Syncgroup) _results[0];

                        _ret.version = (java.lang.String) _results[1];

                        _ret.genvec =
                            (io.v.x.ref.services.syncbase.server.interfaces.GenVector) _results[2];

                        return _ret;
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.services.syncbase.server.interfaces.SyncClient.HaveBlobOut>
      haveBlob(io.v.v23.context.VContext _context, final io.v.v23.services.syncbase.BlobRef br) {
    return haveBlob(_context, br, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.services.syncbase.server.interfaces.SyncClient.HaveBlobOut>
      haveBlob(
          final io.v.v23.context.VContext _context,
          final io.v.v23.services.syncbase.BlobRef br,
          io.v.v23.Options _opts) {
    return haveBlob(_context, br, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.services.syncbase.server.interfaces.SyncClient.HaveBlobOut>
      haveBlob(
          final io.v.v23.context.VContext _context,
          final io.v.v23.services.syncbase.BlobRef br,
          io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {br};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {io.v.v23.services.syncbase.BlobRef.class};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "haveBlob", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall,
                io.v.x.ref.services.syncbase.server.interfaces.SyncClient.HaveBlobOut>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<
                      io.v.x.ref.services.syncbase.server.interfaces.SyncClient.HaveBlobOut>
                  apply(final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      java.lang.Long.class,
                      io.v.x.ref.services.syncbase.server.interfaces.Signpost.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<
                        Object[],
                        io.v.x.ref.services.syncbase.server.interfaces.SyncClient.HaveBlobOut>() {
                      @Override
                      public io.v.x.ref.services.syncbase.server.interfaces.SyncClient.HaveBlobOut
                          apply(Object[] _results) {

                        io.v.x.ref.services.syncbase.server.interfaces.SyncClient.HaveBlobOut _ret =
                            new io.v.x.ref.services.syncbase.server.interfaces.SyncClient
                                .HaveBlobOut();

                        _ret.size = (java.lang.Long) _results[0];

                        _ret.signpost =
                            (io.v.x.ref.services.syncbase.server.interfaces.Signpost) _results[1];

                        return _ret;
                      }
                    });
              }
            }));
  }

  @Override
  public io.v.v23.vdl.ClientRecvStream<
          byte[], io.v.x.ref.services.syncbase.server.interfaces.BlobSharesBySyncgroup>
      fetchBlob(
          io.v.v23.context.VContext _context,
          final io.v.v23.services.syncbase.BlobRef br,
          final io.v.x.ref.services.syncbase.server.interfaces.SgPriorities mySgPriorities) {
    return fetchBlob(_context, br, mySgPriorities, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public io.v.v23.vdl.ClientRecvStream<
          byte[], io.v.x.ref.services.syncbase.server.interfaces.BlobSharesBySyncgroup>
      fetchBlob(
          final io.v.v23.context.VContext _context,
          final io.v.v23.services.syncbase.BlobRef br,
          final io.v.x.ref.services.syncbase.server.interfaces.SgPriorities mySgPriorities,
          io.v.v23.Options _opts) {
    return fetchBlob(
        _context, br, mySgPriorities, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public io.v.v23.vdl.ClientRecvStream<
          byte[], io.v.x.ref.services.syncbase.server.interfaces.BlobSharesBySyncgroup>
      fetchBlob(
          final io.v.v23.context.VContext _context,
          final io.v.v23.services.syncbase.BlobRef br,
          final io.v.x.ref.services.syncbase.server.interfaces.SgPriorities mySgPriorities,
          io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {br, mySgPriorities};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {
          io.v.v23.services.syncbase.BlobRef.class,
          new com.google.common.reflect.TypeToken<
              io.v.x.ref.services.syncbase.server.interfaces.SgPriorities>() {}.getType()
        };
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "fetchBlob", _args, _argTypes, _opts);

    return new io.v.v23.vdl.ClientStream<
        java.lang.Void, byte[],
        io.v.x.ref.services.syncbase.server.interfaces.BlobSharesBySyncgroup>() {
      @Override
      public com.google.common.util.concurrent.ListenableFuture<Void> send(
          final java.lang.Void item) {
        final java.lang.reflect.Type type = java.lang.Void.class;
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, Void>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<Void> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return _call.send(item, type);
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<Void> close() {
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, Void>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<Void> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return _call.closeSend();
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<byte[]> recv() {
        final java.lang.reflect.Type recvType = byte[].class;
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, byte[]>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<byte[]> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return com.google.common.util.concurrent.Futures.transform(
                        _call.recv(recvType),
                        new com.google.common.base.Function<Object, byte[]>() {
                          @Override
                          public byte[] apply(Object result) {
                            return (byte[]) result;
                          }
                        });
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<
              io.v.x.ref.services.syncbase.server.interfaces.BlobSharesBySyncgroup>
          finish() {

        final java.lang.reflect.Type[] resultTypes =
            new java.lang.reflect.Type[] {
              new com.google.common.reflect.TypeToken<
                  io.v.x.ref.services.syncbase.server.interfaces
                      .BlobSharesBySyncgroup>() {}.getType(),
            };

        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall,
                    io.v.x.ref.services.syncbase.server.interfaces.BlobSharesBySyncgroup>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<
                          io.v.x.ref.services.syncbase.server.interfaces.BlobSharesBySyncgroup>
                      apply(final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return com.google.common.util.concurrent.Futures.transform(
                        _call.finish(resultTypes),
                        new com.google.common.base.Function<
                            Object[],
                            io.v.x.ref.services.syncbase.server.interfaces
                                .BlobSharesBySyncgroup>() {
                          @Override
                          public io.v.x.ref.services.syncbase.server.interfaces
                                  .BlobSharesBySyncgroup
                              apply(Object[] _results) {

                            return (io.v.x.ref.services.syncbase.server.interfaces
                                    .BlobSharesBySyncgroup)
                                _results[0];
                          }
                        });
                  }
                }));
      }
    };
  }

  @Override
  public io.v.v23.vdl.ClientRecvStream<
          io.v.x.ref.services.syncbase.server.interfaces.ChunkHash,
          io.v.x.ref.services.syncbase.server.interfaces.BlobSharesBySyncgroup>
      fetchBlobRecipe(
          io.v.v23.context.VContext _context,
          final io.v.v23.services.syncbase.BlobRef br,
          final java.lang.String callerName,
          final io.v.x.ref.services.syncbase.server.interfaces.SgPriorities mySgPriorities) {
    return fetchBlobRecipe(
        _context, br, callerName, mySgPriorities, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public io.v.v23.vdl.ClientRecvStream<
          io.v.x.ref.services.syncbase.server.interfaces.ChunkHash,
          io.v.x.ref.services.syncbase.server.interfaces.BlobSharesBySyncgroup>
      fetchBlobRecipe(
          final io.v.v23.context.VContext _context,
          final io.v.v23.services.syncbase.BlobRef br,
          final java.lang.String callerName,
          final io.v.x.ref.services.syncbase.server.interfaces.SgPriorities mySgPriorities,
          io.v.v23.Options _opts) {
    return fetchBlobRecipe(
        _context,
        br,
        callerName,
        mySgPriorities,
        io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public io.v.v23.vdl.ClientRecvStream<
          io.v.x.ref.services.syncbase.server.interfaces.ChunkHash,
          io.v.x.ref.services.syncbase.server.interfaces.BlobSharesBySyncgroup>
      fetchBlobRecipe(
          final io.v.v23.context.VContext _context,
          final io.v.v23.services.syncbase.BlobRef br,
          final java.lang.String callerName,
          final io.v.x.ref.services.syncbase.server.interfaces.SgPriorities mySgPriorities,
          io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {br, callerName, mySgPriorities};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {
          io.v.v23.services.syncbase.BlobRef.class,
          java.lang.String.class,
          new com.google.common.reflect.TypeToken<
              io.v.x.ref.services.syncbase.server.interfaces.SgPriorities>() {}.getType()
        };
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context)
            .startCall(_context, this.vName, "fetchBlobRecipe", _args, _argTypes, _opts);

    return new io.v.v23.vdl.ClientStream<
        java.lang.Void, io.v.x.ref.services.syncbase.server.interfaces.ChunkHash,
        io.v.x.ref.services.syncbase.server.interfaces.BlobSharesBySyncgroup>() {
      @Override
      public com.google.common.util.concurrent.ListenableFuture<Void> send(
          final java.lang.Void item) {
        final java.lang.reflect.Type type = java.lang.Void.class;
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, Void>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<Void> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return _call.send(item, type);
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<Void> close() {
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, Void>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<Void> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return _call.closeSend();
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<
              io.v.x.ref.services.syncbase.server.interfaces.ChunkHash>
          recv() {
        final java.lang.reflect.Type recvType =
            io.v.x.ref.services.syncbase.server.interfaces.ChunkHash.class;
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall,
                    io.v.x.ref.services.syncbase.server.interfaces.ChunkHash>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<
                          io.v.x.ref.services.syncbase.server.interfaces.ChunkHash>
                      apply(final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return com.google.common.util.concurrent.Futures.transform(
                        _call.recv(recvType),
                        new com.google.common.base.Function<
                            Object, io.v.x.ref.services.syncbase.server.interfaces.ChunkHash>() {
                          @Override
                          public io.v.x.ref.services.syncbase.server.interfaces.ChunkHash apply(
                              Object result) {
                            return (io.v.x.ref.services.syncbase.server.interfaces.ChunkHash)
                                result;
                          }
                        });
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<
              io.v.x.ref.services.syncbase.server.interfaces.BlobSharesBySyncgroup>
          finish() {

        final java.lang.reflect.Type[] resultTypes =
            new java.lang.reflect.Type[] {
              new com.google.common.reflect.TypeToken<
                  io.v.x.ref.services.syncbase.server.interfaces
                      .BlobSharesBySyncgroup>() {}.getType(),
            };

        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall,
                    io.v.x.ref.services.syncbase.server.interfaces.BlobSharesBySyncgroup>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<
                          io.v.x.ref.services.syncbase.server.interfaces.BlobSharesBySyncgroup>
                      apply(final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return com.google.common.util.concurrent.Futures.transform(
                        _call.finish(resultTypes),
                        new com.google.common.base.Function<
                            Object[],
                            io.v.x.ref.services.syncbase.server.interfaces
                                .BlobSharesBySyncgroup>() {
                          @Override
                          public io.v.x.ref.services.syncbase.server.interfaces
                                  .BlobSharesBySyncgroup
                              apply(Object[] _results) {

                            return (io.v.x.ref.services.syncbase.server.interfaces
                                    .BlobSharesBySyncgroup)
                                _results[0];
                          }
                        });
                  }
                }));
      }
    };
  }

  @Override
  public io.v.v23.vdl.ClientStream<
          io.v.x.ref.services.syncbase.server.interfaces.ChunkHash,
          io.v.x.ref.services.syncbase.server.interfaces.ChunkData, java.lang.Void>
      fetchChunks(io.v.v23.context.VContext _context) {
    return fetchChunks(_context, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public io.v.v23.vdl.ClientStream<
          io.v.x.ref.services.syncbase.server.interfaces.ChunkHash,
          io.v.x.ref.services.syncbase.server.interfaces.ChunkData, java.lang.Void>
      fetchChunks(final io.v.v23.context.VContext _context, io.v.v23.Options _opts) {
    return fetchChunks(_context, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public io.v.v23.vdl.ClientStream<
          io.v.x.ref.services.syncbase.server.interfaces.ChunkHash,
          io.v.x.ref.services.syncbase.server.interfaces.ChunkData, java.lang.Void>
      fetchChunks(final io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "fetchChunks", _args, _argTypes, _opts);

    return new io.v.v23.vdl.ClientStream<
        io.v.x.ref.services.syncbase.server.interfaces.ChunkHash,
        io.v.x.ref.services.syncbase.server.interfaces.ChunkData, java.lang.Void>() {
      @Override
      public com.google.common.util.concurrent.ListenableFuture<Void> send(
          final io.v.x.ref.services.syncbase.server.interfaces.ChunkHash item) {
        final java.lang.reflect.Type type =
            io.v.x.ref.services.syncbase.server.interfaces.ChunkHash.class;
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, Void>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<Void> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return _call.send(item, type);
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<Void> close() {
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, Void>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<Void> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return _call.closeSend();
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<
              io.v.x.ref.services.syncbase.server.interfaces.ChunkData>
          recv() {
        final java.lang.reflect.Type recvType =
            io.v.x.ref.services.syncbase.server.interfaces.ChunkData.class;
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall,
                    io.v.x.ref.services.syncbase.server.interfaces.ChunkData>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<
                          io.v.x.ref.services.syncbase.server.interfaces.ChunkData>
                      apply(final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return com.google.common.util.concurrent.Futures.transform(
                        _call.recv(recvType),
                        new com.google.common.base.Function<
                            Object, io.v.x.ref.services.syncbase.server.interfaces.ChunkData>() {
                          @Override
                          public io.v.x.ref.services.syncbase.server.interfaces.ChunkData apply(
                              Object result) {
                            return (io.v.x.ref.services.syncbase.server.interfaces.ChunkData)
                                result;
                          }
                        });
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> finish() {

        final java.lang.reflect.Type[] resultTypes = new java.lang.reflect.Type[] {};

        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, java.lang.Void>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return com.google.common.util.concurrent.Futures.transform(
                        _call.finish(resultTypes),
                        new com.google.common.base.Function<Object[], java.lang.Void>() {
                          @Override
                          public java.lang.Void apply(Object[] _results) {

                            return null;
                          }
                        });
                  }
                }));
      }
    };
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> requestTakeBlob(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.BlobRef br,
      final java.lang.String callerName,
      final io.v.x.ref.services.syncbase.server.interfaces.BlobSharesBySyncgroup shares) {
    return requestTakeBlob(_context, br, callerName, shares, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> requestTakeBlob(
      final io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.BlobRef br,
      final java.lang.String callerName,
      final io.v.x.ref.services.syncbase.server.interfaces.BlobSharesBySyncgroup shares,
      io.v.v23.Options _opts) {
    return requestTakeBlob(
        _context, br, callerName, shares, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> requestTakeBlob(
      final io.v.v23.context.VContext _context,
      final io.v.v23.services.syncbase.BlobRef br,
      final java.lang.String callerName,
      final io.v.x.ref.services.syncbase.server.interfaces.BlobSharesBySyncgroup shares,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {br, callerName, shares};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {
          io.v.v23.services.syncbase.BlobRef.class,
          java.lang.String.class,
          new com.google.common.reflect.TypeToken<
              io.v.x.ref.services.syncbase.server.interfaces.BlobSharesBySyncgroup>() {}.getType()
        };
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context)
            .startCall(_context, this.vName, "requestTakeBlob", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Void>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes = new java.lang.reflect.Type[] {};

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Void>() {
                      @Override
                      public java.lang.Void apply(Object[] _results) {

                        return null;
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.services.syncbase.server.interfaces.SyncClient.AcceptedBlobOwnershipOut>
      acceptedBlobOwnership(
          io.v.v23.context.VContext _context,
          final io.v.v23.services.syncbase.BlobRef br,
          final java.lang.String callerName,
          final io.v.x.ref.services.syncbase.server.interfaces.BlobSharesBySyncgroup shares) {
    return acceptedBlobOwnership(
        _context, br, callerName, shares, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.services.syncbase.server.interfaces.SyncClient.AcceptedBlobOwnershipOut>
      acceptedBlobOwnership(
          final io.v.v23.context.VContext _context,
          final io.v.v23.services.syncbase.BlobRef br,
          final java.lang.String callerName,
          final io.v.x.ref.services.syncbase.server.interfaces.BlobSharesBySyncgroup shares,
          io.v.v23.Options _opts) {
    return acceptedBlobOwnership(
        _context, br, callerName, shares, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.services.syncbase.server.interfaces.SyncClient.AcceptedBlobOwnershipOut>
      acceptedBlobOwnership(
          final io.v.v23.context.VContext _context,
          final io.v.v23.services.syncbase.BlobRef br,
          final java.lang.String callerName,
          final io.v.x.ref.services.syncbase.server.interfaces.BlobSharesBySyncgroup shares,
          io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {br, callerName, shares};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {
          io.v.v23.services.syncbase.BlobRef.class,
          java.lang.String.class,
          new com.google.common.reflect.TypeToken<
              io.v.x.ref.services.syncbase.server.interfaces.BlobSharesBySyncgroup>() {}.getType()
        };
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context)
            .startCall(_context, this.vName, "acceptedBlobOwnership", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall,
                io.v.x.ref.services.syncbase.server.interfaces.SyncClient
                    .AcceptedBlobOwnershipOut>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<
                      io.v.x.ref.services.syncbase.server.interfaces.SyncClient
                          .AcceptedBlobOwnershipOut>
                  apply(final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      java.lang.String.class, java.lang.Boolean.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<
                        Object[],
                        io.v.x.ref.services.syncbase.server.interfaces.SyncClient
                            .AcceptedBlobOwnershipOut>() {
                      @Override
                      public io.v.x.ref.services.syncbase.server.interfaces.SyncClient
                              .AcceptedBlobOwnershipOut
                          apply(Object[] _results) {

                        io.v.x.ref.services.syncbase.server.interfaces.SyncClient
                                .AcceptedBlobOwnershipOut
                            _ret =
                                new io.v.x.ref.services.syncbase.server.interfaces.SyncClient
                                    .AcceptedBlobOwnershipOut();

                        _ret.serverName = (java.lang.String) _results[0];

                        _ret.keepingBlob = (java.lang.Boolean) _results[1];

                        return _ret;
                      }
                    });
              }
            }));
  }
}
