// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  sync.vdl
package io.v.x.ref.services.syncbase.server.interfaces;

/**
 * Factory for {@link SyncClient}s.
 */
public final class SyncClientFactory {
  /**
   * Creates a new {@link SyncClient}, binding it to the provided name.
   *
   * @param name name to bind to
   */
  public static SyncClient getSyncClient(java.lang.String name) {
    return getSyncClient(name, null);
  }

  /**
   * Creates a new {@link SyncClient}, binding it to the provided name and using the
   * provided options.  Currently supported options are:
   * <p><ul>
   * <li>{@link io.v.v23.OptionDefs#CLIENT}, which specifies a {@link io.v.v23.rpc.Client} to use for all rpc calls.</li>
   * </ul>
   *
   * @param name name to bind to
   * @param opts creation options
   */
  public static SyncClient getSyncClient(java.lang.String name, io.v.v23.Options opts) {
    io.v.v23.rpc.Client client = null;
    if (opts != null && opts.get(io.v.v23.OptionDefs.CLIENT) != null) {
      client = opts.get(io.v.v23.OptionDefs.CLIENT, io.v.v23.rpc.Client.class);
    }
    return new SyncClientImpl(client, name);
  }

  private SyncClientFactory() {}
}
