// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: sync_types.vdl
package io.v.x.ref.services.syncbase.server.interfaces;

/**
 * A Signpost is a hint to syncbase of the device on which a blob may be found.
 * It represents the data known about a blob even when the blob itself is not
 * present on the device.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/x/ref/services/syncbase/server/interfaces.Signpost")
public class Signpost extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Locations", index = 0)
  private io.v.x.ref.services.syncbase.server.interfaces.PeerToLocationDataMap locations;

  @io.v.v23.vdl.GeneratedFromVdl(name = "SgIds", index = 1)
  private java.util.Set<io.v.x.ref.services.syncbase.server.interfaces.GroupId> sgIds;

  /**
   * Vdl type for {@link Signpost}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(Signpost.class);

  /**
   * Creates a new zero-value instance of {@link Signpost}.
   */
  public Signpost() {
    super(VDL_TYPE);

    this.locations = new io.v.x.ref.services.syncbase.server.interfaces.PeerToLocationDataMap();

    this.sgIds = new java.util.HashSet<io.v.x.ref.services.syncbase.server.interfaces.GroupId>();
  }

  /**
   * Creates a new instance of {@link Signpost} with the provided field values.
   */
  public Signpost(
      io.v.x.ref.services.syncbase.server.interfaces.PeerToLocationDataMap locations,
      java.util.Set<io.v.x.ref.services.syncbase.server.interfaces.GroupId> sgIds) {
    super(VDL_TYPE);

    this.locations = locations;

    this.sgIds = sgIds;
  }

  /**
   * Maps name of syncbase that probably has the blob to a LocationData
   */
  public io.v.x.ref.services.syncbase.server.interfaces.PeerToLocationDataMap getLocations() {
    return this.locations;
  }

  /**
   * Maps name of syncbase that probably has the blob to a LocationData
   */
  public void setLocations(
      io.v.x.ref.services.syncbase.server.interfaces.PeerToLocationDataMap locations) {
    this.locations = locations;
  }

  /**
   * SyncGroups through which the BlobRef was learned.
   */
  public java.util.Set<io.v.x.ref.services.syncbase.server.interfaces.GroupId> getSgIds() {
    return this.sgIds;
  }

  /**
   * SyncGroups through which the BlobRef was learned.
   */
  public void setSgIds(
      java.util.Set<io.v.x.ref.services.syncbase.server.interfaces.GroupId> sgIds) {
    this.sgIds = sgIds;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    Signpost other = (Signpost) obj;

    if (this.locations == null) {
      if (other.locations != null) {
        return false;
      }
    } else if (!this.locations.equals(other.locations)) {
      return false;
    }

    if (this.sgIds == null) {
      if (other.sgIds != null) {
        return false;
      }
    } else if (!this.sgIds.equals(other.sgIds)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.locations == null ? 0 : this.locations.hashCode());

    result = prime * result + (this.sgIds == null ? 0 : this.sgIds.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "locations:" + this.locations;

    result += ", ";

    result += "sgIds:" + this.sgIds;

    return result + "}";
  }
}
