// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: sync_types.vdl
package io.v.x.ref.services.syncbase.server.interfaces;

/**
 * A SgPriority represents data used to decide whether to transfer blob ownership
 * between two devices.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/x/ref/services/syncbase/server/interfaces.SgPriority")
public class SgPriority extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "DevType", index = 0)
  private int devType;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Distance", index = 1)
  private float distance;

  @io.v.v23.vdl.GeneratedFromVdl(name = "ServerTime", index = 2)
  private org.joda.time.DateTime serverTime;

  /**
   * Vdl type for {@link SgPriority}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(SgPriority.class);

  /**
   * Creates a new zero-value instance of {@link SgPriority}.
   */
  public SgPriority() {
    super(VDL_TYPE);

    this.devType = 0;

    this.distance = 0.0f;

    this.serverTime = null;
  }

  /**
   * Creates a new instance of {@link SgPriority} with the provided field values.
   */
  public SgPriority(int devType, float distance, org.joda.time.DateTime serverTime) {
    super(VDL_TYPE);

    this.devType = devType;

    this.distance = distance;

    this.serverTime = serverTime;
  }

  /**
   * device type (BlobDevTypeServer, BlobDevTypeNormal, BlobDevTypeLeaf)
   */
  public int getDevType() {
    return this.devType;
  }

  /**
   * device type (BlobDevTypeServer, BlobDevTypeNormal, BlobDevTypeLeaf)
   */
  public void setDevType(int devType) {
    this.devType = devType;
  }

  /**
   * mean number of hops from a server-quality member of the syncgroup
   */
  public float getDistance() {
    return this.distance;
  }

  /**
   * mean number of hops from a server-quality member of the syncgroup
   */
  public void setDistance(float distance) {
    this.distance = distance;
  }

  /**
   * when data from a server-quality member reached this device
   */
  public org.joda.time.DateTime getServerTime() {
    return this.serverTime;
  }

  /**
   * when data from a server-quality member reached this device
   */
  public void setServerTime(org.joda.time.DateTime serverTime) {
    this.serverTime = serverTime;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    SgPriority other = (SgPriority) obj;

    if (this.devType != other.devType) {
      return false;
    }

    if (this.distance != other.distance) {
      return false;
    }

    if (this.serverTime == null) {
      if (other.serverTime != null) {
        return false;
      }
    } else if (!this.serverTime.equals(other.serverTime)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + this.devType;

    result = prime * result + java.lang.Float.valueOf(this.distance).hashCode();

    result = prime * result + (this.serverTime == null ? 0 : this.serverTime.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "devType:" + this.devType;

    result += ", ";

    result += "distance:" + this.distance;

    result += ", ";

    result += "serverTime:" + this.serverTime;

    return result + "}";
  }
}
