// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: sync_types.vdl
package io.v.x.ref.services.syncbase.server.interfaces;

/**
 * LogRecMetadata represents the metadata of a single log record that is
 * exchanged between two peers. Each log record represents a change made to an
 * object in the store.
 *<p>
 * TODO(hpucha): Add readset/scanset. Look into sending tx metadata only once
 * per transaction.
 */
@io.v.v23.vdl.GeneratedFromVdl(
  name = "v.io/x/ref/services/syncbase/server/interfaces.LogRecMetadata"
)
public class LogRecMetadata extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Id", index = 0)
  private io.v.v23.vdl.VdlUint64 id;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Gen", index = 1)
  private io.v.v23.vdl.VdlUint64 gen;

  @io.v.v23.vdl.GeneratedFromVdl(name = "RecType", index = 2)
  private byte recType;

  @io.v.v23.vdl.GeneratedFromVdl(name = "ObjId", index = 3)
  private java.lang.String objId;

  @io.v.v23.vdl.GeneratedFromVdl(name = "CurVers", index = 4)
  private java.lang.String curVers;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Parents", index = 5)
  private java.util.List<java.lang.String> parents;

  @io.v.v23.vdl.GeneratedFromVdl(name = "UpdTime", index = 6)
  private org.joda.time.DateTime updTime;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Delete", index = 7)
  private boolean delete;

  @io.v.v23.vdl.GeneratedFromVdl(name = "BatchId", index = 8)
  private io.v.v23.vdl.VdlUint64 batchId;

  @io.v.v23.vdl.GeneratedFromVdl(name = "BatchCount", index = 9)
  private io.v.v23.vdl.VdlUint64 batchCount;

  /**
   * Vdl type for {@link LogRecMetadata}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(LogRecMetadata.class);

  /**
   * Creates a new zero-value instance of {@link LogRecMetadata}.
   */
  public LogRecMetadata() {
    super(VDL_TYPE);

    this.id = new io.v.v23.vdl.VdlUint64();

    this.gen = new io.v.v23.vdl.VdlUint64();

    this.recType = (byte) 0;

    this.objId = "";

    this.curVers = "";

    this.parents = new java.util.ArrayList<java.lang.String>();

    this.updTime = null;

    this.delete = false;

    this.batchId = new io.v.v23.vdl.VdlUint64();

    this.batchCount = new io.v.v23.vdl.VdlUint64();
  }

  /**
   * Creates a new instance of {@link LogRecMetadata} with the provided field values.
   */
  public LogRecMetadata(
      io.v.v23.vdl.VdlUint64 id,
      io.v.v23.vdl.VdlUint64 gen,
      byte recType,
      java.lang.String objId,
      java.lang.String curVers,
      java.util.List<java.lang.String> parents,
      org.joda.time.DateTime updTime,
      boolean delete,
      io.v.v23.vdl.VdlUint64 batchId,
      io.v.v23.vdl.VdlUint64 batchCount) {
    super(VDL_TYPE);

    this.id = id;

    this.gen = gen;

    this.recType = recType;

    this.objId = objId;

    this.curVers = curVers;

    this.parents = parents;

    this.updTime = updTime;

    this.delete = delete;

    this.batchId = batchId;

    this.batchCount = batchCount;
  }

  /**
   * Log related information.
   * device id that created the log record.
   */
  public io.v.v23.vdl.VdlUint64 getId() {
    return this.id;
  }

  /**
   * Log related information.
   * device id that created the log record.
   */
  public void setId(io.v.v23.vdl.VdlUint64 id) {
    this.id = id;
  }

  /**
   * generation number for the log record.
   */
  public io.v.v23.vdl.VdlUint64 getGen() {
    return this.gen;
  }

  /**
   * generation number for the log record.
   */
  public void setGen(io.v.v23.vdl.VdlUint64 gen) {
    this.gen = gen;
  }

  /**
   * type of log record.
   */
  public byte getRecType() {
    return this.recType;
  }

  /**
   * type of log record.
   */
  public void setRecType(byte recType) {
    this.recType = recType;
  }

  /**
   * Id of the object that was updated. This id is relative to Application
   * and Database names and is the store key for a particular row in a
   * collection.
   */
  public java.lang.String getObjId() {
    return this.objId;
  }

  /**
   * Id of the object that was updated. This id is relative to Application
   * and Database names and is the store key for a particular row in a
   * collection.
   */
  public void setObjId(java.lang.String objId) {
    this.objId = objId;
  }

  /**
   * current version number of the object.
   */
  public java.lang.String getCurVers() {
    return this.curVers;
  }

  /**
   * current version number of the object.
   */
  public void setCurVers(java.lang.String curVers) {
    this.curVers = curVers;
  }

  /**
   * 0, 1 or 2 parent versions that the current version is derived from.
   */
  public java.util.List<java.lang.String> getParents() {
    return this.parents;
  }

  /**
   * 0, 1 or 2 parent versions that the current version is derived from.
   */
  public void setParents(java.util.List<java.lang.String> parents) {
    this.parents = parents;
  }

  /**
   * timestamp when the update is generated.
   */
  public org.joda.time.DateTime getUpdTime() {
    return this.updTime;
  }

  /**
   * timestamp when the update is generated.
   */
  public void setUpdTime(org.joda.time.DateTime updTime) {
    this.updTime = updTime;
  }

  /**
   * indicates whether the update resulted in object being deleted from the store.
   */
  public boolean getDelete() {
    return this.delete;
  }

  /**
   * indicates whether the update resulted in object being deleted from the store.
   */
  public void setDelete(boolean delete) {
    this.delete = delete;
  }

  /**
   * unique id of the Batch this update belongs to.
   */
  public io.v.v23.vdl.VdlUint64 getBatchId() {
    return this.batchId;
  }

  /**
   * unique id of the Batch this update belongs to.
   */
  public void setBatchId(io.v.v23.vdl.VdlUint64 batchId) {
    this.batchId = batchId;
  }

  /**
   * number of objects in the Batch.
   */
  public io.v.v23.vdl.VdlUint64 getBatchCount() {
    return this.batchCount;
  }

  /**
   * number of objects in the Batch.
   */
  public void setBatchCount(io.v.v23.vdl.VdlUint64 batchCount) {
    this.batchCount = batchCount;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    LogRecMetadata other = (LogRecMetadata) obj;

    if (this.id == null) {
      if (other.id != null) {
        return false;
      }
    } else if (!this.id.equals(other.id)) {
      return false;
    }

    if (this.gen == null) {
      if (other.gen != null) {
        return false;
      }
    } else if (!this.gen.equals(other.gen)) {
      return false;
    }

    if (this.recType != other.recType) {
      return false;
    }

    if (this.objId == null) {
      if (other.objId != null) {
        return false;
      }
    } else if (!this.objId.equals(other.objId)) {
      return false;
    }

    if (this.curVers == null) {
      if (other.curVers != null) {
        return false;
      }
    } else if (!this.curVers.equals(other.curVers)) {
      return false;
    }

    if (this.parents == null) {
      if (other.parents != null) {
        return false;
      }
    } else if (!this.parents.equals(other.parents)) {
      return false;
    }

    if (this.updTime == null) {
      if (other.updTime != null) {
        return false;
      }
    } else if (!this.updTime.equals(other.updTime)) {
      return false;
    }

    if (this.delete != other.delete) {
      return false;
    }

    if (this.batchId == null) {
      if (other.batchId != null) {
        return false;
      }
    } else if (!this.batchId.equals(other.batchId)) {
      return false;
    }

    if (this.batchCount == null) {
      if (other.batchCount != null) {
        return false;
      }
    } else if (!this.batchCount.equals(other.batchCount)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.id == null ? 0 : this.id.hashCode());

    result = prime * result + (this.gen == null ? 0 : this.gen.hashCode());

    result = prime * result + (int) this.recType;

    result = prime * result + (this.objId == null ? 0 : this.objId.hashCode());

    result = prime * result + (this.curVers == null ? 0 : this.curVers.hashCode());

    result = prime * result + (this.parents == null ? 0 : this.parents.hashCode());

    result = prime * result + (this.updTime == null ? 0 : this.updTime.hashCode());

    result = prime * result + java.lang.Boolean.valueOf(this.delete).hashCode();

    result = prime * result + (this.batchId == null ? 0 : this.batchId.hashCode());

    result = prime * result + (this.batchCount == null ? 0 : this.batchCount.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "id:" + this.id;

    result += ", ";

    result += "gen:" + this.gen;

    result += ", ";

    result += "recType:" + this.recType;

    result += ", ";

    result += "objId:" + this.objId;

    result += ", ";

    result += "curVers:" + this.curVers;

    result += ", ";

    result += "parents:" + this.parents;

    result += ", ";

    result += "updTime:" + this.updTime;

    result += ", ";

    result += "delete:" + this.delete;

    result += ", ";

    result += "batchId:" + this.batchId;

    result += ", ";

    result += "batchCount:" + this.batchCount;

    return result + "}";
  }
}
