// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: sync_types.vdl
package io.v.x.ref.services.syncbase.server.interfaces;

/**
 * A LocationData is the information known about a particular location in a Signpost.
 * TODO(m3b): Include mount table information to allow the location to be found.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/x/ref/services/syncbase/server/interfaces.LocationData")
public class LocationData extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "WhenSeen", index = 0)
  private org.joda.time.DateTime whenSeen;

  @io.v.v23.vdl.GeneratedFromVdl(name = "IsProxy", index = 1)
  private boolean isProxy;

  @io.v.v23.vdl.GeneratedFromVdl(name = "IsServer", index = 2)
  private boolean isServer;

  /**
   * Vdl type for {@link LocationData}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(LocationData.class);

  /**
   * Creates a new zero-value instance of {@link LocationData}.
   */
  public LocationData() {
    super(VDL_TYPE);

    this.whenSeen = null;

    this.isProxy = false;

    this.isServer = false;
  }

  /**
   * Creates a new instance of {@link LocationData} with the provided field values.
   */
  public LocationData(org.joda.time.DateTime whenSeen, boolean isProxy, boolean isServer) {
    super(VDL_TYPE);

    this.whenSeen = whenSeen;

    this.isProxy = isProxy;

    this.isServer = isServer;
  }

  /**
   * most recent time when blob thought to have been at location
   */
  public org.joda.time.DateTime getWhenSeen() {
    return this.whenSeen;
  }

  /**
   * most recent time when blob thought to have been at location
   */
  public void setWhenSeen(org.joda.time.DateTime whenSeen) {
    this.whenSeen = whenSeen;
  }

  /**
   * whether the location is a likely proxy to another syncgroup
   */
  public boolean getIsProxy() {
    return this.isProxy;
  }

  /**
   * whether the location is a likely proxy to another syncgroup
   */
  public void setIsProxy(boolean isProxy) {
    this.isProxy = isProxy;
  }

  /**
   * whether the location is a server that may be revealed outside its syncgroup
   */
  public boolean getIsServer() {
    return this.isServer;
  }

  /**
   * whether the location is a server that may be revealed outside its syncgroup
   */
  public void setIsServer(boolean isServer) {
    this.isServer = isServer;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    LocationData other = (LocationData) obj;

    if (this.whenSeen == null) {
      if (other.whenSeen != null) {
        return false;
      }
    } else if (!this.whenSeen.equals(other.whenSeen)) {
      return false;
    }

    if (this.isProxy != other.isProxy) {
      return false;
    }

    if (this.isServer != other.isServer) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.whenSeen == null ? 0 : this.whenSeen.hashCode());

    result = prime * result + java.lang.Boolean.valueOf(this.isProxy).hashCode();

    result = prime * result + java.lang.Boolean.valueOf(this.isServer).hashCode();

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "whenSeen:" + this.whenSeen;

    result += ", ";

    result += "isProxy:" + this.isProxy;

    result += ", ";

    result += "isServer:" + this.isServer;

    return result + "}";
  }
}
