// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.x.ref.services.syncbase.server;

/**
 * DbInfo contains information about a single Database, stored in the
 * service-level storage engine.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/x/ref/services/syncbase/server.DbInfo")
public class DbInfo extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Id", index = 0)
  private io.v.v23.services.syncbase.Id id;

  @io.v.v23.vdl.GeneratedFromVdl(name = "RootDir", index = 1)
  private java.lang.String rootDir;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Engine", index = 2)
  private java.lang.String engine;

  /**
   * Vdl type for {@link DbInfo}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(DbInfo.class);

  /**
   * Creates a new zero-value instance of {@link DbInfo}.
   */
  public DbInfo() {
    super(VDL_TYPE);

    this.id = new io.v.v23.services.syncbase.Id();

    this.rootDir = "";

    this.engine = "";
  }

  /**
   * Creates a new instance of {@link DbInfo} with the provided field values.
   */
  public DbInfo(
      io.v.v23.services.syncbase.Id id, java.lang.String rootDir, java.lang.String engine) {
    super(VDL_TYPE);

    this.id = id;

    this.rootDir = rootDir;

    this.engine = engine;
  }

  public io.v.v23.services.syncbase.Id getId() {
    return this.id;
  }

  public void setId(io.v.v23.services.syncbase.Id id) {
    this.id = id;
  }

  /**
   * Select fields from DatabaseOptions, needed in order to open storage engine
   * on restart.
   * interpreted by storage engine
   */
  public java.lang.String getRootDir() {
    return this.rootDir;
  }

  /**
   * Select fields from DatabaseOptions, needed in order to open storage engine
   * on restart.
   * interpreted by storage engine
   */
  public void setRootDir(java.lang.String rootDir) {
    this.rootDir = rootDir;
  }

  /**
   * name of storage engine, e.g. "leveldb"
   */
  public java.lang.String getEngine() {
    return this.engine;
  }

  /**
   * name of storage engine, e.g. "leveldb"
   */
  public void setEngine(java.lang.String engine) {
    this.engine = engine;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    DbInfo other = (DbInfo) obj;

    if (this.id == null) {
      if (other.id != null) {
        return false;
      }
    } else if (!this.id.equals(other.id)) {
      return false;
    }

    if (this.rootDir == null) {
      if (other.rootDir != null) {
        return false;
      }
    } else if (!this.rootDir.equals(other.rootDir)) {
      return false;
    }

    if (this.engine == null) {
      if (other.engine != null) {
        return false;
      }
    } else if (!this.engine.equals(other.engine)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.id == null ? 0 : this.id.hashCode());

    result = prime * result + (this.rootDir == null ? 0 : this.rootDir.hashCode());

    result = prime * result + (this.engine == null ? 0 : this.engine.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "id:" + this.id;

    result += ", ";

    result += "rootDir:" + this.rootDir;

    result += ", ";

    result += "engine:" + this.engine;

    return result + "}";
  }
}
