// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.x.ref.services.syncbase.localblobstore;

/**
 * A BlobMetadata describes information that syncbase stores for a blob it
 * holds, independent of the actual content.  Compare with a Signpost, which
 * may be stored for a blob that the current device does not hold (and
 * indicates where it may be found).  (See
 * v.io/x/ref/services/syncbase/server/interfaces/sync_types.vdl for the
 * Signpost definition.)
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/x/ref/services/syncbase/localblobstore.BlobMetadata")
public class BlobMetadata extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "OwnerShares", index = 0)
  private io.v.x.ref.services.syncbase.server.interfaces.BlobSharesBySyncgroup ownerShares;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Referenced", index = 1)
  private org.joda.time.DateTime referenced;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Accessed", index = 2)
  private org.joda.time.DateTime accessed;

  /**
   * Vdl type for {@link BlobMetadata}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(BlobMetadata.class);

  /**
   * Creates a new zero-value instance of {@link BlobMetadata}.
   */
  public BlobMetadata() {
    super(VDL_TYPE);

    this.ownerShares = new io.v.x.ref.services.syncbase.server.interfaces.BlobSharesBySyncgroup();

    this.referenced = null;

    this.accessed = null;
  }

  /**
   * Creates a new instance of {@link BlobMetadata} with the provided field values.
   */
  public BlobMetadata(
      io.v.x.ref.services.syncbase.server.interfaces.BlobSharesBySyncgroup ownerShares,
      org.joda.time.DateTime referenced,
      org.joda.time.DateTime accessed) {
    super(VDL_TYPE);

    this.ownerShares = ownerShares;

    this.referenced = referenced;

    this.accessed = accessed;
  }

  /**
   * >0 for any group => syncbase must keep blob.
   */
  public io.v.x.ref.services.syncbase.server.interfaces.BlobSharesBySyncgroup getOwnerShares() {
    return this.ownerShares;
  }

  /**
   * >0 for any group => syncbase must keep blob.
   */
  public void setOwnerShares(
      io.v.x.ref.services.syncbase.server.interfaces.BlobSharesBySyncgroup ownerShares) {
    this.ownerShares = ownerShares;
  }

  /**
   * When structured-store reference to blob last seen.
   */
  public org.joda.time.DateTime getReferenced() {
    return this.referenced;
  }

  /**
   * When structured-store reference to blob last seen.
   */
  public void setReferenced(org.joda.time.DateTime referenced) {
    this.referenced = referenced;
  }

  /**
   * Last attempted access.
   */
  public org.joda.time.DateTime getAccessed() {
    return this.accessed;
  }

  /**
   * Last attempted access.
   */
  public void setAccessed(org.joda.time.DateTime accessed) {
    this.accessed = accessed;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    BlobMetadata other = (BlobMetadata) obj;

    if (this.ownerShares == null) {
      if (other.ownerShares != null) {
        return false;
      }
    } else if (!this.ownerShares.equals(other.ownerShares)) {
      return false;
    }

    if (this.referenced == null) {
      if (other.referenced != null) {
        return false;
      }
    } else if (!this.referenced.equals(other.referenced)) {
      return false;
    }

    if (this.accessed == null) {
      if (other.accessed != null) {
        return false;
      }
    } else if (!this.accessed.equals(other.accessed)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.ownerShares == null ? 0 : this.ownerShares.hashCode());

    result = prime * result + (this.referenced == null ? 0 : this.referenced.hashCode());

    result = prime * result + (this.accessed == null ? 0 : this.accessed.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "ownerShares:" + this.ownerShares;

    result += ", ";

    result += "referenced:" + this.referenced;

    result += ", ";

    result += "accessed:" + this.accessed;

    return result + "}";
  }
}
