// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.x.ref.services.stats;

/**
 * HistogramValue is the value of Histogram objects.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/x/ref/services/stats.HistogramValue")
public class HistogramValue extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Count", index = 0)
  private long count;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Sum", index = 1)
  private long sum;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Min", index = 2)
  private long min;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Max", index = 3)
  private long max;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Buckets", index = 4)
  private java.util.List<io.v.x.ref.services.stats.HistogramBucket> buckets;

  /**
   * Vdl type for {@link HistogramValue}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(HistogramValue.class);

  /**
   * Creates a new zero-value instance of {@link HistogramValue}.
   */
  public HistogramValue() {
    super(VDL_TYPE);

    this.count = 0L;

    this.sum = 0L;

    this.min = 0L;

    this.max = 0L;

    this.buckets = new java.util.ArrayList<io.v.x.ref.services.stats.HistogramBucket>();
  }

  /**
   * Creates a new instance of {@link HistogramValue} with the provided field values.
   */
  public HistogramValue(
      long count,
      long sum,
      long min,
      long max,
      java.util.List<io.v.x.ref.services.stats.HistogramBucket> buckets) {
    super(VDL_TYPE);

    this.count = count;

    this.sum = sum;

    this.min = min;

    this.max = max;

    this.buckets = buckets;
  }

  /**
   * Count is the total number of values added to the histogram.
   */
  public long getCount() {
    return this.count;
  }

  /**
   * Count is the total number of values added to the histogram.
   */
  public void setCount(long count) {
    this.count = count;
  }

  /**
   * Sum is the sum of all the values added to the histogram.
   */
  public long getSum() {
    return this.sum;
  }

  /**
   * Sum is the sum of all the values added to the histogram.
   */
  public void setSum(long sum) {
    this.sum = sum;
  }

  /**
   * Min is the minimum of all the values added to the histogram.
   */
  public long getMin() {
    return this.min;
  }

  /**
   * Min is the minimum of all the values added to the histogram.
   */
  public void setMin(long min) {
    this.min = min;
  }

  /**
   * Max is the maximum of all the values added to the histogram.
   */
  public long getMax() {
    return this.max;
  }

  /**
   * Max is the maximum of all the values added to the histogram.
   */
  public void setMax(long max) {
    this.max = max;
  }

  /**
   * Buckets contains all the buckets of the histogram.
   */
  public java.util.List<io.v.x.ref.services.stats.HistogramBucket> getBuckets() {
    return this.buckets;
  }

  /**
   * Buckets contains all the buckets of the histogram.
   */
  public void setBuckets(java.util.List<io.v.x.ref.services.stats.HistogramBucket> buckets) {
    this.buckets = buckets;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    HistogramValue other = (HistogramValue) obj;

    if (this.count != other.count) {
      return false;
    }

    if (this.sum != other.sum) {
      return false;
    }

    if (this.min != other.min) {
      return false;
    }

    if (this.max != other.max) {
      return false;
    }

    if (this.buckets == null) {
      if (other.buckets != null) {
        return false;
      }
    } else if (!this.buckets.equals(other.buckets)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + java.lang.Long.valueOf(this.count).hashCode();

    result = prime * result + java.lang.Long.valueOf(this.sum).hashCode();

    result = prime * result + java.lang.Long.valueOf(this.min).hashCode();

    result = prime * result + java.lang.Long.valueOf(this.max).hashCode();

    result = prime * result + (this.buckets == null ? 0 : this.buckets.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "count:" + this.count;

    result += ", ";

    result += "sum:" + this.sum;

    result += ", ";

    result += "min:" + this.min;

    result += ", ";

    result += "max:" + this.max;

    result += ", ";

    result += "buckets:" + this.buckets;

    return result + "}";
  }
}
