// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.x.ref.services.stats;

/**
 * HistogramBucket is one histogram bucket.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/x/ref/services/stats.HistogramBucket")
public class HistogramBucket extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "LowBound", index = 0)
  private long lowBound;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Count", index = 1)
  private long count;

  /**
   * Vdl type for {@link HistogramBucket}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(HistogramBucket.class);

  /**
   * Creates a new zero-value instance of {@link HistogramBucket}.
   */
  public HistogramBucket() {
    super(VDL_TYPE);

    this.lowBound = 0L;

    this.count = 0L;
  }

  /**
   * Creates a new instance of {@link HistogramBucket} with the provided field values.
   */
  public HistogramBucket(long lowBound, long count) {
    super(VDL_TYPE);

    this.lowBound = lowBound;

    this.count = count;
  }

  /**
   * LowBound is the lower bound of the bucket.
   */
  public long getLowBound() {
    return this.lowBound;
  }

  /**
   * LowBound is the lower bound of the bucket.
   */
  public void setLowBound(long lowBound) {
    this.lowBound = lowBound;
  }

  /**
   * Count is the number of values in the bucket.
   */
  public long getCount() {
    return this.count;
  }

  /**
   * Count is the number of values in the bucket.
   */
  public void setCount(long count) {
    this.count = count;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    HistogramBucket other = (HistogramBucket) obj;

    if (this.lowBound != other.lowBound) {
      return false;
    }

    if (this.count != other.count) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + java.lang.Long.valueOf(this.lowBound).hashCode();

    result = prime * result + java.lang.Long.valueOf(this.count).hashCode();

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "lowBound:" + this.lowBound;

    result += ", ";

    result += "count:" + this.count;

    return result + "}";
  }
}
