// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: config.vdl
package io.v.x.ref.services.role.roled.internal;

/**
 * Config contains the attributes of the role, and the list of members who have
 * access to it.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/x/ref/services/role/roled/internal.Config")
public class Config extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "ImportMembers", index = 0)
  private java.util.List<java.lang.String> importMembers;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Members", index = 1)
  private java.util.List<io.v.v23.security.BlessingPattern> members;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Extend", index = 2)
  private boolean extend;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Audit", index = 3)
  private boolean audit;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Expiry", index = 4)
  private java.lang.String expiry;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Peers", index = 5)
  private java.util.List<io.v.v23.security.BlessingPattern> peers;

  /**
   * Vdl type for {@link Config}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(Config.class);

  /**
   * Creates a new zero-value instance of {@link Config}.
   */
  public Config() {
    super(VDL_TYPE);

    this.importMembers = new java.util.ArrayList<java.lang.String>();

    this.members = new java.util.ArrayList<io.v.v23.security.BlessingPattern>();

    this.extend = false;

    this.audit = false;

    this.expiry = "";

    this.peers = new java.util.ArrayList<io.v.v23.security.BlessingPattern>();
  }

  /**
   * Creates a new instance of {@link Config} with the provided field values.
   */
  public Config(
      java.util.List<java.lang.String> importMembers,
      java.util.List<io.v.v23.security.BlessingPattern> members,
      boolean extend,
      boolean audit,
      java.lang.String expiry,
      java.util.List<io.v.v23.security.BlessingPattern> peers) {
    super(VDL_TYPE);

    this.importMembers = importMembers;

    this.members = members;

    this.extend = extend;

    this.audit = audit;

    this.expiry = expiry;

    this.peers = peers;
  }

  /**
   * List of role objects, relative to this role, from which to import
   * the set of members. File path notation like "." and ".." may be used.
   * The set of members who have access to this role is the union of this
   * role's members and those of all the imported roles.
   */
  public java.util.List<java.lang.String> getImportMembers() {
    return this.importMembers;
  }

  /**
   * List of role objects, relative to this role, from which to import
   * the set of members. File path notation like "." and ".." may be used.
   * The set of members who have access to this role is the union of this
   * role's members and those of all the imported roles.
   */
  public void setImportMembers(java.util.List<java.lang.String> importMembers) {
    this.importMembers = importMembers;
  }

  /**
   * Blessings that match at least one of the patterns in this set are
   * allowed to act on behalf of the role.
   */
  public java.util.List<io.v.v23.security.BlessingPattern> getMembers() {
    return this.members;
  }

  /**
   * Blessings that match at least one of the patterns in this set are
   * allowed to act on behalf of the role.
   */
  public void setMembers(java.util.List<io.v.v23.security.BlessingPattern> members) {
    this.members = members;
  }

  /**
   * Indicates that the blessing name of the caller should be appended to
   * the role blessing name.
   */
  public boolean getExtend() {
    return this.extend;
  }

  /**
   * Indicates that the blessing name of the caller should be appended to
   * the role blessing name.
   */
  public void setExtend(boolean extend) {
    this.extend = extend;
  }

  /**
   * If Audit is true, each use of the role blessing will be reported to
   * an auditing service and will be usable only if the report was
   * successful.
   */
  public boolean getAudit() {
    return this.audit;
  }

  /**
   * If Audit is true, each use of the role blessing will be reported to
   * an auditing service and will be usable only if the report was
   * successful.
   */
  public void setAudit(boolean audit) {
    this.audit = audit;
  }

  /**
   * The amount of time for which the role blessing will be valid. It is a
   * string representation of a time.Duration, e.g. "24h". An empty string
   * indicates that the role blessing will not expire.
   */
  public java.lang.String getExpiry() {
    return this.expiry;
  }

  /**
   * The amount of time for which the role blessing will be valid. It is a
   * string representation of a time.Duration, e.g. "24h". An empty string
   * indicates that the role blessing will not expire.
   */
  public void setExpiry(java.lang.String expiry) {
    this.expiry = expiry;
  }

  /**
   * The blessings issued for this role will only be valid for
   * communicating with peers that match at least one of these patterns.
   * If the list is empty, all peers are allowed.
   */
  public java.util.List<io.v.v23.security.BlessingPattern> getPeers() {
    return this.peers;
  }

  /**
   * The blessings issued for this role will only be valid for
   * communicating with peers that match at least one of these patterns.
   * If the list is empty, all peers are allowed.
   */
  public void setPeers(java.util.List<io.v.v23.security.BlessingPattern> peers) {
    this.peers = peers;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    Config other = (Config) obj;

    if (this.importMembers == null) {
      if (other.importMembers != null) {
        return false;
      }
    } else if (!this.importMembers.equals(other.importMembers)) {
      return false;
    }

    if (this.members == null) {
      if (other.members != null) {
        return false;
      }
    } else if (!this.members.equals(other.members)) {
      return false;
    }

    if (this.extend != other.extend) {
      return false;
    }

    if (this.audit != other.audit) {
      return false;
    }

    if (this.expiry == null) {
      if (other.expiry != null) {
        return false;
      }
    } else if (!this.expiry.equals(other.expiry)) {
      return false;
    }

    if (this.peers == null) {
      if (other.peers != null) {
        return false;
      }
    } else if (!this.peers.equals(other.peers)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.importMembers == null ? 0 : this.importMembers.hashCode());

    result = prime * result + (this.members == null ? 0 : this.members.hashCode());

    result = prime * result + java.lang.Boolean.valueOf(this.extend).hashCode();

    result = prime * result + java.lang.Boolean.valueOf(this.audit).hashCode();

    result = prime * result + (this.expiry == null ? 0 : this.expiry.hashCode());

    result = prime * result + (this.peers == null ? 0 : this.peers.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "importMembers:" + this.importMembers;

    result += ", ";

    result += "members:" + this.members;

    result += ", ";

    result += "extend:" + this.extend;

    result += ", ";

    result += "audit:" + this.audit;

    result += ", ";

    result += "expiry:" + this.expiry;

    result += ", ";

    result += "peers:" + this.peers;

    return result + "}";
  }
}
