// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  role.vdl
package io.v.x.ref.services.role;

/**
 * Wrapper for {@link RoleServer}.  This wrapper is used by
 * {@link io.v.v23.rpc.ReflectInvoker} to indirectly invoke server methods.
 */
public final class RoleServerWrapper {
  private final io.v.x.ref.services.role.RoleServer server;

  /**
   * Creates a new {@link RoleServerWrapper} to invoke the methods of the
   * provided server.
   *
   * @param server server whose methods are to be invoked
   */
  public RoleServerWrapper(io.v.x.ref.services.role.RoleServer server) {
    this.server = server;
  }

  /**
   * Returns a description of this server.
   */
  public io.v.v23.vdlroot.signature.Interface signature() {
    java.util.List<io.v.v23.vdlroot.signature.Embed> embeds =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Embed>();
    java.util.List<io.v.v23.vdlroot.signature.Method> methods =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Method>();

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.v23.security.Blessings.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "seekBlessings", "", inArgs, outArgs, null, null, tags));
    }

    return new io.v.v23.vdlroot.signature.Interface(
        "Role",
        "io.v.x.ref.services.role",
        "// Role is an interface to request blessings from a role account server. The"
            + "// returned blessings are bound to the client's public key thereby authorizing"
            + "// the client to acquire the role. The server may tie the returned blessings"
            + "// with the client's presented blessing name in order to maintain audit"
            + "// information in the blessing."
            + "//"
            + "// In order to avoid granting role blessings to all delegates of a principal,"
            + "// the role server requires that each authorized blessing presented by the"
            + "// client have the string \"_role\" as suffix."
            + "",
        embeds,
        methods);
  }

  /**
   * Returns all tags associated with the provided method or {@code null} if the method isn't
   * implemented by this server.
   *
   * @param method method whose tags are to be returned
   */
  @SuppressWarnings("unused")
  public io.v.v23.vdl.VdlValue[] getMethodTags(java.lang.String method)
      throws io.v.v23.verror.VException {

    if ("seekBlessings".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {};

      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"seekBlessings\": %s", e.getMessage()));
      }
    }

    return null; // method not found
  }

  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.security.Blessings>
      seekBlessings(io.v.v23.context.VContext _ctx, final io.v.v23.rpc.StreamServerCall _call) {

    return this.server.seekBlessings(_ctx, _call);
  }
}
