// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: role.vdl
package io.v.x.ref.services.role;

/**
 * Role is an interface to request blessings from a role account server. The
 * returned blessings are bound to the client's public key thereby authorizing
 * the client to acquire the role. The server may tie the returned blessings
 * with the client's presented blessing name in order to maintain audit
 * information in the blessing.
 *<p>
 * In order to avoid granting role blessings to all delegates of a principal,
 * the role server requires that each authorized blessing presented by the
 * client have the string "_role" as suffix.
 */
public interface RoleClient {

  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<io.v.v23.security.Blessings> seekBlessings(
      io.v.v23.context.VContext context);

  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<io.v.v23.security.Blessings> seekBlessings(
      io.v.v23.context.VContext context, io.v.v23.Options opts);

  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<io.v.v23.security.Blessings> seekBlessings(
      io.v.v23.context.VContext context, io.v.v23.options.RpcOptions opts);
}
