// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  repository.vdl
package io.v.x.ref.services.repository;

/**
 * Wrapper for {@link ProfileServer}.  This wrapper is used by
 * {@link io.v.v23.rpc.ReflectInvoker} to indirectly invoke server methods.
 */
public final class ProfileServerWrapper {
  private final io.v.x.ref.services.repository.ProfileServer server;

  private final io.v.v23.services.repository.ProfileServerWrapper wrapperProfile;

  /**
   * Creates a new {@link ProfileServerWrapper} to invoke the methods of the
   * provided server.
   *
   * @param server server whose methods are to be invoked
   */
  public ProfileServerWrapper(io.v.x.ref.services.repository.ProfileServer server) {
    this.server = server;

    this.wrapperProfile = new io.v.v23.services.repository.ProfileServerWrapper(server);
  }

  /**
   * Returns a description of this server.
   */
  public io.v.v23.vdlroot.signature.Interface signature() {
    java.util.List<io.v.v23.vdlroot.signature.Embed> embeds =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Embed>();
    java.util.List<io.v.v23.vdlroot.signature.Method> methods =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Method>();

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(io.v.x.ref.services.profile.Specification.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "specification",
              "// Specification returns the profile specification for the profile"
                  + "// identified through the object name suffix."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(io.v.x.ref.services.profile.Specification.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "put",
              "// Put sets the profile specification for the profile identified"
                  + "// through the object name suffix."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "remove",
              "// Remove removes the profile specification for the profile"
                  + "// identified through the object name suffix."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    return new io.v.v23.vdlroot.signature.Interface(
        "Profile",
        "io.v.x.ref.services.repository",
        "// Profile describes a profile internally. Besides the public Profile"
            + "// interface, it allows to add and remove profile specifications."
            + "",
        embeds,
        methods);
  }

  /**
   * Returns all tags associated with the provided method or {@code null} if the method isn't
   * implemented by this server.
   *
   * @param method method whose tags are to be returned
   */
  @SuppressWarnings("unused")
  public io.v.v23.vdl.VdlValue[] getMethodTags(java.lang.String method)
      throws io.v.v23.verror.VException {

    if ("put".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"put\": %s", e.getMessage()));
      }
    }

    if ("remove".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"remove\": %s", e.getMessage()));
      }
    }

    if ("specification".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"specification\": %s", e.getMessage()));
      }
    }

    {
      io.v.v23.vdl.VdlValue[] tags = this.wrapperProfile.getMethodTags(method);
      if (tags != null) {
        return tags;
      }
    }

    return null; // method not found
  }

  /**
   * Specification returns the profile specification for the profile
   * identified through the object name suffix.
   */
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.services.profile.Specification>
      specification(io.v.v23.context.VContext _ctx, final io.v.v23.rpc.StreamServerCall _call) {

    return this.server.specification(_ctx, _call);
  }

  /**
   * Put sets the profile specification for the profile identified
   * through the object name suffix.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> put(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final io.v.x.ref.services.profile.Specification Specification) {

    return this.server.put(_ctx, _call, Specification);
  }

  /**
   * Remove removes the profile specification for the profile
   * identified through the object name suffix.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> remove(
      io.v.v23.context.VContext _ctx, final io.v.v23.rpc.StreamServerCall _call) {

    return this.server.remove(_ctx, _call);
  }

  /**
   * Description is a free-text description of the profile, meant for
   * human consumption.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.String> description(
      io.v.v23.context.VContext ctx, io.v.v23.rpc.StreamServerCall call)
      throws io.v.v23.verror.VException {

    return this.wrapperProfile.description(ctx, call);
  }

  /**
   * Label is the human-readable profile key for the profile,
   * e.g. "linux-media". The label can be used to uniquely identify
   * the profile (for the purpose of matching application binaries and
   * devices).
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.String> label(
      io.v.v23.context.VContext ctx, io.v.v23.rpc.StreamServerCall call)
      throws io.v.v23.verror.VException {

    return this.wrapperProfile.label(ctx, call);
  }
}
