// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: repository.vdl
package io.v.x.ref.services.repository;

/**
 * Application describes an application repository internally. Besides the
 * public Application interface, it allows adding and removing application
 * envelopes, as well as querying for a list of supported profiles.
 */
public interface ApplicationClient extends io.v.v23.services.repository.ApplicationClient {

  /**
   * Put adds the given application envelope for the given profile and
   * application version (required, and specified through the object name
   * suffix).
   *<p>
   * An error is returned if an envelope already exists, unless the
   * overwrite option is set.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> put(
      io.v.v23.context.VContext context,
      final java.lang.String Profile,
      final io.v.v23.services.application.Envelope Envelope,
      final boolean Overwrite);

  /**
   * Put adds the given application envelope for the given profile and
   * application version (required, and specified through the object name
   * suffix).
   *<p>
   * An error is returned if an envelope already exists, unless the
   * overwrite option is set.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> put(
      io.v.v23.context.VContext context,
      final java.lang.String Profile,
      final io.v.v23.services.application.Envelope Envelope,
      final boolean Overwrite,
      io.v.v23.Options opts);

  /**
   * Put adds the given application envelope for the given profile and
   * application version (required, and specified through the object name
   * suffix).
   *<p>
   * An error is returned if an envelope already exists, unless the
   * overwrite option is set.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> put(
      io.v.v23.context.VContext context,
      final java.lang.String Profile,
      final io.v.v23.services.application.Envelope Envelope,
      final boolean Overwrite,
      io.v.v23.options.RpcOptions opts);

  /**
   * Remove removes the application envelope for the given profile
   * name and application version (specified through the object name
   * suffix).
   *<p>
   * If no version is specified as part of the suffix, the method removes
   * all versions for the given profile.
   *<p>
   * If the profile is the string "*", all profiles are removed for the
   * given version (or for all versions if the version is not specified).
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> remove(
      io.v.v23.context.VContext context, final java.lang.String Profile);

  /**
   * Remove removes the application envelope for the given profile
   * name and application version (specified through the object name
   * suffix).
   *<p>
   * If no version is specified as part of the suffix, the method removes
   * all versions for the given profile.
   *<p>
   * If the profile is the string "*", all profiles are removed for the
   * given version (or for all versions if the version is not specified).
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> remove(
      io.v.v23.context.VContext context, final java.lang.String Profile, io.v.v23.Options opts);

  /**
   * Remove removes the application envelope for the given profile
   * name and application version (specified through the object name
   * suffix).
   *<p>
   * If no version is specified as part of the suffix, the method removes
   * all versions for the given profile.
   *<p>
   * If the profile is the string "*", all profiles are removed for the
   * given version (or for all versions if the version is not specified).
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> remove(
      io.v.v23.context.VContext context,
      final java.lang.String Profile,
      io.v.v23.options.RpcOptions opts);

  /**
   * Profiles returns the supported profiles for the application version
   * specified through the object name suffix.  If the version is not
   * specified, Profiles returns the union of profiles across all
   * versions.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.util.List<java.lang.String>> profiles(
      io.v.v23.context.VContext context);

  /**
   * Profiles returns the supported profiles for the application version
   * specified through the object name suffix.  If the version is not
   * specified, Profiles returns the union of profiles across all
   * versions.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<java.util.List<java.lang.String>> profiles(
      io.v.v23.context.VContext context, io.v.v23.Options opts);

  /**
   * Profiles returns the supported profiles for the application version
   * specified through the object name suffix.  If the version is not
   * specified, Profiles returns the union of profiles across all
   * versions.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.util.List<java.lang.String>> profiles(
      io.v.v23.context.VContext context, io.v.v23.options.RpcOptions opts);
}
