// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: profile.vdl
package io.v.x.ref.services.profile;

/**
 * Specification is how we represent a profile internally. It should
 * provide enough information to allow matching of binaries to devices.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/x/ref/services/profile.Specification")
public class Specification extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Label", index = 0)
  private java.lang.String label;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Description", index = 1)
  private java.lang.String description;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Arch", index = 2)
  private io.v.v23.services.build.Architecture arch;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Os", index = 3)
  private io.v.v23.services.build.OperatingSystem os;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Format", index = 4)
  private io.v.v23.services.build.Format format;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Libraries", index = 5)
  private java.util.Set<io.v.x.ref.services.profile.Library> libraries;

  /**
   * Vdl type for {@link Specification}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(Specification.class);

  /**
   * Creates a new zero-value instance of {@link Specification}.
   */
  public Specification() {
    super(VDL_TYPE);

    this.label = "";

    this.description = "";

    this.arch = io.v.v23.services.build.Architecture.Amd64;

    this.os = io.v.v23.services.build.OperatingSystem.Darwin;

    this.format = io.v.v23.services.build.Format.Elf;

    this.libraries = new java.util.HashSet<io.v.x.ref.services.profile.Library>();
  }

  /**
   * Creates a new instance of {@link Specification} with the provided field values.
   */
  public Specification(
      java.lang.String label,
      java.lang.String description,
      io.v.v23.services.build.Architecture arch,
      io.v.v23.services.build.OperatingSystem os,
      io.v.v23.services.build.Format format,
      java.util.Set<io.v.x.ref.services.profile.Library> libraries) {
    super(VDL_TYPE);

    this.label = label;

    this.description = description;

    this.arch = arch;

    this.os = os;

    this.format = format;

    this.libraries = libraries;
  }

  /**
   * Label is a human-friendly concise label for the profile,
   * e.g. "linux-media".
   */
  public java.lang.String getLabel() {
    return this.label;
  }

  /**
   * Label is a human-friendly concise label for the profile,
   * e.g. "linux-media".
   */
  public void setLabel(java.lang.String label) {
    this.label = label;
  }

  /**
   * Description is a human-friendly description of the profile.
   */
  public java.lang.String getDescription() {
    return this.description;
  }

  /**
   * Description is a human-friendly description of the profile.
   */
  public void setDescription(java.lang.String description) {
    this.description = description;
  }

  /**
   * Arch is the target hardware architecture of the profile.
   */
  public io.v.v23.services.build.Architecture getArch() {
    return this.arch;
  }

  /**
   * Arch is the target hardware architecture of the profile.
   */
  public void setArch(io.v.v23.services.build.Architecture arch) {
    this.arch = arch;
  }

  /**
   * Os is the target operating system of the profile.
   */
  public io.v.v23.services.build.OperatingSystem getOs() {
    return this.os;
  }

  /**
   * Os is the target operating system of the profile.
   */
  public void setOs(io.v.v23.services.build.OperatingSystem os) {
    this.os = os;
  }

  /**
   * Format is the file format supported by the profile.
   */
  public io.v.v23.services.build.Format getFormat() {
    return this.format;
  }

  /**
   * Format is the file format supported by the profile.
   */
  public void setFormat(io.v.v23.services.build.Format format) {
    this.format = format;
  }

  /**
   * Libraries is a set of libraries the profile requires.
   */
  public java.util.Set<io.v.x.ref.services.profile.Library> getLibraries() {
    return this.libraries;
  }

  /**
   * Libraries is a set of libraries the profile requires.
   */
  public void setLibraries(java.util.Set<io.v.x.ref.services.profile.Library> libraries) {
    this.libraries = libraries;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    Specification other = (Specification) obj;

    if (this.label == null) {
      if (other.label != null) {
        return false;
      }
    } else if (!this.label.equals(other.label)) {
      return false;
    }

    if (this.description == null) {
      if (other.description != null) {
        return false;
      }
    } else if (!this.description.equals(other.description)) {
      return false;
    }

    if (this.arch == null) {
      if (other.arch != null) {
        return false;
      }
    } else if (!this.arch.equals(other.arch)) {
      return false;
    }

    if (this.os == null) {
      if (other.os != null) {
        return false;
      }
    } else if (!this.os.equals(other.os)) {
      return false;
    }

    if (this.format == null) {
      if (other.format != null) {
        return false;
      }
    } else if (!this.format.equals(other.format)) {
      return false;
    }

    if (this.libraries == null) {
      if (other.libraries != null) {
        return false;
      }
    } else if (!this.libraries.equals(other.libraries)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.label == null ? 0 : this.label.hashCode());

    result = prime * result + (this.description == null ? 0 : this.description.hashCode());

    result = prime * result + (this.arch == null ? 0 : this.arch.hashCode());

    result = prime * result + (this.os == null ? 0 : this.os.hashCode());

    result = prime * result + (this.format == null ? 0 : this.format.hashCode());

    result = prime * result + (this.libraries == null ? 0 : this.libraries.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "label:" + this.label;

    result += ", ";

    result += "description:" + this.description;

    result += ", ";

    result += "arch:" + this.arch;

    result += ", ";

    result += "os:" + this.os;

    result += ", ";

    result += "format:" + this.format;

    result += ", ";

    result += "libraries:" + this.libraries;

    return result + "}";
  }
}
