// Copyright 2016 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  root.vdl
package io.v.x.ref.services.iberoot;

/**
 * Wrapper for {@link RootServer}.  This wrapper is used by
 * {@link io.v.v23.rpc.ReflectInvoker} to indirectly invoke server methods.
 */
public final class RootServerWrapper {
  private final io.v.x.ref.services.iberoot.RootServer server;

  /**
   * Creates a new {@link RootServerWrapper} to invoke the methods of the
   * provided server.
   *
   * @param server server whose methods are to be invoked
   */
  public RootServerWrapper(io.v.x.ref.services.iberoot.RootServer server) {
    this.server = server;
  }

  /**
   * Returns a description of this server.
   */
  public io.v.v23.vdlroot.signature.Interface signature() {
    java.util.List<io.v.v23.vdlroot.signature.Embed> embeds =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Embed>();
    java.util.List<io.v.v23.vdlroot.signature.Method> methods =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Method>();

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  new com.google.common.reflect.TypeToken<
                      java.util.List<
                          io.v.x.ref.lib.security.bcrypter.WirePrivateKey>>() {}.getType())));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "seekPrivateKeys",
              "// SeekPrivateKeys creates and returns private keys for blessings"
                  + "// presented by the calling principal. The blessings must be from"
                  + "// an identity provider recognized by this service."
                  + "//"
                  + "// The extracted private keys can be used to decrypt any ciphertext"
                  + "// encrypted for a pattern matched by the presented blessings."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(io.v.x.ref.lib.security.bcrypter.WireParams.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "params",
              "// Params returns the public encryption parameters of this service." + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    return new io.v.v23.vdlroot.signature.Interface(
        "Root",
        "io.v.x.ref.services.iberoot",
        "// Root is an interface for requesting private keys for blessings."
            + "//"
            + "// The keys are extracted in a blessings-based encryption scheme, which in"
            + "// turn is based on an identity-based encryption (IBE) scheme (e.g., the BB1"
            + "// IBE scheme)."
            + "",
        embeds,
        methods);
  }

  /**
   * Returns all tags associated with the provided method or {@code null} if the method isn't
   * implemented by this server.
   *
   * @param method method whose tags are to be returned
   */
  @SuppressWarnings("unused")
  public io.v.v23.vdl.VdlValue[] getMethodTags(java.lang.String method)
      throws io.v.v23.verror.VException {

    if ("params".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {};

      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"params\": %s", e.getMessage()));
      }
    }

    if ("seekPrivateKeys".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {};

      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"seekPrivateKeys\": %s", e.getMessage()));
      }
    }

    return null; // method not found
  }

  /**
   * SeekPrivateKeys creates and returns private keys for blessings
   * presented by the calling principal. The blessings must be from
   * an identity provider recognized by this service.
   *<p>
   * The extracted private keys can be used to decrypt any ciphertext
   * encrypted for a pattern matched by the presented blessings.
   */
  public com.google.common.util.concurrent.ListenableFuture<
          java.util.List<io.v.x.ref.lib.security.bcrypter.WirePrivateKey>>
      seekPrivateKeys(io.v.v23.context.VContext _ctx, final io.v.v23.rpc.StreamServerCall _call) {

    return this.server.seekPrivateKeys(_ctx, _call);
  }

  /**
   * Params returns the public encryption parameters of this service.
   */
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.lib.security.bcrypter.WireParams>
      params(io.v.v23.context.VContext _ctx, final io.v.v23.rpc.StreamServerCall _call) {

    return this.server.params(_ctx, _call);
  }
}
