// Copyright 2016 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: root.vdl
package io.v.x.ref.services.iberoot;

/**
 * Root is an interface for requesting private keys for blessings.
 *<p>
 * The keys are extracted in a blessings-based encryption scheme, which in
 * turn is based on an identity-based encryption (IBE) scheme (e.g., the BB1
 * IBE scheme).
 */
@io.v.v23.vdl.VServer(serverWrapper = io.v.x.ref.services.iberoot.RootServerWrapper.class)
public interface RootServer {

  /**
   * SeekPrivateKeys creates and returns private keys for blessings
   * presented by the calling principal. The blessings must be from
   * an identity provider recognized by this service.
   *<p>
   * The extracted private keys can be used to decrypt any ciphertext
   * encrypted for a pattern matched by the presented blessings.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<
          java.util.List<io.v.x.ref.lib.security.bcrypter.WirePrivateKey>>
      seekPrivateKeys(io.v.v23.context.VContext context, io.v.v23.rpc.ServerCall call);

  /**
   * Params returns the public encryption parameters of this service.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<io.v.x.ref.lib.security.bcrypter.WireParams>
      params(io.v.v23.context.VContext context, io.v.v23.rpc.ServerCall call);
}
