// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  service.vdl
package io.v.x.ref.services.cluster;

/**
 * Wrapper for {@link ClusterAgentServer}.  This wrapper is used by
 * {@link io.v.v23.rpc.ReflectInvoker} to indirectly invoke server methods.
 */
public final class ClusterAgentServerWrapper {
  private final io.v.x.ref.services.cluster.ClusterAgentServer server;

  /**
   * Creates a new {@link ClusterAgentServerWrapper} to invoke the methods of the
   * provided server.
   *
   * @param server server whose methods are to be invoked
   */
  public ClusterAgentServerWrapper(io.v.x.ref.services.cluster.ClusterAgentServer server) {
    this.server = server;
  }

  /**
   * Returns a description of this server.
   */
  public io.v.v23.vdlroot.signature.Interface signature() {
    java.util.List<io.v.v23.vdlroot.signature.Embed> embeds =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Embed>();
    java.util.List<io.v.v23.vdlroot.signature.Method> methods =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Method>();

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.v23.security.Blessings.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "seekBlessings",
              "// Retrieves all the blessings associated with a particular secret."
                  + "// The only authorization required to access this method is the secret"
                  + "// itself."
                  + "// TODO(rthellend): Consider adding other side-channel authorization"
                  + "// mechanisms, e.g. verify that the IP address of the client belongs to"
                  + "// an authorized user."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    return new io.v.v23.vdlroot.signature.Interface(
        "ClusterAgent", "io.v.x.ref.services.cluster", "", embeds, methods);
  }

  /**
   * Returns all tags associated with the provided method or {@code null} if the method isn't
   * implemented by this server.
   *
   * @param method method whose tags are to be returned
   */
  @SuppressWarnings("unused")
  public io.v.v23.vdl.VdlValue[] getMethodTags(java.lang.String method)
      throws io.v.v23.verror.VException {

    if ("seekBlessings".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {};

      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"seekBlessings\": %s", e.getMessage()));
      }
    }

    return null; // method not found
  }

  /**
   * Retrieves all the blessings associated with a particular secret.
   * The only authorization required to access this method is the secret
   * itself.
   * TODO(rthellend): Consider adding other side-channel authorization
   * mechanisms, e.g. verify that the IP address of the client belongs to
   * an authorized user.
   */
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.security.Blessings>
      seekBlessings(
          io.v.v23.context.VContext _ctx,
          final io.v.v23.rpc.StreamServerCall _call,
          final java.lang.String secret) {

    return this.server.seekBlessings(_ctx, _call, secret);
  }
}
