// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  service.vdl
package io.v.x.ref.services.cluster;

/**
 * Wrapper for {@link ClusterAgentAdminServer}.  This wrapper is used by
 * {@link io.v.v23.rpc.ReflectInvoker} to indirectly invoke server methods.
 */
public final class ClusterAgentAdminServerWrapper {
  private final io.v.x.ref.services.cluster.ClusterAgentAdminServer server;

  private final io.v.x.ref.services.cluster.ClusterAgentServerWrapper wrapperClusterAgent;

  /**
   * Creates a new {@link ClusterAgentAdminServerWrapper} to invoke the methods of the
   * provided server.
   *
   * @param server server whose methods are to be invoked
   */
  public ClusterAgentAdminServerWrapper(
      io.v.x.ref.services.cluster.ClusterAgentAdminServer server) {
    this.server = server;

    this.wrapperClusterAgent = new io.v.x.ref.services.cluster.ClusterAgentServerWrapper(server);
  }

  /**
   * Returns a description of this server.
   */
  public io.v.v23.vdlroot.signature.Interface signature() {
    java.util.List<io.v.v23.vdlroot.signature.Embed> embeds =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Embed>();
    java.util.List<io.v.v23.vdlroot.signature.Method> methods =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Method>();

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Admin"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "newSecret",
              "// Creates a new \"secret\" that can be used to retrieve extensions"
                  + "// of the blessings granted on this RPC, e.g. with the rpc.Granter"
                  + "// ClientCallOpt in Go."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Admin"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "forgetSecret",
              "// Forgets a secret and its associated blessings." + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    return new io.v.v23.vdlroot.signature.Interface(
        "ClusterAgentAdmin", "io.v.x.ref.services.cluster", "", embeds, methods);
  }

  /**
   * Returns all tags associated with the provided method or {@code null} if the method isn't
   * implemented by this server.
   *
   * @param method method whose tags are to be returned
   */
  @SuppressWarnings("unused")
  public io.v.v23.vdl.VdlValue[] getMethodTags(java.lang.String method)
      throws io.v.v23.verror.VException {

    if ("forgetSecret".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Admin"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"forgetSecret\": %s", e.getMessage()));
      }
    }

    if ("newSecret".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Admin"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"newSecret\": %s", e.getMessage()));
      }
    }

    {
      io.v.v23.vdl.VdlValue[] tags = this.wrapperClusterAgent.getMethodTags(method);
      if (tags != null) {
        return tags;
      }
    }

    return null; // method not found
  }

  /**
   * Creates a new "secret" that can be used to retrieve extensions
   * of the blessings granted on this RPC, e.g. with the rpc.Granter
   * ClientCallOpt in Go.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.String> newSecret(
      io.v.v23.context.VContext _ctx, final io.v.v23.rpc.StreamServerCall _call) {

    return this.server.newSecret(_ctx, _call);
  }

  /**
   * Forgets a secret and its associated blessings.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> forgetSecret(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final java.lang.String secret) {

    return this.server.forgetSecret(_ctx, _call, secret);
  }

  /**
   * Retrieves all the blessings associated with a particular secret.
   * The only authorization required to access this method is the secret
   * itself.
   * TODO(rthellend): Consider adding other side-channel authorization
   * mechanisms, e.g. verify that the IP address of the client belongs to
   * an authorized user.
   */
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.security.Blessings>
      seekBlessings(
          io.v.v23.context.VContext ctx,
          io.v.v23.rpc.StreamServerCall call,
          final java.lang.String secret)
          throws io.v.v23.verror.VException {

    return this.wrapperClusterAgent.seekBlessings(ctx, call, secret);
  }
}
