// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  service.vdl
package io.v.x.ref.services.cluster;

/**
 * Implementation of the {@link ClusterAgentAdminClient} interface.
 */
final class ClusterAgentAdminClientImpl
    implements io.v.x.ref.services.cluster.ClusterAgentAdminClient {
  private final io.v.v23.rpc.Client client;
  private final java.lang.String vName;

  private final io.v.x.ref.services.cluster.ClusterAgentClient implClusterAgent;

  /**
   * Creates a new instance of {@link ClusterAgentAdminClientImpl}.
   *
   * @param client Vanadium client
   * @param vName  remote server name
   */
  public ClusterAgentAdminClientImpl(io.v.v23.rpc.Client client, java.lang.String vName) {
    this.client = client;
    this.vName = vName;

    {
      io.v.v23.Options opts = new io.v.v23.Options();
      opts.set(io.v.v23.OptionDefs.CLIENT, client);
      this.implClusterAgent =
          io.v.x.ref.services.cluster.ClusterAgentClientFactory.getClusterAgentClient(vName, opts);
    }
  }

  private io.v.v23.rpc.Client getClient(io.v.v23.context.VContext context) {
    return this.client != null ? client : io.v.v23.V.getClient(context);
  }

  // Methods from interface ClusterAgentAdminClient.

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.String> newSecret(
      io.v.v23.context.VContext _context) {
    return newSecret(_context, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.String> newSecret(
      final io.v.v23.context.VContext _context, io.v.v23.Options _opts) {
    return newSecret(_context, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.String> newSecret(
      final io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "newSecret", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.String>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.String> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      java.lang.String.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.String>() {
                      @Override
                      public java.lang.String apply(Object[] _results) {

                        return (java.lang.String) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> forgetSecret(
      io.v.v23.context.VContext _context, final java.lang.String secret) {
    return forgetSecret(_context, secret, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> forgetSecret(
      final io.v.v23.context.VContext _context,
      final java.lang.String secret,
      io.v.v23.Options _opts) {
    return forgetSecret(_context, secret, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> forgetSecret(
      final io.v.v23.context.VContext _context,
      final java.lang.String secret,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {secret};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {java.lang.String.class};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context)
            .startCall(_context, this.vName, "forgetSecret", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Void>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes = new java.lang.reflect.Type[] {};

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Void>() {
                      @Override
                      public java.lang.Void apply(Object[] _results) {

                        return null;
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.security.Blessings>
      seekBlessings(io.v.v23.context.VContext _context, final java.lang.String secret) {

    return this.implClusterAgent.seekBlessings(_context, secret);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.security.Blessings>
      seekBlessings(
          io.v.v23.context.VContext _context,
          final java.lang.String secret,
          io.v.v23.Options _opts) {

    return this.implClusterAgent.seekBlessings(_context, secret, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.security.Blessings>
      seekBlessings(
          io.v.v23.context.VContext _context,
          final java.lang.String secret,
          io.v.v23.options.RpcOptions _opts) {

    return this.implClusterAgent.seekBlessings(_context, secret, _opts);
  }
}
