// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: ben.vdl
package io.v.x.ref.services.ben;

/**
 * Run encapsulates the results of a single microbenchmark run.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/x/ref/services/ben.Run")
public class Run extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Name", index = 0)
  private java.lang.String name;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Iterations", index = 1)
  private io.v.v23.vdl.VdlUint64 iterations;

  @io.v.v23.vdl.GeneratedFromVdl(name = "NanoSecsPerOp", index = 2)
  private double nanoSecsPerOp;

  @io.v.v23.vdl.GeneratedFromVdl(name = "AllocsPerOp", index = 3)
  private io.v.v23.vdl.VdlUint64 allocsPerOp;

  @io.v.v23.vdl.GeneratedFromVdl(name = "AllocedBytesPerOp", index = 4)
  private io.v.v23.vdl.VdlUint64 allocedBytesPerOp;

  @io.v.v23.vdl.GeneratedFromVdl(name = "MegaBytesPerSec", index = 5)
  private double megaBytesPerSec;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Parallelism", index = 6)
  private io.v.v23.vdl.VdlUint32 parallelism;

  /**
   * Vdl type for {@link Run}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(Run.class);

  /**
   * Creates a new zero-value instance of {@link Run}.
   */
  public Run() {
    super(VDL_TYPE);

    this.name = "";

    this.iterations = new io.v.v23.vdl.VdlUint64();

    this.nanoSecsPerOp = 0.0;

    this.allocsPerOp = new io.v.v23.vdl.VdlUint64();

    this.allocedBytesPerOp = new io.v.v23.vdl.VdlUint64();

    this.megaBytesPerSec = 0.0;

    this.parallelism = new io.v.v23.vdl.VdlUint32();
  }

  /**
   * Creates a new instance of {@link Run} with the provided field values.
   */
  public Run(
      java.lang.String name,
      io.v.v23.vdl.VdlUint64 iterations,
      double nanoSecsPerOp,
      io.v.v23.vdl.VdlUint64 allocsPerOp,
      io.v.v23.vdl.VdlUint64 allocedBytesPerOp,
      double megaBytesPerSec,
      io.v.v23.vdl.VdlUint32 parallelism) {
    super(VDL_TYPE);

    this.name = name;

    this.iterations = iterations;

    this.nanoSecsPerOp = nanoSecsPerOp;

    this.allocsPerOp = allocsPerOp;

    this.allocedBytesPerOp = allocedBytesPerOp;

    this.megaBytesPerSec = megaBytesPerSec;

    this.parallelism = parallelism;
  }

  /**
   * Name of the microbenchmark. <package>.Benchmark<Name> in Go.
   */
  public java.lang.String getName() {
    return this.name;
  }

  /**
   * Name of the microbenchmark. <package>.Benchmark<Name> in Go.
   */
  public void setName(java.lang.String name) {
    this.name = name;
  }

  public io.v.v23.vdl.VdlUint64 getIterations() {
    return this.iterations;
  }

  public void setIterations(io.v.v23.vdl.VdlUint64 iterations) {
    this.iterations = iterations;
  }

  /**
   * Nano-seconds per iteration.
   */
  public double getNanoSecsPerOp() {
    return this.nanoSecsPerOp;
  }

  /**
   * Nano-seconds per iteration.
   */
  public void setNanoSecsPerOp(double nanoSecsPerOp) {
    this.nanoSecsPerOp = nanoSecsPerOp;
  }

  /**
   * Memory allocations per iteration.
   */
  public io.v.v23.vdl.VdlUint64 getAllocsPerOp() {
    return this.allocsPerOp;
  }

  /**
   * Memory allocations per iteration.
   */
  public void setAllocsPerOp(io.v.v23.vdl.VdlUint64 allocsPerOp) {
    this.allocsPerOp = allocsPerOp;
  }

  /**
   * Size of memory allocations per iteration.
   */
  public io.v.v23.vdl.VdlUint64 getAllocedBytesPerOp() {
    return this.allocedBytesPerOp;
  }

  /**
   * Size of memory allocations per iteration.
   */
  public void setAllocedBytesPerOp(io.v.v23.vdl.VdlUint64 allocedBytesPerOp) {
    this.allocedBytesPerOp = allocedBytesPerOp;
  }

  /**
   * Throughput in MB/s.
   */
  public double getMegaBytesPerSec() {
    return this.megaBytesPerSec;
  }

  /**
   * Throughput in MB/s.
   */
  public void setMegaBytesPerSec(double megaBytesPerSec) {
    this.megaBytesPerSec = megaBytesPerSec;
  }

  /**
   * For Go, the GOMAXPROCS used during benchmark execution
   */
  public io.v.v23.vdl.VdlUint32 getParallelism() {
    return this.parallelism;
  }

  /**
   * For Go, the GOMAXPROCS used during benchmark execution
   */
  public void setParallelism(io.v.v23.vdl.VdlUint32 parallelism) {
    this.parallelism = parallelism;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    Run other = (Run) obj;

    if (this.name == null) {
      if (other.name != null) {
        return false;
      }
    } else if (!this.name.equals(other.name)) {
      return false;
    }

    if (this.iterations == null) {
      if (other.iterations != null) {
        return false;
      }
    } else if (!this.iterations.equals(other.iterations)) {
      return false;
    }

    if (this.nanoSecsPerOp != other.nanoSecsPerOp) {
      return false;
    }

    if (this.allocsPerOp == null) {
      if (other.allocsPerOp != null) {
        return false;
      }
    } else if (!this.allocsPerOp.equals(other.allocsPerOp)) {
      return false;
    }

    if (this.allocedBytesPerOp == null) {
      if (other.allocedBytesPerOp != null) {
        return false;
      }
    } else if (!this.allocedBytesPerOp.equals(other.allocedBytesPerOp)) {
      return false;
    }

    if (this.megaBytesPerSec != other.megaBytesPerSec) {
      return false;
    }

    if (this.parallelism == null) {
      if (other.parallelism != null) {
        return false;
      }
    } else if (!this.parallelism.equals(other.parallelism)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.name == null ? 0 : this.name.hashCode());

    result = prime * result + (this.iterations == null ? 0 : this.iterations.hashCode());

    result = prime * result + java.lang.Double.valueOf(this.nanoSecsPerOp).hashCode();

    result = prime * result + (this.allocsPerOp == null ? 0 : this.allocsPerOp.hashCode());

    result =
        prime * result + (this.allocedBytesPerOp == null ? 0 : this.allocedBytesPerOp.hashCode());

    result = prime * result + java.lang.Double.valueOf(this.megaBytesPerSec).hashCode();

    result = prime * result + (this.parallelism == null ? 0 : this.parallelism.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "name:" + this.name;

    result += ", ";

    result += "iterations:" + this.iterations;

    result += ", ";

    result += "nanoSecsPerOp:" + this.nanoSecsPerOp;

    result += ", ";

    result += "allocsPerOp:" + this.allocsPerOp;

    result += ", ";

    result += "allocedBytesPerOp:" + this.allocedBytesPerOp;

    result += ", ";

    result += "megaBytesPerSec:" + this.megaBytesPerSec;

    result += ", ";

    result += "parallelism:" + this.parallelism;

    return result + "}";
  }
}
