// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: ben.vdl
package io.v.x.ref.services.ben;

/**
 * Os describes the Operating System on which the microbenchmarks were run.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/x/ref/services/ben.Os")
public class Os extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Name", index = 0)
  private java.lang.String name;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Version", index = 1)
  private java.lang.String version;

  /**
   * Vdl type for {@link Os}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(Os.class);

  /**
   * Creates a new zero-value instance of {@link Os}.
   */
  public Os() {
    super(VDL_TYPE);

    this.name = "";

    this.version = "";
  }

  /**
   * Creates a new instance of {@link Os} with the provided field values.
   */
  public Os(java.lang.String name, java.lang.String version) {
    super(VDL_TYPE);

    this.name = name;

    this.version = version;
  }

  /**
   * Short name of the operating system: linux, darwin, android etc.
   */
  public java.lang.String getName() {
    return this.name;
  }

  /**
   * Short name of the operating system: linux, darwin, android etc.
   */
  public void setName(java.lang.String name) {
    this.name = name;
  }

  /**
   * Details of the distribution/version, e.g., "Ubuntu 14.04", "Mac OS X 10.11.2 15C50" etc.
   */
  public java.lang.String getVersion() {
    return this.version;
  }

  /**
   * Details of the distribution/version, e.g., "Ubuntu 14.04", "Mac OS X 10.11.2 15C50" etc.
   */
  public void setVersion(java.lang.String version) {
    this.version = version;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    Os other = (Os) obj;

    if (this.name == null) {
      if (other.name != null) {
        return false;
      }
    } else if (!this.name.equals(other.name)) {
      return false;
    }

    if (this.version == null) {
      if (other.version != null) {
        return false;
      }
    } else if (!this.version.equals(other.version)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.name == null ? 0 : this.name.hashCode());

    result = prime * result + (this.version == null ? 0 : this.version.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "name:" + this.name;

    result += ", ";

    result += "version:" + this.version;

    return result + "}";
  }
}
