// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: ben.vdl
package io.v.x.ref.services.ben;

/**
 * Cpu describes the CPU of the machine on which the microbenchmarks were run.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/x/ref/services/ben.Cpu")
public class Cpu extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Architecture", index = 0)
  private java.lang.String architecture;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Description", index = 1)
  private java.lang.String description;

  @io.v.v23.vdl.GeneratedFromVdl(name = "ClockSpeedMhz", index = 2)
  private io.v.v23.vdl.VdlUint32 clockSpeedMhz;

  /**
   * Vdl type for {@link Cpu}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(Cpu.class);

  /**
   * Creates a new zero-value instance of {@link Cpu}.
   */
  public Cpu() {
    super(VDL_TYPE);

    this.architecture = "";

    this.description = "";

    this.clockSpeedMhz = new io.v.v23.vdl.VdlUint32();
  }

  /**
   * Creates a new instance of {@link Cpu} with the provided field values.
   */
  public Cpu(
      java.lang.String architecture,
      java.lang.String description,
      io.v.v23.vdl.VdlUint32 clockSpeedMhz) {
    super(VDL_TYPE);

    this.architecture = architecture;

    this.description = description;

    this.clockSpeedMhz = clockSpeedMhz;
  }

  /**
   * Architecture of the CPU, e.g. "amd64", "386" etc.
   */
  public java.lang.String getArchitecture() {
    return this.architecture;
  }

  /**
   * Architecture of the CPU, e.g. "amd64", "386" etc.
   */
  public void setArchitecture(java.lang.String architecture) {
    this.architecture = architecture;
  }

  /**
   * A detailed description of the CPU, e.g., "Intel(R) Core(TM) i7-5557U CPU @ 3.10GHz"
   */
  public java.lang.String getDescription() {
    return this.description;
  }

  /**
   * A detailed description of the CPU, e.g., "Intel(R) Core(TM) i7-5557U CPU @ 3.10GHz"
   */
  public void setDescription(java.lang.String description) {
    this.description = description;
  }

  /**
   * Clock speed of the CPU in MHz
   */
  public io.v.v23.vdl.VdlUint32 getClockSpeedMhz() {
    return this.clockSpeedMhz;
  }

  /**
   * Clock speed of the CPU in MHz
   */
  public void setClockSpeedMhz(io.v.v23.vdl.VdlUint32 clockSpeedMhz) {
    this.clockSpeedMhz = clockSpeedMhz;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    Cpu other = (Cpu) obj;

    if (this.architecture == null) {
      if (other.architecture != null) {
        return false;
      }
    } else if (!this.architecture.equals(other.architecture)) {
      return false;
    }

    if (this.description == null) {
      if (other.description != null) {
        return false;
      }
    } else if (!this.description.equals(other.description)) {
      return false;
    }

    if (this.clockSpeedMhz == null) {
      if (other.clockSpeedMhz != null) {
        return false;
      }
    } else if (!this.clockSpeedMhz.equals(other.clockSpeedMhz)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.architecture == null ? 0 : this.architecture.hashCode());

    result = prime * result + (this.description == null ? 0 : this.description.hashCode());

    result = prime * result + (this.clockSpeedMhz == null ? 0 : this.clockSpeedMhz.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "architecture:" + this.architecture;

    result += ", ";

    result += "description:" + this.description;

    result += ", ";

    result += "clockSpeedMhz:" + this.clockSpeedMhz;

    return result + "}";
  }
}
