// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: wire.vdl

/**
 * Package agent defines an interface to keep a private key in memory, and for
 * clients to have access to the private key.
 *<p>
 * Protocol
 *<p>
 * The agent starts processes with the VEYRON_AGENT_FD set to one end of a
 * unix domain socket. To connect to the agent, a client should create
 * a unix domain socket pair. Then send one end of the socket to the agent
 * with 1 byte of data. The agent will then serve the Agent service on
 * the received socket, using SecurityNone.
 *<p>
 * The agent also supports an optional mode where it can manage multiple principals.
 * Typically this is only used by Device Manager. In this mode, VEYRON_AGENT_FD
 * will be 3, and there will be another socket at fd 4.
 * Creating a new principal is similar to connecting to to agent: create a socket
 * pair and send one end on fd 4 with 1 byte of data.
 * Set the data to 1 to request the principal only be stored in memory.
 * The agent will create a new principal and respond with a principal handle on fd 4.
 * To connect using a previously created principal, create a socket pair and send
 * one end with the principal handle as data on fd 4. The agent will not send a
 * response on fd 4.
 * In either, you can use the normal process to connect to an agent over the
 * other end of the pair. Typically you would pass the other end to a child
 * process and set VEYRON_AGENT_FD so it knows to connect.
 *<p>
 * The protocol also has limited support for caching: A client can
 * request notification when any other client modifies the principal so it
 * can flush the cache. See NotifyWhenChanged for details.
 */
package io.v.x.ref.services.agent;
