// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  wire.vdl
package io.v.x.ref.services.agent;

/**
 * Implementation of the {@link AgentClient} interface.
 */
final class AgentClientImpl implements io.v.x.ref.services.agent.AgentClient {
  private final io.v.v23.rpc.Client client;
  private final java.lang.String vName;

  /**
   * Creates a new instance of {@link AgentClientImpl}.
   *
   * @param client Vanadium client
   * @param vName  remote server name
   */
  public AgentClientImpl(io.v.v23.rpc.Client client, java.lang.String vName) {
    this.client = client;
    this.vName = vName;
  }

  private io.v.v23.rpc.Client getClient(io.v.v23.context.VContext context) {
    return this.client != null ? client : io.v.v23.V.getClient(context);
  }

  // Methods from interface AgentClient.

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.security.Blessings> bless(
      io.v.v23.context.VContext _context,
      final byte[] key,
      final io.v.v23.security.Blessings wit,
      final java.lang.String extension,
      final io.v.v23.security.Caveat caveat,
      final java.util.List<io.v.v23.security.Caveat> additionalCaveats) {
    return bless(
        _context,
        key,
        wit,
        extension,
        caveat,
        additionalCaveats,
        (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.security.Blessings> bless(
      final io.v.v23.context.VContext _context,
      final byte[] key,
      final io.v.v23.security.Blessings wit,
      final java.lang.String extension,
      final io.v.v23.security.Caveat caveat,
      final java.util.List<io.v.v23.security.Caveat> additionalCaveats,
      io.v.v23.Options _opts) {
    return bless(
        _context,
        key,
        wit,
        extension,
        caveat,
        additionalCaveats,
        io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.security.Blessings> bless(
      final io.v.v23.context.VContext _context,
      final byte[] key,
      final io.v.v23.security.Blessings wit,
      final java.lang.String extension,
      final io.v.v23.security.Caveat caveat,
      final java.util.List<io.v.v23.security.Caveat> additionalCaveats,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args =
        new java.lang.Object[] {key, wit, extension, caveat, additionalCaveats};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {
          byte[].class,
          io.v.v23.security.Blessings.class,
          java.lang.String.class,
          io.v.v23.security.Caveat.class,
          new com.google.common.reflect.TypeToken<
              java.util.List<io.v.v23.security.Caveat>>() {}.getType()
        };
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "bless", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, io.v.v23.security.Blessings>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<io.v.v23.security.Blessings>
                  apply(final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      io.v.v23.security.Blessings.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], io.v.v23.security.Blessings>() {
                      @Override
                      public io.v.v23.security.Blessings apply(Object[] _results) {

                        return (io.v.v23.security.Blessings) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.security.Blessings> blessSelf(
      io.v.v23.context.VContext _context,
      final java.lang.String name,
      final java.util.List<io.v.v23.security.Caveat> caveats) {
    return blessSelf(_context, name, caveats, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.security.Blessings> blessSelf(
      final io.v.v23.context.VContext _context,
      final java.lang.String name,
      final java.util.List<io.v.v23.security.Caveat> caveats,
      io.v.v23.Options _opts) {
    return blessSelf(_context, name, caveats, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.security.Blessings> blessSelf(
      final io.v.v23.context.VContext _context,
      final java.lang.String name,
      final java.util.List<io.v.v23.security.Caveat> caveats,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {name, caveats};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {
          java.lang.String.class,
          new com.google.common.reflect.TypeToken<
              java.util.List<io.v.v23.security.Caveat>>() {}.getType()
        };
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "blessSelf", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, io.v.v23.security.Blessings>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<io.v.v23.security.Blessings>
                  apply(final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      io.v.v23.security.Blessings.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], io.v.v23.security.Blessings>() {
                      @Override
                      public io.v.v23.security.Blessings apply(Object[] _results) {

                        return (io.v.v23.security.Blessings) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.security.VSignature> sign(
      io.v.v23.context.VContext _context, final byte[] message) {
    return sign(_context, message, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.security.VSignature> sign(
      final io.v.v23.context.VContext _context, final byte[] message, io.v.v23.Options _opts) {
    return sign(_context, message, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.security.VSignature> sign(
      final io.v.v23.context.VContext _context,
      final byte[] message,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {message};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {byte[].class};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "sign", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, io.v.v23.security.VSignature>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<
                      io.v.v23.security.VSignature>
                  apply(final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      io.v.v23.security.VSignature.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], io.v.v23.security.VSignature>() {
                      @Override
                      public io.v.v23.security.VSignature apply(Object[] _results) {

                        return (io.v.v23.security.VSignature) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.security.Discharge>
      mintDischarge(
          io.v.v23.context.VContext _context,
          final io.v.v23.security.Caveat forCaveat,
          final io.v.v23.security.Caveat caveatOnDischarge,
          final java.util.List<io.v.v23.security.Caveat> additionalCaveatsOnDischarge) {
    return mintDischarge(
        _context,
        forCaveat,
        caveatOnDischarge,
        additionalCaveatsOnDischarge,
        (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.security.Discharge>
      mintDischarge(
          final io.v.v23.context.VContext _context,
          final io.v.v23.security.Caveat forCaveat,
          final io.v.v23.security.Caveat caveatOnDischarge,
          final java.util.List<io.v.v23.security.Caveat> additionalCaveatsOnDischarge,
          io.v.v23.Options _opts) {
    return mintDischarge(
        _context,
        forCaveat,
        caveatOnDischarge,
        additionalCaveatsOnDischarge,
        io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.security.Discharge>
      mintDischarge(
          final io.v.v23.context.VContext _context,
          final io.v.v23.security.Caveat forCaveat,
          final io.v.v23.security.Caveat caveatOnDischarge,
          final java.util.List<io.v.v23.security.Caveat> additionalCaveatsOnDischarge,
          io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args =
        new java.lang.Object[] {forCaveat, caveatOnDischarge, additionalCaveatsOnDischarge};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {
          io.v.v23.security.Caveat.class,
          io.v.v23.security.Caveat.class,
          new com.google.common.reflect.TypeToken<
              java.util.List<io.v.v23.security.Caveat>>() {}.getType()
        };
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context)
            .startCall(_context, this.vName, "mintDischarge", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, io.v.v23.security.Discharge>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<io.v.v23.security.Discharge>
                  apply(final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      io.v.v23.security.Discharge.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], io.v.v23.security.Discharge>() {
                      @Override
                      public io.v.v23.security.Discharge apply(Object[] _results) {

                        return (io.v.v23.security.Discharge) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<byte[]> publicKey(
      io.v.v23.context.VContext _context) {
    return publicKey(_context, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<byte[]> publicKey(
      final io.v.v23.context.VContext _context, io.v.v23.Options _opts) {
    return publicKey(_context, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<byte[]> publicKey(
      final io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "publicKey", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<io.v.v23.rpc.ClientCall, byte[]>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<byte[]> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      byte[].class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], byte[]>() {
                      @Override
                      public byte[] apply(Object[] _results) {

                        return (byte[]) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.security.Blessings>
      blessingStoreSet(
          io.v.v23.context.VContext _context,
          final io.v.v23.security.Blessings blessings,
          final io.v.v23.security.BlessingPattern forPeers) {
    return blessingStoreSet(_context, blessings, forPeers, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.security.Blessings>
      blessingStoreSet(
          final io.v.v23.context.VContext _context,
          final io.v.v23.security.Blessings blessings,
          final io.v.v23.security.BlessingPattern forPeers,
          io.v.v23.Options _opts) {
    return blessingStoreSet(
        _context, blessings, forPeers, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.security.Blessings>
      blessingStoreSet(
          final io.v.v23.context.VContext _context,
          final io.v.v23.security.Blessings blessings,
          final io.v.v23.security.BlessingPattern forPeers,
          io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {blessings, forPeers};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {
          io.v.v23.security.Blessings.class, io.v.v23.security.BlessingPattern.class
        };
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context)
            .startCall(_context, this.vName, "blessingStoreSet", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, io.v.v23.security.Blessings>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<io.v.v23.security.Blessings>
                  apply(final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      io.v.v23.security.Blessings.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], io.v.v23.security.Blessings>() {
                      @Override
                      public io.v.v23.security.Blessings apply(Object[] _results) {

                        return (io.v.v23.security.Blessings) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.security.Blessings>
      blessingStoreForPeer(
          io.v.v23.context.VContext _context,
          final java.util.List<java.lang.String> peerBlessings) {
    return blessingStoreForPeer(_context, peerBlessings, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.security.Blessings>
      blessingStoreForPeer(
          final io.v.v23.context.VContext _context,
          final java.util.List<java.lang.String> peerBlessings,
          io.v.v23.Options _opts) {
    return blessingStoreForPeer(
        _context, peerBlessings, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.security.Blessings>
      blessingStoreForPeer(
          final io.v.v23.context.VContext _context,
          final java.util.List<java.lang.String> peerBlessings,
          io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {peerBlessings};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {
          new com.google.common.reflect.TypeToken<java.util.List<java.lang.String>>() {}.getType()
        };
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context)
            .startCall(_context, this.vName, "blessingStoreForPeer", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, io.v.v23.security.Blessings>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<io.v.v23.security.Blessings>
                  apply(final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      io.v.v23.security.Blessings.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], io.v.v23.security.Blessings>() {
                      @Override
                      public io.v.v23.security.Blessings apply(Object[] _results) {

                        return (io.v.v23.security.Blessings) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> blessingStoreSetDefault(
      io.v.v23.context.VContext _context, final io.v.v23.security.Blessings blessings) {
    return blessingStoreSetDefault(_context, blessings, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> blessingStoreSetDefault(
      final io.v.v23.context.VContext _context,
      final io.v.v23.security.Blessings blessings,
      io.v.v23.Options _opts) {
    return blessingStoreSetDefault(
        _context, blessings, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> blessingStoreSetDefault(
      final io.v.v23.context.VContext _context,
      final io.v.v23.security.Blessings blessings,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {blessings};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {io.v.v23.security.Blessings.class};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context)
            .startCall(_context, this.vName, "blessingStoreSetDefault", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Void>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes = new java.lang.reflect.Type[] {};

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Void>() {
                      @Override
                      public java.lang.Void apply(Object[] _results) {

                        return null;
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.security.Blessings>
      blessingStoreDefault(io.v.v23.context.VContext _context) {
    return blessingStoreDefault(_context, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.security.Blessings>
      blessingStoreDefault(final io.v.v23.context.VContext _context, io.v.v23.Options _opts) {
    return blessingStoreDefault(_context, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.security.Blessings>
      blessingStoreDefault(
          final io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context)
            .startCall(_context, this.vName, "blessingStoreDefault", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, io.v.v23.security.Blessings>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<io.v.v23.security.Blessings>
                  apply(final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      io.v.v23.security.Blessings.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], io.v.v23.security.Blessings>() {
                      @Override
                      public io.v.v23.security.Blessings apply(Object[] _results) {

                        return (io.v.v23.security.Blessings) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          java.util.Map<io.v.v23.security.BlessingPattern, io.v.v23.security.Blessings>>
      blessingStorePeerBlessings(io.v.v23.context.VContext _context) {
    return blessingStorePeerBlessings(_context, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          java.util.Map<io.v.v23.security.BlessingPattern, io.v.v23.security.Blessings>>
      blessingStorePeerBlessings(final io.v.v23.context.VContext _context, io.v.v23.Options _opts) {
    return blessingStorePeerBlessings(_context, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          java.util.Map<io.v.v23.security.BlessingPattern, io.v.v23.security.Blessings>>
      blessingStorePeerBlessings(
          final io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context)
            .startCall(_context, this.vName, "blessingStorePeerBlessings", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall,
                java.util.Map<io.v.v23.security.BlessingPattern, io.v.v23.security.Blessings>>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<
                      java.util.Map<io.v.v23.security.BlessingPattern, io.v.v23.security.Blessings>>
                  apply(final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      new com.google.common.reflect.TypeToken<
                          java.util.Map<
                              io.v.v23.security.BlessingPattern,
                              io.v.v23.security.Blessings>>() {}.getType(),
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<
                        Object[],
                        java.util.Map<
                            io.v.v23.security.BlessingPattern, io.v.v23.security.Blessings>>() {
                      @Override
                      public java.util.Map<
                              io.v.v23.security.BlessingPattern, io.v.v23.security.Blessings>
                          apply(Object[] _results) {

                        return (java.util.Map<
                                io.v.v23.security.BlessingPattern, io.v.v23.security.Blessings>)
                            _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.String>
      blessingStoreDebugString(io.v.v23.context.VContext _context) {
    return blessingStoreDebugString(_context, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.String>
      blessingStoreDebugString(final io.v.v23.context.VContext _context, io.v.v23.Options _opts) {
    return blessingStoreDebugString(_context, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.String>
      blessingStoreDebugString(
          final io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context)
            .startCall(_context, this.vName, "blessingStoreDebugString", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.String>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.String> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      java.lang.String.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.String>() {
                      @Override
                      public java.lang.String apply(Object[] _results) {

                        return (java.lang.String) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void>
      blessingStoreCacheDischarge(
          io.v.v23.context.VContext _context,
          final io.v.v23.security.Discharge discharge,
          final io.v.v23.security.Caveat caveat,
          final io.v.v23.security.DischargeImpetus impetus) {
    return blessingStoreCacheDischarge(
        _context, discharge, caveat, impetus, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void>
      blessingStoreCacheDischarge(
          final io.v.v23.context.VContext _context,
          final io.v.v23.security.Discharge discharge,
          final io.v.v23.security.Caveat caveat,
          final io.v.v23.security.DischargeImpetus impetus,
          io.v.v23.Options _opts) {
    return blessingStoreCacheDischarge(
        _context, discharge, caveat, impetus, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void>
      blessingStoreCacheDischarge(
          final io.v.v23.context.VContext _context,
          final io.v.v23.security.Discharge discharge,
          final io.v.v23.security.Caveat caveat,
          final io.v.v23.security.DischargeImpetus impetus,
          io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {discharge, caveat, impetus};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {
          io.v.v23.security.Discharge.class,
          io.v.v23.security.Caveat.class,
          io.v.v23.security.DischargeImpetus.class
        };
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context)
            .startCall(
                _context, this.vName, "blessingStoreCacheDischarge", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Void>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes = new java.lang.reflect.Type[] {};

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Void>() {
                      @Override
                      public java.lang.Void apply(Object[] _results) {

                        return null;
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void>
      blessingStoreClearDischarges(
          io.v.v23.context.VContext _context,
          final java.util.List<io.v.v23.security.Discharge> discharges) {
    return blessingStoreClearDischarges(_context, discharges, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void>
      blessingStoreClearDischarges(
          final io.v.v23.context.VContext _context,
          final java.util.List<io.v.v23.security.Discharge> discharges,
          io.v.v23.Options _opts) {
    return blessingStoreClearDischarges(
        _context, discharges, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void>
      blessingStoreClearDischarges(
          final io.v.v23.context.VContext _context,
          final java.util.List<io.v.v23.security.Discharge> discharges,
          io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {discharges};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {
          new com.google.common.reflect.TypeToken<
              java.util.List<io.v.v23.security.Discharge>>() {}.getType()
        };
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context)
            .startCall(
                _context, this.vName, "blessingStoreClearDischarges", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Void>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes = new java.lang.reflect.Type[] {};

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Void>() {
                      @Override
                      public java.lang.Void apply(Object[] _results) {

                        return null;
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.security.Discharge>
      blessingStoreDischarge(
          io.v.v23.context.VContext _context,
          final io.v.v23.security.Caveat caveat,
          final io.v.v23.security.DischargeImpetus impetus) {
    return blessingStoreDischarge(_context, caveat, impetus, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.security.Discharge>
      blessingStoreDischarge(
          final io.v.v23.context.VContext _context,
          final io.v.v23.security.Caveat caveat,
          final io.v.v23.security.DischargeImpetus impetus,
          io.v.v23.Options _opts) {
    return blessingStoreDischarge(
        _context, caveat, impetus, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.security.Discharge>
      blessingStoreDischarge(
          final io.v.v23.context.VContext _context,
          final io.v.v23.security.Caveat caveat,
          final io.v.v23.security.DischargeImpetus impetus,
          io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {caveat, impetus};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {
          io.v.v23.security.Caveat.class, io.v.v23.security.DischargeImpetus.class
        };
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context)
            .startCall(_context, this.vName, "blessingStoreDischarge", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, io.v.v23.security.Discharge>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<io.v.v23.security.Discharge>
                  apply(final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      io.v.v23.security.Discharge.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], io.v.v23.security.Discharge>() {
                      @Override
                      public io.v.v23.security.Discharge apply(Object[] _results) {

                        return (io.v.v23.security.Discharge) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> blessingRootsAdd(
      io.v.v23.context.VContext _context,
      final byte[] root,
      final io.v.v23.security.BlessingPattern pattern) {
    return blessingRootsAdd(_context, root, pattern, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> blessingRootsAdd(
      final io.v.v23.context.VContext _context,
      final byte[] root,
      final io.v.v23.security.BlessingPattern pattern,
      io.v.v23.Options _opts) {
    return blessingRootsAdd(
        _context, root, pattern, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> blessingRootsAdd(
      final io.v.v23.context.VContext _context,
      final byte[] root,
      final io.v.v23.security.BlessingPattern pattern,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {root, pattern};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {byte[].class, io.v.v23.security.BlessingPattern.class};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context)
            .startCall(_context, this.vName, "blessingRootsAdd", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Void>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes = new java.lang.reflect.Type[] {};

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Void>() {
                      @Override
                      public java.lang.Void apply(Object[] _results) {

                        return null;
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> blessingRootsRecognized(
      io.v.v23.context.VContext _context, final byte[] root, final java.lang.String blessing) {
    return blessingRootsRecognized(_context, root, blessing, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> blessingRootsRecognized(
      final io.v.v23.context.VContext _context,
      final byte[] root,
      final java.lang.String blessing,
      io.v.v23.Options _opts) {
    return blessingRootsRecognized(
        _context, root, blessing, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> blessingRootsRecognized(
      final io.v.v23.context.VContext _context,
      final byte[] root,
      final java.lang.String blessing,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {root, blessing};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {byte[].class, java.lang.String.class};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context)
            .startCall(_context, this.vName, "blessingRootsRecognized", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Void>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes = new java.lang.reflect.Type[] {};

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Void>() {
                      @Override
                      public java.lang.Void apply(Object[] _results) {

                        return null;
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          java.util.Map<io.v.v23.security.BlessingPattern, java.util.List<byte[]>>>
      blessingRootsDump(io.v.v23.context.VContext _context) {
    return blessingRootsDump(_context, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          java.util.Map<io.v.v23.security.BlessingPattern, java.util.List<byte[]>>>
      blessingRootsDump(final io.v.v23.context.VContext _context, io.v.v23.Options _opts) {
    return blessingRootsDump(_context, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          java.util.Map<io.v.v23.security.BlessingPattern, java.util.List<byte[]>>>
      blessingRootsDump(
          final io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context)
            .startCall(_context, this.vName, "blessingRootsDump", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall,
                java.util.Map<io.v.v23.security.BlessingPattern, java.util.List<byte[]>>>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<
                      java.util.Map<io.v.v23.security.BlessingPattern, java.util.List<byte[]>>>
                  apply(final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      new com.google.common.reflect.TypeToken<
                          java.util.Map<
                              io.v.v23.security.BlessingPattern,
                              java.util.List<byte[]>>>() {}.getType(),
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<
                        Object[],
                        java.util.Map<
                            io.v.v23.security.BlessingPattern, java.util.List<byte[]>>>() {
                      @Override
                      public java.util.Map<
                              io.v.v23.security.BlessingPattern, java.util.List<byte[]>>
                          apply(Object[] _results) {

                        return (java.util.Map<
                                io.v.v23.security.BlessingPattern, java.util.List<byte[]>>)
                            _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.String>
      blessingRootsDebugString(io.v.v23.context.VContext _context) {
    return blessingRootsDebugString(_context, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.String>
      blessingRootsDebugString(final io.v.v23.context.VContext _context, io.v.v23.Options _opts) {
    return blessingRootsDebugString(_context, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.String>
      blessingRootsDebugString(
          final io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context)
            .startCall(_context, this.vName, "blessingRootsDebugString", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.String>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.String> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      java.lang.String.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.String>() {
                      @Override
                      public java.lang.String apply(Object[] _results) {

                        return (java.lang.String) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public io.v.v23.vdl.ClientRecvStream<java.lang.Boolean, java.lang.Void> notifyWhenChanged(
      io.v.v23.context.VContext _context) {
    return notifyWhenChanged(_context, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public io.v.v23.vdl.ClientRecvStream<java.lang.Boolean, java.lang.Void> notifyWhenChanged(
      final io.v.v23.context.VContext _context, io.v.v23.Options _opts) {
    return notifyWhenChanged(_context, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public io.v.v23.vdl.ClientRecvStream<java.lang.Boolean, java.lang.Void> notifyWhenChanged(
      final io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context)
            .startCall(_context, this.vName, "notifyWhenChanged", _args, _argTypes, _opts);

    return new io.v.v23.vdl.ClientStream<java.lang.Void, java.lang.Boolean, java.lang.Void>() {
      @Override
      public com.google.common.util.concurrent.ListenableFuture<Void> send(
          final java.lang.Void item) {
        final java.lang.reflect.Type type = java.lang.Void.class;
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, Void>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<Void> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return _call.send(item, type);
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<Void> close() {
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, Void>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<Void> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return _call.closeSend();
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<java.lang.Boolean> recv() {
        final java.lang.reflect.Type recvType = java.lang.Boolean.class;
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, java.lang.Boolean>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<java.lang.Boolean>
                      apply(final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return com.google.common.util.concurrent.Futures.transform(
                        _call.recv(recvType),
                        new com.google.common.base.Function<Object, java.lang.Boolean>() {
                          @Override
                          public java.lang.Boolean apply(Object result) {
                            return (java.lang.Boolean) result;
                          }
                        });
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> finish() {

        final java.lang.reflect.Type[] resultTypes = new java.lang.reflect.Type[] {};

        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, java.lang.Void>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return com.google.common.util.concurrent.Futures.transform(
                        _call.finish(resultTypes),
                        new com.google.common.base.Function<Object[], java.lang.Void>() {
                          @Override
                          public java.lang.Void apply(Object[] _results) {

                            return null;
                          }
                        });
                  }
                }));
      }
    };
  }
}
