// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  vine.vdl
package io.v.x.ref.runtime.protocols.vine;

/**
 * Wrapper for {@link VineServer}.  This wrapper is used by
 * {@link io.v.v23.rpc.ReflectInvoker} to indirectly invoke server methods.
 */
public final class VineServerWrapper {
  private final io.v.x.ref.runtime.protocols.vine.VineServer server;

  /**
   * Creates a new {@link VineServerWrapper} to invoke the methods of the
   * provided server.
   *
   * @param server server whose methods are to be invoked
   */
  public VineServerWrapper(io.v.x.ref.runtime.protocols.vine.VineServer server) {
    this.server = server;
  }

  /**
   * Returns a description of this server.
   */
  public io.v.v23.vdlroot.signature.Interface signature() {
    java.util.List<io.v.v23.vdlroot.signature.Embed> embeds =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Embed>();
    java.util.List<io.v.v23.vdlroot.signature.Method> methods =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Method>();

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  new com.google.common.reflect.TypeToken<
                      java.util.Map<
                          io.v.x.ref.runtime.protocols.vine.PeerKey,
                          io.v.x.ref.runtime.protocols.vine.PeerBehavior>>() {}.getType())));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "setBehaviors",
              "// SetBehaviors sets the policy that the accepting vine service's process"
                  + "// will use on connections."
                  + "// behaviors is a map from server tag to the desired connection behavior."
                  + "// For example,"
                  + "//   client.SetBehaviors(map[PeerKey]PeerBehavior{PeerKey{\"foo\", \"bar\"}, PeerBehavior{Reachable: false}})"
                  + "// will cause all vine protocol dial calls from \"foo\" to \"bar\" to fail."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    return new io.v.v23.vdlroot.signature.Interface(
        "Vine",
        "io.v.x.ref.runtime.protocols.vine",
        "// Vine is the interface to a vine service that can dynamically change the network"
            + "// behavior of connection's on the vine service's process."
            + "",
        embeds,
        methods);
  }

  /**
   * Returns all tags associated with the provided method or {@code null} if the method isn't
   * implemented by this server.
   *
   * @param method method whose tags are to be returned
   */
  @SuppressWarnings("unused")
  public io.v.v23.vdl.VdlValue[] getMethodTags(java.lang.String method)
      throws io.v.v23.verror.VException {

    if ("setBehaviors".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {};

      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"setBehaviors\": %s", e.getMessage()));
      }
    }

    return null; // method not found
  }

  /**
   * SetBehaviors sets the policy that the accepting vine service's process
   * will use on connections.
   * behaviors is a map from server tag to the desired connection behavior.
   * For example,
   *   client.SetBehaviors(map[PeerKey]PeerBehavior{PeerKey{"foo", "bar"}, PeerBehavior{Reachable: false}})
   * will cause all vine protocol dial calls from "foo" to "bar" to fail.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setBehaviors(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final java.util.Map<
              io.v.x.ref.runtime.protocols.vine.PeerKey,
              io.v.x.ref.runtime.protocols.vine.PeerBehavior>
          behaviors) {

    return this.server.setBehaviors(_ctx, _call, behaviors);
  }
}
