// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: vine.vdl
package io.v.x.ref.runtime.protocols.vine;

/**
 * Vine is the interface to a vine service that can dynamically change the network
 * behavior of connection's on the vine service's process.
 */
public interface VineClient {

  /**
   * SetBehaviors sets the policy that the accepting vine service's process
   * will use on connections.
   * behaviors is a map from server tag to the desired connection behavior.
   * For example,
   *   client.SetBehaviors(map[PeerKey]PeerBehavior{PeerKey{"foo", "bar"}, PeerBehavior{Reachable: false}})
   * will cause all vine protocol dial calls from "foo" to "bar" to fail.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setBehaviors(
      io.v.v23.context.VContext context,
      final java.util.Map<
              io.v.x.ref.runtime.protocols.vine.PeerKey,
              io.v.x.ref.runtime.protocols.vine.PeerBehavior>
          behaviors);

  /**
   * SetBehaviors sets the policy that the accepting vine service's process
   * will use on connections.
   * behaviors is a map from server tag to the desired connection behavior.
   * For example,
   *   client.SetBehaviors(map[PeerKey]PeerBehavior{PeerKey{"foo", "bar"}, PeerBehavior{Reachable: false}})
   * will cause all vine protocol dial calls from "foo" to "bar" to fail.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setBehaviors(
      io.v.v23.context.VContext context,
      final java.util.Map<
              io.v.x.ref.runtime.protocols.vine.PeerKey,
              io.v.x.ref.runtime.protocols.vine.PeerBehavior>
          behaviors,
      io.v.v23.Options opts);

  /**
   * SetBehaviors sets the policy that the accepting vine service's process
   * will use on connections.
   * behaviors is a map from server tag to the desired connection behavior.
   * For example,
   *   client.SetBehaviors(map[PeerKey]PeerBehavior{PeerKey{"foo", "bar"}, PeerBehavior{Reachable: false}})
   * will cause all vine protocol dial calls from "foo" to "bar" to fail.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setBehaviors(
      io.v.v23.context.VContext context,
      final java.util.Map<
              io.v.x.ref.runtime.protocols.vine.PeerKey,
              io.v.x.ref.runtime.protocols.vine.PeerBehavior>
          behaviors,
      io.v.v23.options.RpcOptions opts);
}
