// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: vine.vdl
package io.v.x.ref.runtime.protocols.vine;

/**
 * PeerBehavior specifies characteristics of a connection.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/x/ref/runtime/protocols/vine.PeerBehavior")
public class PeerBehavior extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Reachable", index = 0)
  private boolean reachable;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Discoverable", index = 1)
  private boolean discoverable;

  /**
   * Vdl type for {@link PeerBehavior}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(PeerBehavior.class);

  /**
   * Creates a new zero-value instance of {@link PeerBehavior}.
   */
  public PeerBehavior() {
    super(VDL_TYPE);

    this.reachable = false;

    this.discoverable = false;
  }

  /**
   * Creates a new instance of {@link PeerBehavior} with the provided field values.
   */
  public PeerBehavior(boolean reachable, boolean discoverable) {
    super(VDL_TYPE);

    this.reachable = reachable;

    this.discoverable = discoverable;
  }

  /**
   * Reachable specifies whether the outgoing or incoming connection can be
   * dialed or accepted.
   * TODO(suharshs): Make this a user defined error which vine will return instead of a bool.
   */
  public boolean getReachable() {
    return this.reachable;
  }

  /**
   * Reachable specifies whether the outgoing or incoming connection can be
   * dialed or accepted.
   * TODO(suharshs): Make this a user defined error which vine will return instead of a bool.
   */
  public void setReachable(boolean reachable) {
    this.reachable = reachable;
  }

  /**
   * Discoverable specifies whether the Dialer can advertise a discovery packet
   * to the Acceptor. This is useful for emulating neighborhoods.
   * TODO(suharshs): Discoverable should always be bidirectional. It is unrealistic for
   * A to discover B, but not vice versa.
   */
  public boolean getDiscoverable() {
    return this.discoverable;
  }

  /**
   * Discoverable specifies whether the Dialer can advertise a discovery packet
   * to the Acceptor. This is useful for emulating neighborhoods.
   * TODO(suharshs): Discoverable should always be bidirectional. It is unrealistic for
   * A to discover B, but not vice versa.
   */
  public void setDiscoverable(boolean discoverable) {
    this.discoverable = discoverable;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    PeerBehavior other = (PeerBehavior) obj;

    if (this.reachable != other.reachable) {
      return false;
    }

    if (this.discoverable != other.discoverable) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + java.lang.Boolean.valueOf(this.reachable).hashCode();

    result = prime * result + java.lang.Boolean.valueOf(this.discoverable).hashCode();

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "reachable:" + this.reachable;

    result += ", ";

    result += "discoverable:" + this.discoverable;

    return result + "}";
  }
}
