// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  benchmark.vdl
package io.v.x.ref.runtime.internal.rpc.benchmark;

/**
 * Wrapper for {@link BenchmarkServer}.  This wrapper is used by
 * {@link io.v.v23.rpc.ReflectInvoker} to indirectly invoke server methods.
 */
public final class BenchmarkServerWrapper {
  private final io.v.x.ref.runtime.internal.rpc.benchmark.BenchmarkServer server;

  /**
   * Creates a new {@link BenchmarkServerWrapper} to invoke the methods of the
   * provided server.
   *
   * @param server server whose methods are to be invoked
   */
  public BenchmarkServerWrapper(io.v.x.ref.runtime.internal.rpc.benchmark.BenchmarkServer server) {
    this.server = server;
  }

  /**
   * Returns a description of this server.
   */
  public io.v.v23.vdlroot.signature.Interface signature() {
    java.util.List<io.v.v23.vdlroot.signature.Embed> embeds =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Embed>();
    java.util.List<io.v.v23.vdlroot.signature.Method> methods =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Method>();

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg("", "", new io.v.v23.vdl.VdlTypeObject(byte[].class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg("", "", new io.v.v23.vdl.VdlTypeObject(byte[].class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "echo",
              "// Echo returns the payload that it receives." + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "echoStream",
              "// EchoStream returns the payload that it receives via the stream." + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    return new io.v.v23.vdlroot.signature.Interface(
        "Benchmark", "io.v.x.ref.runtime.internal.rpc.benchmark", "", embeds, methods);
  }

  /**
   * Returns all tags associated with the provided method or {@code null} if the method isn't
   * implemented by this server.
   *
   * @param method method whose tags are to be returned
   */
  @SuppressWarnings("unused")
  public io.v.v23.vdl.VdlValue[] getMethodTags(java.lang.String method)
      throws io.v.v23.verror.VException {

    if ("echo".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"echo\": %s", e.getMessage()));
      }
    }

    if ("echoStream".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"echoStream\": %s", e.getMessage()));
      }
    }

    return null; // method not found
  }

  /**
   * Echo returns the payload that it receives.
   */
  public com.google.common.util.concurrent.ListenableFuture<byte[]> echo(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final byte[] Payload) {

    return this.server.echo(_ctx, _call, Payload);
  }

  /**
   * EchoStream returns the payload that it receives via the stream.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> echoStream(
      io.v.v23.context.VContext _ctx, final io.v.v23.rpc.StreamServerCall _call) {

    io.v.v23.vdl.ServerStream<byte[], byte[]> _stream =
        new io.v.v23.vdl.ServerStream<byte[], byte[]>() {
          @Override
          public com.google.common.util.concurrent.ListenableFuture<Void> send(byte[] _item) {
            java.lang.reflect.Type _type = byte[].class;
            return _call.send(_item, _type);
          }

          @Override
          public com.google.common.util.concurrent.ListenableFuture<byte[]> recv() {
            java.lang.reflect.Type _type = byte[].class;
            return com.google.common.util.concurrent.Futures.transform(
                _call.recv(_type),
                new com.google.common.base.Function<Object, byte[]>() {
                  @Override
                  public byte[] apply(Object result) {
                    return (byte[]) result;
                  }
                });
          }
        };

    return this.server.echoStream(_ctx, _call, _stream);
  }
}
