// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.x.ref.runtime.internal.flow.conn;

/**
 * EncryptedBlessings is used to transport encrypted blessings between the
 * two ends of a Conn. The encryption is with respect to a set of blessing
 * patterns that define the set of peers that are allowed to see the blessings.
 * Since encrypted blessings can be large, we try not to send them more than
 * once by associating them with an integer key (BKey). Thereafter we refer to
 * them by their key.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/x/ref/runtime/internal/flow/conn.EncryptedBlessings")
public class EncryptedBlessings extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Ciphertexts", index = 0)
  private java.util.List<io.v.x.ref.lib.security.bcrypter.WireCiphertext> ciphertexts;

  @io.v.v23.vdl.GeneratedFromVdl(name = "BKey", index = 1)
  private io.v.v23.vdl.VdlUint64 bKey;

  /**
   * Vdl type for {@link EncryptedBlessings}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(EncryptedBlessings.class);

  /**
   * Creates a new zero-value instance of {@link EncryptedBlessings}.
   */
  public EncryptedBlessings() {
    super(VDL_TYPE);

    this.ciphertexts = new java.util.ArrayList<io.v.x.ref.lib.security.bcrypter.WireCiphertext>();

    this.bKey = new io.v.v23.vdl.VdlUint64();
  }

  /**
   * Creates a new instance of {@link EncryptedBlessings} with the provided field values.
   */
  public EncryptedBlessings(
      java.util.List<io.v.x.ref.lib.security.bcrypter.WireCiphertext> ciphertexts,
      io.v.v23.vdl.VdlUint64 bKey) {
    super(VDL_TYPE);

    this.ciphertexts = ciphertexts;

    this.bKey = bKey;
  }

  public java.util.List<io.v.x.ref.lib.security.bcrypter.WireCiphertext> getCiphertexts() {
    return this.ciphertexts;
  }

  public void setCiphertexts(
      java.util.List<io.v.x.ref.lib.security.bcrypter.WireCiphertext> ciphertexts) {
    this.ciphertexts = ciphertexts;
  }

  public io.v.v23.vdl.VdlUint64 getBKey() {
    return this.bKey;
  }

  public void setBKey(io.v.v23.vdl.VdlUint64 bKey) {
    this.bKey = bKey;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    EncryptedBlessings other = (EncryptedBlessings) obj;

    if (this.ciphertexts == null) {
      if (other.ciphertexts != null) {
        return false;
      }
    } else if (!this.ciphertexts.equals(other.ciphertexts)) {
      return false;
    }

    if (this.bKey == null) {
      if (other.bKey != null) {
        return false;
      }
    } else if (!this.bKey.equals(other.bKey)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.ciphertexts == null ? 0 : this.ciphertexts.hashCode());

    result = prime * result + (this.bKey == null ? 0 : this.bKey.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "ciphertexts:" + this.ciphertexts;

    result += ", ";

    result += "bKey:" + this.bKey;

    return result + "}";
  }
}
