// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.x.ref.runtime.internal.flow.conn;

/**
 * Discharges is used to transport discharges between the two ends of a Conn.
 * Since discharges can be large, we try not to send them more than once by
 * associating them with an integer key (DKey). Thereafter we refer to them
 * by their key.
 * Discharges also contains the BKey of the blessings with which the discharges
 * are associated with.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/x/ref/runtime/internal/flow/conn.Discharges")
public class Discharges extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Discharges", index = 0)
  private java.util.List<io.v.v23.security.Discharge> discharges;

  @io.v.v23.vdl.GeneratedFromVdl(name = "DKey", index = 1)
  private io.v.v23.vdl.VdlUint64 dKey;

  @io.v.v23.vdl.GeneratedFromVdl(name = "BKey", index = 2)
  private io.v.v23.vdl.VdlUint64 bKey;

  /**
   * Vdl type for {@link Discharges}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(Discharges.class);

  /**
   * Creates a new zero-value instance of {@link Discharges}.
   */
  public Discharges() {
    super(VDL_TYPE);

    this.discharges = new java.util.ArrayList<io.v.v23.security.Discharge>();

    this.dKey = new io.v.v23.vdl.VdlUint64();

    this.bKey = new io.v.v23.vdl.VdlUint64();
  }

  /**
   * Creates a new instance of {@link Discharges} with the provided field values.
   */
  public Discharges(
      java.util.List<io.v.v23.security.Discharge> discharges,
      io.v.v23.vdl.VdlUint64 dKey,
      io.v.v23.vdl.VdlUint64 bKey) {
    super(VDL_TYPE);

    this.discharges = discharges;

    this.dKey = dKey;

    this.bKey = bKey;
  }

  public java.util.List<io.v.v23.security.Discharge> getDischarges() {
    return this.discharges;
  }

  public void setDischarges(java.util.List<io.v.v23.security.Discharge> discharges) {
    this.discharges = discharges;
  }

  public io.v.v23.vdl.VdlUint64 getDKey() {
    return this.dKey;
  }

  public void setDKey(io.v.v23.vdl.VdlUint64 dKey) {
    this.dKey = dKey;
  }

  public io.v.v23.vdl.VdlUint64 getBKey() {
    return this.bKey;
  }

  public void setBKey(io.v.v23.vdl.VdlUint64 bKey) {
    this.bKey = bKey;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    Discharges other = (Discharges) obj;

    if (this.discharges == null) {
      if (other.discharges != null) {
        return false;
      }
    } else if (!this.discharges.equals(other.discharges)) {
      return false;
    }

    if (this.dKey == null) {
      if (other.dKey != null) {
        return false;
      }
    } else if (!this.dKey.equals(other.dKey)) {
      return false;
    }

    if (this.bKey == null) {
      if (other.bKey != null) {
        return false;
      }
    } else if (!this.bKey.equals(other.bKey)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.discharges == null ? 0 : this.discharges.hashCode());

    result = prime * result + (this.dKey == null ? 0 : this.dKey.hashCode());

    result = prime * result + (this.bKey == null ? 0 : this.bKey.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "discharges:" + this.discharges;

    result += ", ";

    result += "dKey:" + this.dKey;

    result += ", ";

    result += "bKey:" + this.bKey;

    return result + "}";
  }
}
