// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  base.vdl
package io.v.x.ref.lib.vdl.testdata.base;

/**
 * Wrapper for {@link ServiceBServer}.  This wrapper is used by
 * {@link io.v.v23.rpc.ReflectInvoker} to indirectly invoke server methods.
 */
public final class ServiceBServerWrapper {
  private final io.v.x.ref.lib.vdl.testdata.base.ServiceBServer server;

  private final io.v.x.ref.lib.vdl.testdata.base.ServiceAServerWrapper wrapperServiceA;

  /**
   * Creates a new {@link ServiceBServerWrapper} to invoke the methods of the
   * provided server.
   *
   * @param server server whose methods are to be invoked
   */
  public ServiceBServerWrapper(io.v.x.ref.lib.vdl.testdata.base.ServiceBServer server) {
    this.server = server;

    this.wrapperServiceA = new io.v.x.ref.lib.vdl.testdata.base.ServiceAServerWrapper(server);
  }

  /**
   * Returns a description of this server.
   */
  public io.v.v23.vdlroot.signature.Interface signature() {
    java.util.List<io.v.v23.vdlroot.signature.Embed> embeds =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Embed>();
    java.util.List<io.v.v23.vdlroot.signature.Method> methods =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Method>();

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(io.v.x.ref.lib.vdl.testdata.base.Scalars.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(io.v.x.ref.lib.vdl.testdata.base.Composites.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(io.v.x.ref.lib.vdl.testdata.base.CompComp.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      methods.add(
          new io.v.v23.vdlroot.signature.Method("methodB1", "", inArgs, outArgs, null, null, tags));
    }

    return new io.v.v23.vdlroot.signature.Interface(
        "ServiceB", "io.v.x.ref.lib.vdl.testdata.base", "", embeds, methods);
  }

  /**
   * Returns all tags associated with the provided method or {@code null} if the method isn't
   * implemented by this server.
   *
   * @param method method whose tags are to be returned
   */
  @SuppressWarnings("unused")
  public io.v.v23.vdl.VdlValue[] getMethodTags(java.lang.String method)
      throws io.v.v23.verror.VException {

    if ("methodB1".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {};

      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"methodB1\": %s", e.getMessage()));
      }
    }

    {
      io.v.v23.vdl.VdlValue[] tags = this.wrapperServiceA.getMethodTags(method);
      if (tags != null) {
        return tags;
      }
    }

    return null; // method not found
  }

  public com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.lib.vdl.testdata.base.CompComp>
      methodB1(
          io.v.v23.context.VContext _ctx,
          final io.v.v23.rpc.StreamServerCall _call,
          final io.v.x.ref.lib.vdl.testdata.base.Scalars a,
          final io.v.x.ref.lib.vdl.testdata.base.Composites b) {

    return this.server.methodB1(_ctx, _call, a, b);
  }

  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> methodA1(
      io.v.v23.context.VContext ctx, io.v.v23.rpc.StreamServerCall call)
      throws io.v.v23.verror.VException {

    return this.wrapperServiceA.methodA1(ctx, call);
  }

  public com.google.common.util.concurrent.ListenableFuture<java.lang.String> methodA2(
      io.v.v23.context.VContext ctx,
      io.v.v23.rpc.StreamServerCall call,
      final int a,
      final java.lang.String b)
      throws io.v.v23.verror.VException {

    return this.wrapperServiceA.methodA2(ctx, call, a, b);
  }

  public com.google.common.util.concurrent.ListenableFuture<java.lang.String> methodA3(
      io.v.v23.context.VContext ctx, io.v.v23.rpc.StreamServerCall call, final int a)
      throws io.v.v23.verror.VException {

    return this.wrapperServiceA.methodA3(ctx, call, a);
  }

  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> methodA4(
      io.v.v23.context.VContext ctx, io.v.v23.rpc.StreamServerCall call, final int a)
      throws io.v.v23.verror.VException {

    return this.wrapperServiceA.methodA4(ctx, call, a);
  }
}
