// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  base.vdl
package io.v.x.ref.lib.vdl.testdata.base;

/**
 * Implementation of the {@link ServiceBClient} interface.
 */
final class ServiceBClientImpl implements io.v.x.ref.lib.vdl.testdata.base.ServiceBClient {
  private final io.v.v23.rpc.Client client;
  private final java.lang.String vName;

  private final io.v.x.ref.lib.vdl.testdata.base.ServiceAClient implServiceA;

  /**
   * Creates a new instance of {@link ServiceBClientImpl}.
   *
   * @param client Vanadium client
   * @param vName  remote server name
   */
  public ServiceBClientImpl(io.v.v23.rpc.Client client, java.lang.String vName) {
    this.client = client;
    this.vName = vName;

    {
      io.v.v23.Options opts = new io.v.v23.Options();
      opts.set(io.v.v23.OptionDefs.CLIENT, client);
      this.implServiceA =
          io.v.x.ref.lib.vdl.testdata.base.ServiceAClientFactory.getServiceAClient(vName, opts);
    }
  }

  private io.v.v23.rpc.Client getClient(io.v.v23.context.VContext context) {
    return this.client != null ? client : io.v.v23.V.getClient(context);
  }

  // Methods from interface ServiceBClient.

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.lib.vdl.testdata.base.CompComp>
      methodB1(
          io.v.v23.context.VContext _context,
          final io.v.x.ref.lib.vdl.testdata.base.Scalars a,
          final io.v.x.ref.lib.vdl.testdata.base.Composites b) {
    return methodB1(_context, a, b, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.lib.vdl.testdata.base.CompComp>
      methodB1(
          final io.v.v23.context.VContext _context,
          final io.v.x.ref.lib.vdl.testdata.base.Scalars a,
          final io.v.x.ref.lib.vdl.testdata.base.Composites b,
          io.v.v23.Options _opts) {
    return methodB1(_context, a, b, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.lib.vdl.testdata.base.CompComp>
      methodB1(
          final io.v.v23.context.VContext _context,
          final io.v.x.ref.lib.vdl.testdata.base.Scalars a,
          final io.v.x.ref.lib.vdl.testdata.base.Composites b,
          io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {a, b};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {
          io.v.x.ref.lib.vdl.testdata.base.Scalars.class,
          io.v.x.ref.lib.vdl.testdata.base.Composites.class
        };
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "methodB1", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, io.v.x.ref.lib.vdl.testdata.base.CompComp>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<
                      io.v.x.ref.lib.vdl.testdata.base.CompComp>
                  apply(final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      io.v.x.ref.lib.vdl.testdata.base.CompComp.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<
                        Object[], io.v.x.ref.lib.vdl.testdata.base.CompComp>() {
                      @Override
                      public io.v.x.ref.lib.vdl.testdata.base.CompComp apply(Object[] _results) {

                        return (io.v.x.ref.lib.vdl.testdata.base.CompComp) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> methodA1(
      io.v.v23.context.VContext _context) {

    return this.implServiceA.methodA1(_context);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> methodA1(
      io.v.v23.context.VContext _context, io.v.v23.Options _opts) {

    return this.implServiceA.methodA1(_context, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> methodA1(
      io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    return this.implServiceA.methodA1(_context, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.String> methodA2(
      io.v.v23.context.VContext _context, final int a, final java.lang.String b) {

    return this.implServiceA.methodA2(_context, a, b);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.String> methodA2(
      io.v.v23.context.VContext _context,
      final int a,
      final java.lang.String b,
      io.v.v23.Options _opts) {

    return this.implServiceA.methodA2(_context, a, b, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.String> methodA2(
      io.v.v23.context.VContext _context,
      final int a,
      final java.lang.String b,
      io.v.v23.options.RpcOptions _opts) {

    return this.implServiceA.methodA2(_context, a, b, _opts);
  }

  @Override
  public io.v.v23.vdl.ClientRecvStream<io.v.x.ref.lib.vdl.testdata.base.Scalars, java.lang.String>
      methodA3(io.v.v23.context.VContext _context, final int a) {

    return this.implServiceA.methodA3(_context, a);
  }

  @Deprecated
  @Override
  public io.v.v23.vdl.ClientRecvStream<io.v.x.ref.lib.vdl.testdata.base.Scalars, java.lang.String>
      methodA3(io.v.v23.context.VContext _context, final int a, io.v.v23.Options _opts) {

    return this.implServiceA.methodA3(_context, a, _opts);
  }

  @Override
  public io.v.v23.vdl.ClientRecvStream<io.v.x.ref.lib.vdl.testdata.base.Scalars, java.lang.String>
      methodA3(io.v.v23.context.VContext _context, final int a, io.v.v23.options.RpcOptions _opts) {

    return this.implServiceA.methodA3(_context, a, _opts);
  }

  @Override
  public io.v.v23.vdl.ClientStream<java.lang.Integer, java.lang.String, java.lang.Void> methodA4(
      io.v.v23.context.VContext _context, final int a) {

    return this.implServiceA.methodA4(_context, a);
  }

  @Deprecated
  @Override
  public io.v.v23.vdl.ClientStream<java.lang.Integer, java.lang.String, java.lang.Void> methodA4(
      io.v.v23.context.VContext _context, final int a, io.v.v23.Options _opts) {

    return this.implServiceA.methodA4(_context, a, _opts);
  }

  @Override
  public io.v.v23.vdl.ClientStream<java.lang.Integer, java.lang.String, java.lang.Void> methodA4(
      io.v.v23.context.VContext _context, final int a, io.v.v23.options.RpcOptions _opts) {

    return this.implServiceA.methodA4(_context, a, _opts);
  }
}
