// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  arith.vdl
package io.v.x.ref.lib.vdl.testdata.arith;

/**
 * Wrapper for {@link CalculatorServer}.  This wrapper is used by
 * {@link io.v.v23.rpc.ReflectInvoker} to indirectly invoke server methods.
 */
public final class CalculatorServerWrapper {
  private final io.v.x.ref.lib.vdl.testdata.arith.CalculatorServer server;

  private final io.v.x.ref.lib.vdl.testdata.arith.ArithServerWrapper wrapperArith;

  private final io.v.x.ref.lib.vdl.testdata.arith.TrigonometryServerWrapper wrapperTrigonometry;

  private final io.v.x.ref.lib.vdl.testdata.arith.exp.ExpServerWrapper wrapperExp;

  private final io.v.x.ref.lib.vdl.testdata.arith.AdvancedMathServerWrapper wrapperAdvancedMath;

  /**
   * Creates a new {@link CalculatorServerWrapper} to invoke the methods of the
   * provided server.
   *
   * @param server server whose methods are to be invoked
   */
  public CalculatorServerWrapper(io.v.x.ref.lib.vdl.testdata.arith.CalculatorServer server) {
    this.server = server;

    this.wrapperArith = new io.v.x.ref.lib.vdl.testdata.arith.ArithServerWrapper(server);

    this.wrapperTrigonometry =
        new io.v.x.ref.lib.vdl.testdata.arith.TrigonometryServerWrapper(server);

    this.wrapperExp = new io.v.x.ref.lib.vdl.testdata.arith.exp.ExpServerWrapper(server);

    this.wrapperAdvancedMath =
        new io.v.x.ref.lib.vdl.testdata.arith.AdvancedMathServerWrapper(server);
  }

  /**
   * Returns a description of this server.
   */
  public io.v.v23.vdlroot.signature.Interface signature() {
    java.util.List<io.v.v23.vdlroot.signature.Embed> embeds =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Embed>();
    java.util.List<io.v.v23.vdlroot.signature.Method> methods =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Method>();

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      methods.add(
          new io.v.v23.vdlroot.signature.Method("on", "", inArgs, outArgs, null, null, tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(io.v.v23.vdl.VdlValue.valueOf("offtag", java.lang.String.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method("off", "", inArgs, outArgs, null, null, tags));
    }

    return new io.v.v23.vdlroot.signature.Interface(
        "Calculator", "io.v.x.ref.lib.vdl.testdata.arith", "", embeds, methods);
  }

  /**
   * Returns all tags associated with the provided method or {@code null} if the method isn't
   * implemented by this server.
   *
   * @param method method whose tags are to be returned
   */
  @SuppressWarnings("unused")
  public io.v.v23.vdl.VdlValue[] getMethodTags(java.lang.String method)
      throws io.v.v23.verror.VException {

    if ("off".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf("offtag", java.lang.String.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"off\": %s", e.getMessage()));
      }
    }

    if ("on".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {};

      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"on\": %s", e.getMessage()));
      }
    }

    {
      io.v.v23.vdl.VdlValue[] tags = this.wrapperArith.getMethodTags(method);
      if (tags != null) {
        return tags;
      }
    }

    {
      io.v.v23.vdl.VdlValue[] tags = this.wrapperTrigonometry.getMethodTags(method);
      if (tags != null) {
        return tags;
      }
    }

    {
      io.v.v23.vdl.VdlValue[] tags = this.wrapperExp.getMethodTags(method);
      if (tags != null) {
        return tags;
      }
    }

    {
      io.v.v23.vdl.VdlValue[] tags = this.wrapperAdvancedMath.getMethodTags(method);
      if (tags != null) {
        return tags;
      }
    }

    return null; // method not found
  }

  /**
   * On turns the calculator on.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> on(
      io.v.v23.context.VContext _ctx, final io.v.v23.rpc.StreamServerCall _call) {

    return this.server.on(_ctx, _call);
  }

  /**
   * Off turns the calculator off.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> off(
      io.v.v23.context.VContext _ctx, final io.v.v23.rpc.StreamServerCall _call) {

    return this.server.off(_ctx, _call);
  }

  public com.google.common.util.concurrent.ListenableFuture<java.lang.Double> exp(
      io.v.v23.context.VContext ctx, io.v.v23.rpc.StreamServerCall call, final double x)
      throws io.v.v23.verror.VException {

    return this.wrapperExp.exp(ctx, call, x);
  }

  /**
   * Add is a typical method with multiple input and output arguments.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> add(
      io.v.v23.context.VContext ctx, io.v.v23.rpc.StreamServerCall call, final int a, final int b)
      throws io.v.v23.verror.VException {

    return this.wrapperArith.add(ctx, call, a, b);
  }

  /**
   * Count shows using only an int32 out-stream type, with no in-stream type.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> count(
      io.v.v23.context.VContext ctx, io.v.v23.rpc.StreamServerCall call, final int start)
      throws io.v.v23.verror.VException {

    return this.wrapperArith.count(ctx, call, start);
  }

  /**
   * DivMod shows that runs of args with the same type can use the short form,
   * just like Go.
   */
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.lib.vdl.testdata.arith.ArithServer.DivModOut>
      divMod(
          io.v.v23.context.VContext ctx,
          io.v.v23.rpc.StreamServerCall call,
          final int a,
          final int b)
          throws io.v.v23.verror.VException {

    return this.wrapperArith.divMod(ctx, call, a, b);
  }

  /**
   * GenError shows that it's fine to have no in args, and no out args other
   * than "error".  In addition GenError shows the usage of tags.  Tags are a
   * sequence of constants.  There's no requirement on uniqueness of types or
   * values, and regular const expressions may also be used.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> genError(
      io.v.v23.context.VContext ctx, io.v.v23.rpc.StreamServerCall call)
      throws io.v.v23.verror.VException {

    return this.wrapperArith.genError(ctx, call);
  }

  /**
   * Mul tries another data type defined in another package.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> mul(
      io.v.v23.context.VContext ctx,
      io.v.v23.rpc.StreamServerCall call,
      final io.v.x.ref.lib.vdl.testdata.base.NestedArgs nested)
      throws io.v.v23.verror.VException {

    return this.wrapperArith.mul(ctx, call, nested);
  }

  /**
   * QuoteAny shows the any built-in type, representing a value of any type.
   */
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.vdl.VdlAny> quoteAny(
      io.v.v23.context.VContext ctx,
      io.v.v23.rpc.StreamServerCall call,
      final io.v.v23.vdl.VdlAny a)
      throws io.v.v23.verror.VException {

    return this.wrapperArith.quoteAny(ctx, call, a);
  }

  /**
   * StreamingAdd shows a bidirectional stream.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> streamingAdd(
      io.v.v23.context.VContext ctx, io.v.v23.rpc.StreamServerCall call)
      throws io.v.v23.verror.VException {

    return this.wrapperArith.streamingAdd(ctx, call);
  }

  /**
   * Sub shows that you can use data types defined in other packages.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> sub(
      io.v.v23.context.VContext ctx,
      io.v.v23.rpc.StreamServerCall call,
      final io.v.x.ref.lib.vdl.testdata.base.Args args)
      throws io.v.v23.verror.VException {

    return this.wrapperArith.sub(ctx, call, args);
  }

  public com.google.common.util.concurrent.ListenableFuture<java.lang.Double> cosine(
      io.v.v23.context.VContext ctx, io.v.v23.rpc.StreamServerCall call, final double angle)
      throws io.v.v23.verror.VException {

    return this.wrapperTrigonometry.cosine(ctx, call, angle);
  }

  public com.google.common.util.concurrent.ListenableFuture<java.lang.Double> sine(
      io.v.v23.context.VContext ctx, io.v.v23.rpc.StreamServerCall call, final double angle)
      throws io.v.v23.verror.VException {

    return this.wrapperTrigonometry.sine(ctx, call, angle);
  }
}
