// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  arith.vdl
package io.v.x.ref.lib.vdl.testdata.arith;

/**
 * Implementation of the {@link CalculatorClient} interface.
 */
final class CalculatorClientImpl implements io.v.x.ref.lib.vdl.testdata.arith.CalculatorClient {
  private final io.v.v23.rpc.Client client;
  private final java.lang.String vName;

  private final io.v.x.ref.lib.vdl.testdata.arith.ArithClient implArith;

  private final io.v.x.ref.lib.vdl.testdata.arith.TrigonometryClient implTrigonometry;

  private final io.v.x.ref.lib.vdl.testdata.arith.exp.ExpClient implExp;

  private final io.v.x.ref.lib.vdl.testdata.arith.AdvancedMathClient implAdvancedMath;

  /**
   * Creates a new instance of {@link CalculatorClientImpl}.
   *
   * @param client Vanadium client
   * @param vName  remote server name
   */
  public CalculatorClientImpl(io.v.v23.rpc.Client client, java.lang.String vName) {
    this.client = client;
    this.vName = vName;

    {
      io.v.v23.Options opts = new io.v.v23.Options();
      opts.set(io.v.v23.OptionDefs.CLIENT, client);
      this.implArith =
          io.v.x.ref.lib.vdl.testdata.arith.ArithClientFactory.getArithClient(vName, opts);
    }

    {
      io.v.v23.Options opts = new io.v.v23.Options();
      opts.set(io.v.v23.OptionDefs.CLIENT, client);
      this.implTrigonometry =
          io.v.x.ref.lib.vdl.testdata.arith.TrigonometryClientFactory.getTrigonometryClient(
              vName, opts);
    }

    {
      io.v.v23.Options opts = new io.v.v23.Options();
      opts.set(io.v.v23.OptionDefs.CLIENT, client);
      this.implExp =
          io.v.x.ref.lib.vdl.testdata.arith.exp.ExpClientFactory.getExpClient(vName, opts);
    }

    {
      io.v.v23.Options opts = new io.v.v23.Options();
      opts.set(io.v.v23.OptionDefs.CLIENT, client);
      this.implAdvancedMath =
          io.v.x.ref.lib.vdl.testdata.arith.AdvancedMathClientFactory.getAdvancedMathClient(
              vName, opts);
    }
  }

  private io.v.v23.rpc.Client getClient(io.v.v23.context.VContext context) {
    return this.client != null ? client : io.v.v23.V.getClient(context);
  }

  // Methods from interface CalculatorClient.

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> on(
      io.v.v23.context.VContext _context) {
    return on(_context, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> on(
      final io.v.v23.context.VContext _context, io.v.v23.Options _opts) {
    return on(_context, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> on(
      final io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "on", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Void>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes = new java.lang.reflect.Type[] {};

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Void>() {
                      @Override
                      public java.lang.Void apply(Object[] _results) {

                        return null;
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> off(
      io.v.v23.context.VContext _context) {
    return off(_context, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> off(
      final io.v.v23.context.VContext _context, io.v.v23.Options _opts) {
    return off(_context, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> off(
      final io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "off", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Void>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes = new java.lang.reflect.Type[] {};

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Void>() {
                      @Override
                      public java.lang.Void apply(Object[] _results) {

                        return null;
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Double> exp(
      io.v.v23.context.VContext _context, final double x) {

    return this.implExp.exp(_context, x);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Double> exp(
      io.v.v23.context.VContext _context, final double x, io.v.v23.Options _opts) {

    return this.implExp.exp(_context, x, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Double> exp(
      io.v.v23.context.VContext _context, final double x, io.v.v23.options.RpcOptions _opts) {

    return this.implExp.exp(_context, x, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> add(
      io.v.v23.context.VContext _context, final int a, final int b) {

    return this.implArith.add(_context, a, b);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> add(
      io.v.v23.context.VContext _context, final int a, final int b, io.v.v23.Options _opts) {

    return this.implArith.add(_context, a, b, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> add(
      io.v.v23.context.VContext _context,
      final int a,
      final int b,
      io.v.v23.options.RpcOptions _opts) {

    return this.implArith.add(_context, a, b, _opts);
  }

  @Override
  public io.v.v23.vdl.ClientRecvStream<java.lang.Integer, java.lang.Void> count(
      io.v.v23.context.VContext _context, final int start) {

    return this.implArith.count(_context, start);
  }

  @Deprecated
  @Override
  public io.v.v23.vdl.ClientRecvStream<java.lang.Integer, java.lang.Void> count(
      io.v.v23.context.VContext _context, final int start, io.v.v23.Options _opts) {

    return this.implArith.count(_context, start, _opts);
  }

  @Override
  public io.v.v23.vdl.ClientRecvStream<java.lang.Integer, java.lang.Void> count(
      io.v.v23.context.VContext _context, final int start, io.v.v23.options.RpcOptions _opts) {

    return this.implArith.count(_context, start, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.lib.vdl.testdata.arith.ArithClient.DivModOut>
      divMod(io.v.v23.context.VContext _context, final int a, final int b) {

    return this.implArith.divMod(_context, a, b);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.lib.vdl.testdata.arith.ArithClient.DivModOut>
      divMod(io.v.v23.context.VContext _context, final int a, final int b, io.v.v23.Options _opts) {

    return this.implArith.divMod(_context, a, b, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.lib.vdl.testdata.arith.ArithClient.DivModOut>
      divMod(
          io.v.v23.context.VContext _context,
          final int a,
          final int b,
          io.v.v23.options.RpcOptions _opts) {

    return this.implArith.divMod(_context, a, b, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> genError(
      io.v.v23.context.VContext _context) {

    return this.implArith.genError(_context);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> genError(
      io.v.v23.context.VContext _context, io.v.v23.Options _opts) {

    return this.implArith.genError(_context, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> genError(
      io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    return this.implArith.genError(_context, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> mul(
      io.v.v23.context.VContext _context,
      final io.v.x.ref.lib.vdl.testdata.base.NestedArgs nested) {

    return this.implArith.mul(_context, nested);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> mul(
      io.v.v23.context.VContext _context,
      final io.v.x.ref.lib.vdl.testdata.base.NestedArgs nested,
      io.v.v23.Options _opts) {

    return this.implArith.mul(_context, nested, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> mul(
      io.v.v23.context.VContext _context,
      final io.v.x.ref.lib.vdl.testdata.base.NestedArgs nested,
      io.v.v23.options.RpcOptions _opts) {

    return this.implArith.mul(_context, nested, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.vdl.VdlAny> quoteAny(
      io.v.v23.context.VContext _context, final io.v.v23.vdl.VdlAny a) {

    return this.implArith.quoteAny(_context, a);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.vdl.VdlAny> quoteAny(
      io.v.v23.context.VContext _context, final io.v.v23.vdl.VdlAny a, io.v.v23.Options _opts) {

    return this.implArith.quoteAny(_context, a, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.vdl.VdlAny> quoteAny(
      io.v.v23.context.VContext _context,
      final io.v.v23.vdl.VdlAny a,
      io.v.v23.options.RpcOptions _opts) {

    return this.implArith.quoteAny(_context, a, _opts);
  }

  @Override
  public io.v.v23.vdl.ClientStream<java.lang.Integer, java.lang.Integer, java.lang.Integer>
      streamingAdd(io.v.v23.context.VContext _context) {

    return this.implArith.streamingAdd(_context);
  }

  @Deprecated
  @Override
  public io.v.v23.vdl.ClientStream<java.lang.Integer, java.lang.Integer, java.lang.Integer>
      streamingAdd(io.v.v23.context.VContext _context, io.v.v23.Options _opts) {

    return this.implArith.streamingAdd(_context, _opts);
  }

  @Override
  public io.v.v23.vdl.ClientStream<java.lang.Integer, java.lang.Integer, java.lang.Integer>
      streamingAdd(io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    return this.implArith.streamingAdd(_context, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> sub(
      io.v.v23.context.VContext _context, final io.v.x.ref.lib.vdl.testdata.base.Args args) {

    return this.implArith.sub(_context, args);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> sub(
      io.v.v23.context.VContext _context,
      final io.v.x.ref.lib.vdl.testdata.base.Args args,
      io.v.v23.Options _opts) {

    return this.implArith.sub(_context, args, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> sub(
      io.v.v23.context.VContext _context,
      final io.v.x.ref.lib.vdl.testdata.base.Args args,
      io.v.v23.options.RpcOptions _opts) {

    return this.implArith.sub(_context, args, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Double> cosine(
      io.v.v23.context.VContext _context, final double angle) {

    return this.implTrigonometry.cosine(_context, angle);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Double> cosine(
      io.v.v23.context.VContext _context, final double angle, io.v.v23.Options _opts) {

    return this.implTrigonometry.cosine(_context, angle, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Double> cosine(
      io.v.v23.context.VContext _context, final double angle, io.v.v23.options.RpcOptions _opts) {

    return this.implTrigonometry.cosine(_context, angle, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Double> sine(
      io.v.v23.context.VContext _context, final double angle) {

    return this.implTrigonometry.sine(_context, angle);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Double> sine(
      io.v.v23.context.VContext _context, final double angle, io.v.v23.Options _opts) {

    return this.implTrigonometry.sine(_context, angle, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Double> sine(
      io.v.v23.context.VContext _context, final double angle, io.v.v23.options.RpcOptions _opts) {

    return this.implTrigonometry.sine(_context, angle, _opts);
  }
}
