// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  arith.vdl
package io.v.x.ref.lib.vdl.testdata.arith;

/**
 * Wrapper for {@link ArithServer}.  This wrapper is used by
 * {@link io.v.v23.rpc.ReflectInvoker} to indirectly invoke server methods.
 */
public final class ArithServerWrapper {
  private final io.v.x.ref.lib.vdl.testdata.arith.ArithServer server;

  /**
   * Creates a new {@link ArithServerWrapper} to invoke the methods of the
   * provided server.
   *
   * @param server server whose methods are to be invoked
   */
  public ArithServerWrapper(io.v.x.ref.lib.vdl.testdata.arith.ArithServer server) {
    this.server = server;
  }

  /**
   * Returns a description of this server.
   */
  public io.v.v23.vdlroot.signature.Interface signature() {
    java.util.List<io.v.v23.vdlroot.signature.Embed> embeds =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Embed>();
    java.util.List<io.v.v23.vdlroot.signature.Method> methods =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Method>();

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.Integer.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.Integer.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.Integer.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "add",
              "// Add is a typical method with multiple input and output arguments." + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.Integer.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.Integer.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.Integer.class)));

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.Integer.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "divMod",
              "// DivMod shows that runs of args with the same type can use the short form,"
                  + "// just like Go."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.x.ref.lib.vdl.testdata.base.Args.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.Integer.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "sub",
              "// Sub shows that you can use data types defined in other packages." + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(io.v.x.ref.lib.vdl.testdata.base.NestedArgs.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.Integer.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "mul",
              "// Mul tries another data type defined in another package." + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(io.v.v23.vdl.VdlValue.valueOf("foo", java.lang.String.class)));

      tags.add(
          new io.v.v23.vdl.VdlAny(io.v.v23.vdl.VdlValue.valueOf("barz", java.lang.String.class)));

      tags.add(
          new io.v.v23.vdl.VdlAny(io.v.v23.vdl.VdlValue.valueOf("hello", java.lang.String.class)));

      tags.add(
          new io.v.v23.vdl.VdlAny(io.v.v23.vdl.VdlValue.valueOf(129, java.lang.Integer.class)));

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.vdl.VdlUint64(36L), io.v.v23.vdl.VdlUint64.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "genError",
              "// GenError shows that it's fine to have no in args, and no out args other"
                  + "// than \"error\".  In addition GenError shows the usage of tags.  Tags are a"
                  + "// sequence of constants.  There's no requirement on uniqueness of types or"
                  + "// values, and regular const expressions may also be used."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.Integer.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "count",
              "// Count shows using only an int32 out-stream type, with no in-stream type." + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.Integer.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "streamingAdd",
              "// StreamingAdd shows a bidirectional stream." + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.v23.vdl.VdlAny.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.v23.vdl.VdlAny.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "quoteAny",
              "// QuoteAny shows the any built-in type, representing a value of any type." + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    return new io.v.v23.vdlroot.signature.Interface(
        "Arith",
        "io.v.x.ref.lib.vdl.testdata.arith",
        "// Arith is an example of an interface definition for an arithmetic service."
            + "// Things to note:"
            + "//   * There must be at least 1 out-arg, and the last out-arg must be error."
            + "",
        embeds,
        methods);
  }

  /**
   * Returns all tags associated with the provided method or {@code null} if the method isn't
   * implemented by this server.
   *
   * @param method method whose tags are to be returned
   */
  @SuppressWarnings("unused")
  public io.v.v23.vdl.VdlValue[] getMethodTags(java.lang.String method)
      throws io.v.v23.verror.VException {

    if ("add".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {};

      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"add\": %s", e.getMessage()));
      }
    }

    if ("count".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {};

      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"count\": %s", e.getMessage()));
      }
    }

    if ("divMod".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {};

      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"divMod\": %s", e.getMessage()));
      }
    }

    if ("genError".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf("foo", java.lang.String.class),
          io.v.v23.vdl.VdlValue.valueOf("barz", java.lang.String.class),
          io.v.v23.vdl.VdlValue.valueOf("hello", java.lang.String.class),
          io.v.v23.vdl.VdlValue.valueOf(129, java.lang.Integer.class),
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.vdl.VdlUint64(36L), io.v.v23.vdl.VdlUint64.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"genError\": %s", e.getMessage()));
      }
    }

    if ("mul".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {};

      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"mul\": %s", e.getMessage()));
      }
    }

    if ("quoteAny".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {};

      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"quoteAny\": %s", e.getMessage()));
      }
    }

    if ("streamingAdd".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {};

      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"streamingAdd\": %s", e.getMessage()));
      }
    }

    if ("sub".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {};

      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"sub\": %s", e.getMessage()));
      }
    }

    return null; // method not found
  }

  /**
   * Add is a typical method with multiple input and output arguments.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> add(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final int a,
      final int b) {

    return this.server.add(_ctx, _call, a, b);
  }

  /**
   * DivMod shows that runs of args with the same type can use the short form,
   * just like Go.
   */
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.lib.vdl.testdata.arith.ArithServer.DivModOut>
      divMod(
          io.v.v23.context.VContext _ctx,
          final io.v.v23.rpc.StreamServerCall _call,
          final int a,
          final int b) {

    return this.server.divMod(_ctx, _call, a, b);
  }

  /**
   * Sub shows that you can use data types defined in other packages.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> sub(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final io.v.x.ref.lib.vdl.testdata.base.Args args) {

    return this.server.sub(_ctx, _call, args);
  }

  /**
   * Mul tries another data type defined in another package.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> mul(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final io.v.x.ref.lib.vdl.testdata.base.NestedArgs nested) {

    return this.server.mul(_ctx, _call, nested);
  }

  /**
   * GenError shows that it's fine to have no in args, and no out args other
   * than "error".  In addition GenError shows the usage of tags.  Tags are a
   * sequence of constants.  There's no requirement on uniqueness of types or
   * values, and regular const expressions may also be used.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> genError(
      io.v.v23.context.VContext _ctx, final io.v.v23.rpc.StreamServerCall _call) {

    return this.server.genError(_ctx, _call);
  }

  /**
   * Count shows using only an int32 out-stream type, with no in-stream type.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> count(
      io.v.v23.context.VContext _ctx, final io.v.v23.rpc.StreamServerCall _call, final int start) {

    io.v.v23.vdl.ServerStream<java.lang.Integer, java.lang.Void> _stream =
        new io.v.v23.vdl.ServerStream<java.lang.Integer, java.lang.Void>() {
          @Override
          public com.google.common.util.concurrent.ListenableFuture<Void> send(
              java.lang.Integer _item) {
            java.lang.reflect.Type _type = java.lang.Integer.class;
            return _call.send(_item, _type);
          }

          @Override
          public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> recv() {
            java.lang.reflect.Type _type = java.lang.Void.class;
            return com.google.common.util.concurrent.Futures.transform(
                _call.recv(_type),
                new com.google.common.base.Function<Object, java.lang.Void>() {
                  @Override
                  public java.lang.Void apply(Object result) {
                    return (java.lang.Void) result;
                  }
                });
          }
        };

    return this.server.count(_ctx, _call, start, _stream);
  }

  /**
   * StreamingAdd shows a bidirectional stream.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> streamingAdd(
      io.v.v23.context.VContext _ctx, final io.v.v23.rpc.StreamServerCall _call) {

    io.v.v23.vdl.ServerStream<java.lang.Integer, java.lang.Integer> _stream =
        new io.v.v23.vdl.ServerStream<java.lang.Integer, java.lang.Integer>() {
          @Override
          public com.google.common.util.concurrent.ListenableFuture<Void> send(
              java.lang.Integer _item) {
            java.lang.reflect.Type _type = java.lang.Integer.class;
            return _call.send(_item, _type);
          }

          @Override
          public com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> recv() {
            java.lang.reflect.Type _type = java.lang.Integer.class;
            return com.google.common.util.concurrent.Futures.transform(
                _call.recv(_type),
                new com.google.common.base.Function<Object, java.lang.Integer>() {
                  @Override
                  public java.lang.Integer apply(Object result) {
                    return (java.lang.Integer) result;
                  }
                });
          }
        };

    return this.server.streamingAdd(_ctx, _call, _stream);
  }

  /**
   * QuoteAny shows the any built-in type, representing a value of any type.
   */
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.vdl.VdlAny> quoteAny(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final io.v.v23.vdl.VdlAny a) {

    return this.server.quoteAny(_ctx, _call, a);
  }
}
