// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: arith.vdl
package io.v.x.ref.lib.vdl.testdata.arith;

/**
 * Arith is an example of an interface definition for an arithmetic service.
 * Things to note:
 *   * There must be at least 1 out-arg, and the last out-arg must be error.
 */
@io.v.v23.vdl.VServer(serverWrapper = io.v.x.ref.lib.vdl.testdata.arith.ArithServerWrapper.class)
public interface ArithServer {

  /**
   * Add is a typical method with multiple input and output arguments.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> add(
      io.v.v23.context.VContext context, io.v.v23.rpc.ServerCall call, final int a, final int b);

  /**
   * Multi-return value for method {@link #divMod}.
   */
  @io.v.v23.vdl.MultiReturn
  public static class DivModOut {

    public int quot;

    public int rem;
  }

  /**
   * DivMod shows that runs of args with the same type can use the short form,
   * just like Go.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.lib.vdl.testdata.arith.ArithServer.DivModOut>
      divMod(
          io.v.v23.context.VContext context,
          io.v.v23.rpc.ServerCall call,
          final int a,
          final int b);

  /**
   * Sub shows that you can use data types defined in other packages.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> sub(
      io.v.v23.context.VContext context,
      io.v.v23.rpc.ServerCall call,
      final io.v.x.ref.lib.vdl.testdata.base.Args args);

  /**
   * Mul tries another data type defined in another package.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> mul(
      io.v.v23.context.VContext context,
      io.v.v23.rpc.ServerCall call,
      final io.v.x.ref.lib.vdl.testdata.base.NestedArgs nested);

  /**
   * GenError shows that it's fine to have no in args, and no out args other
   * than "error".  In addition GenError shows the usage of tags.  Tags are a
   * sequence of constants.  There's no requirement on uniqueness of types or
   * values, and regular const expressions may also be used.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> genError(
      io.v.v23.context.VContext context, io.v.v23.rpc.ServerCall call);

  /**
   * Count shows using only an int32 out-stream type, with no in-stream type.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> count(
      io.v.v23.context.VContext context,
      io.v.v23.rpc.ServerCall call,
      final int start,
      io.v.v23.vdl.ServerSendStream<java.lang.Integer> stream);

  /**
   * StreamingAdd shows a bidirectional stream.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> streamingAdd(
      io.v.v23.context.VContext context,
      io.v.v23.rpc.ServerCall call,
      io.v.v23.vdl.ServerStream<java.lang.Integer, java.lang.Integer> stream);

  /**
   * QuoteAny shows the any built-in type, representing a value of any type.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<io.v.v23.vdl.VdlAny> quoteAny(
      io.v.v23.context.VContext context, io.v.v23.rpc.ServerCall call, final io.v.v23.vdl.VdlAny a);
}
