// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  arith.vdl
package io.v.x.ref.lib.vdl.testdata.arith;

/**
 * Implementation of the {@link ArithClient} interface.
 */
final class ArithClientImpl implements io.v.x.ref.lib.vdl.testdata.arith.ArithClient {
  private final io.v.v23.rpc.Client client;
  private final java.lang.String vName;

  /**
   * Creates a new instance of {@link ArithClientImpl}.
   *
   * @param client Vanadium client
   * @param vName  remote server name
   */
  public ArithClientImpl(io.v.v23.rpc.Client client, java.lang.String vName) {
    this.client = client;
    this.vName = vName;
  }

  private io.v.v23.rpc.Client getClient(io.v.v23.context.VContext context) {
    return this.client != null ? client : io.v.v23.V.getClient(context);
  }

  // Methods from interface ArithClient.

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> add(
      io.v.v23.context.VContext _context, final int a, final int b) {
    return add(_context, a, b, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> add(
      final io.v.v23.context.VContext _context, final int a, final int b, io.v.v23.Options _opts) {
    return add(_context, a, b, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> add(
      final io.v.v23.context.VContext _context,
      final int a,
      final int b,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {a, b};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {java.lang.Integer.class, java.lang.Integer.class};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "add", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Integer>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      java.lang.Integer.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Integer>() {
                      @Override
                      public java.lang.Integer apply(Object[] _results) {

                        return (java.lang.Integer) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.lib.vdl.testdata.arith.ArithClient.DivModOut>
      divMod(io.v.v23.context.VContext _context, final int a, final int b) {
    return divMod(_context, a, b, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.lib.vdl.testdata.arith.ArithClient.DivModOut>
      divMod(
          final io.v.v23.context.VContext _context,
          final int a,
          final int b,
          io.v.v23.Options _opts) {
    return divMod(_context, a, b, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.lib.vdl.testdata.arith.ArithClient.DivModOut>
      divMod(
          final io.v.v23.context.VContext _context,
          final int a,
          final int b,
          io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {a, b};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {java.lang.Integer.class, java.lang.Integer.class};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "divMod", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall,
                io.v.x.ref.lib.vdl.testdata.arith.ArithClient.DivModOut>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<
                      io.v.x.ref.lib.vdl.testdata.arith.ArithClient.DivModOut>
                  apply(final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      java.lang.Integer.class, java.lang.Integer.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<
                        Object[], io.v.x.ref.lib.vdl.testdata.arith.ArithClient.DivModOut>() {
                      @Override
                      public io.v.x.ref.lib.vdl.testdata.arith.ArithClient.DivModOut apply(
                          Object[] _results) {

                        io.v.x.ref.lib.vdl.testdata.arith.ArithClient.DivModOut _ret =
                            new io.v.x.ref.lib.vdl.testdata.arith.ArithClient.DivModOut();

                        _ret.quot = (java.lang.Integer) _results[0];

                        _ret.rem = (java.lang.Integer) _results[1];

                        return _ret;
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> sub(
      io.v.v23.context.VContext _context, final io.v.x.ref.lib.vdl.testdata.base.Args args) {
    return sub(_context, args, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> sub(
      final io.v.v23.context.VContext _context,
      final io.v.x.ref.lib.vdl.testdata.base.Args args,
      io.v.v23.Options _opts) {
    return sub(_context, args, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> sub(
      final io.v.v23.context.VContext _context,
      final io.v.x.ref.lib.vdl.testdata.base.Args args,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {args};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {io.v.x.ref.lib.vdl.testdata.base.Args.class};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "sub", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Integer>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      java.lang.Integer.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Integer>() {
                      @Override
                      public java.lang.Integer apply(Object[] _results) {

                        return (java.lang.Integer) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> mul(
      io.v.v23.context.VContext _context,
      final io.v.x.ref.lib.vdl.testdata.base.NestedArgs nested) {
    return mul(_context, nested, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> mul(
      final io.v.v23.context.VContext _context,
      final io.v.x.ref.lib.vdl.testdata.base.NestedArgs nested,
      io.v.v23.Options _opts) {
    return mul(_context, nested, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> mul(
      final io.v.v23.context.VContext _context,
      final io.v.x.ref.lib.vdl.testdata.base.NestedArgs nested,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {nested};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {io.v.x.ref.lib.vdl.testdata.base.NestedArgs.class};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "mul", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Integer>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      java.lang.Integer.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Integer>() {
                      @Override
                      public java.lang.Integer apply(Object[] _results) {

                        return (java.lang.Integer) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> genError(
      io.v.v23.context.VContext _context) {
    return genError(_context, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> genError(
      final io.v.v23.context.VContext _context, io.v.v23.Options _opts) {
    return genError(_context, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> genError(
      final io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "genError", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Void>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes = new java.lang.reflect.Type[] {};

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Void>() {
                      @Override
                      public java.lang.Void apply(Object[] _results) {

                        return null;
                      }
                    });
              }
            }));
  }

  @Override
  public io.v.v23.vdl.ClientRecvStream<java.lang.Integer, java.lang.Void> count(
      io.v.v23.context.VContext _context, final int start) {
    return count(_context, start, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public io.v.v23.vdl.ClientRecvStream<java.lang.Integer, java.lang.Void> count(
      final io.v.v23.context.VContext _context, final int start, io.v.v23.Options _opts) {
    return count(_context, start, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public io.v.v23.vdl.ClientRecvStream<java.lang.Integer, java.lang.Void> count(
      final io.v.v23.context.VContext _context,
      final int start,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {start};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {java.lang.Integer.class};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "count", _args, _argTypes, _opts);

    return new io.v.v23.vdl.ClientStream<java.lang.Void, java.lang.Integer, java.lang.Void>() {
      @Override
      public com.google.common.util.concurrent.ListenableFuture<Void> send(
          final java.lang.Void item) {
        final java.lang.reflect.Type type = java.lang.Void.class;
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, Void>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<Void> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return _call.send(item, type);
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<Void> close() {
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, Void>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<Void> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return _call.closeSend();
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> recv() {
        final java.lang.reflect.Type recvType = java.lang.Integer.class;
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, java.lang.Integer>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<java.lang.Integer>
                      apply(final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return com.google.common.util.concurrent.Futures.transform(
                        _call.recv(recvType),
                        new com.google.common.base.Function<Object, java.lang.Integer>() {
                          @Override
                          public java.lang.Integer apply(Object result) {
                            return (java.lang.Integer) result;
                          }
                        });
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> finish() {

        final java.lang.reflect.Type[] resultTypes = new java.lang.reflect.Type[] {};

        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, java.lang.Void>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return com.google.common.util.concurrent.Futures.transform(
                        _call.finish(resultTypes),
                        new com.google.common.base.Function<Object[], java.lang.Void>() {
                          @Override
                          public java.lang.Void apply(Object[] _results) {

                            return null;
                          }
                        });
                  }
                }));
      }
    };
  }

  @Override
  public io.v.v23.vdl.ClientStream<java.lang.Integer, java.lang.Integer, java.lang.Integer>
      streamingAdd(io.v.v23.context.VContext _context) {
    return streamingAdd(_context, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public io.v.v23.vdl.ClientStream<java.lang.Integer, java.lang.Integer, java.lang.Integer>
      streamingAdd(final io.v.v23.context.VContext _context, io.v.v23.Options _opts) {
    return streamingAdd(_context, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public io.v.v23.vdl.ClientStream<java.lang.Integer, java.lang.Integer, java.lang.Integer>
      streamingAdd(final io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context)
            .startCall(_context, this.vName, "streamingAdd", _args, _argTypes, _opts);

    return new io.v.v23.vdl.ClientStream<
        java.lang.Integer, java.lang.Integer, java.lang.Integer>() {
      @Override
      public com.google.common.util.concurrent.ListenableFuture<Void> send(
          final java.lang.Integer item) {
        final java.lang.reflect.Type type = java.lang.Integer.class;
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, Void>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<Void> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return _call.send(item, type);
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<Void> close() {
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, Void>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<Void> apply(
                      final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return _call.closeSend();
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> recv() {
        final java.lang.reflect.Type recvType = java.lang.Integer.class;
        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, java.lang.Integer>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<java.lang.Integer>
                      apply(final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return com.google.common.util.concurrent.Futures.transform(
                        _call.recv(recvType),
                        new com.google.common.base.Function<Object, java.lang.Integer>() {
                          @Override
                          public java.lang.Integer apply(Object result) {
                            return (java.lang.Integer) result;
                          }
                        });
                  }
                }));
      }

      @Override
      public com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> finish() {

        final java.lang.reflect.Type[] resultTypes =
            new java.lang.reflect.Type[] {
              java.lang.Integer.class,
            };

        return io.v.v23.VFutures.withUserLandChecks(
            _context,
            com.google.common.util.concurrent.Futures.transform(
                _callFuture,
                new com.google.common.util.concurrent.AsyncFunction<
                    io.v.v23.rpc.ClientCall, java.lang.Integer>() {
                  @Override
                  public com.google.common.util.concurrent.ListenableFuture<java.lang.Integer>
                      apply(final io.v.v23.rpc.ClientCall _call) throws Exception {
                    return com.google.common.util.concurrent.Futures.transform(
                        _call.finish(resultTypes),
                        new com.google.common.base.Function<Object[], java.lang.Integer>() {
                          @Override
                          public java.lang.Integer apply(Object[] _results) {

                            return (java.lang.Integer) _results[0];
                          }
                        });
                  }
                }));
      }
    };
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.vdl.VdlAny> quoteAny(
      io.v.v23.context.VContext _context, final io.v.v23.vdl.VdlAny a) {
    return quoteAny(_context, a, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.vdl.VdlAny> quoteAny(
      final io.v.v23.context.VContext _context,
      final io.v.v23.vdl.VdlAny a,
      io.v.v23.Options _opts) {
    return quoteAny(_context, a, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.vdl.VdlAny> quoteAny(
      final io.v.v23.context.VContext _context,
      final io.v.v23.vdl.VdlAny a,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {a};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {io.v.v23.vdl.VdlAny.class};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "quoteAny", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, io.v.v23.vdl.VdlAny>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<io.v.v23.vdl.VdlAny> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      io.v.v23.vdl.VdlAny.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], io.v.v23.vdl.VdlAny>() {
                      @Override
                      public io.v.v23.vdl.VdlAny apply(Object[] _results) {

                        return (io.v.v23.vdl.VdlAny) _results[0];
                      }
                    });
              }
            }));
  }
}
