// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: arith.vdl
package io.v.x.ref.lib.vdl.testdata.arith;

/**
 * Arith is an example of an interface definition for an arithmetic service.
 * Things to note:
 *   * There must be at least 1 out-arg, and the last out-arg must be error.
 */
public interface ArithClient {

  /**
   * Add is a typical method with multiple input and output arguments.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> add(
      io.v.v23.context.VContext context, final int a, final int b);

  /**
   * Add is a typical method with multiple input and output arguments.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> add(
      io.v.v23.context.VContext context, final int a, final int b, io.v.v23.Options opts);

  /**
   * Add is a typical method with multiple input and output arguments.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> add(
      io.v.v23.context.VContext context,
      final int a,
      final int b,
      io.v.v23.options.RpcOptions opts);

  /**
   * Multi-return value for method {@link #divMod}.
   */
  @io.v.v23.vdl.MultiReturn
  public static class DivModOut {

    public int quot;

    public int rem;
  }

  /**
   * DivMod shows that runs of args with the same type can use the short form,
   * just like Go.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.lib.vdl.testdata.arith.ArithClient.DivModOut>
      divMod(io.v.v23.context.VContext context, final int a, final int b);

  /**
   * DivMod shows that runs of args with the same type can use the short form,
   * just like Go.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.lib.vdl.testdata.arith.ArithClient.DivModOut>
      divMod(io.v.v23.context.VContext context, final int a, final int b, io.v.v23.Options opts);

  /**
   * DivMod shows that runs of args with the same type can use the short form,
   * just like Go.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<
          io.v.x.ref.lib.vdl.testdata.arith.ArithClient.DivModOut>
      divMod(
          io.v.v23.context.VContext context,
          final int a,
          final int b,
          io.v.v23.options.RpcOptions opts);

  /**
   * Sub shows that you can use data types defined in other packages.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> sub(
      io.v.v23.context.VContext context, final io.v.x.ref.lib.vdl.testdata.base.Args args);

  /**
   * Sub shows that you can use data types defined in other packages.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> sub(
      io.v.v23.context.VContext context,
      final io.v.x.ref.lib.vdl.testdata.base.Args args,
      io.v.v23.Options opts);

  /**
   * Sub shows that you can use data types defined in other packages.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> sub(
      io.v.v23.context.VContext context,
      final io.v.x.ref.lib.vdl.testdata.base.Args args,
      io.v.v23.options.RpcOptions opts);

  /**
   * Mul tries another data type defined in another package.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> mul(
      io.v.v23.context.VContext context, final io.v.x.ref.lib.vdl.testdata.base.NestedArgs nested);

  /**
   * Mul tries another data type defined in another package.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> mul(
      io.v.v23.context.VContext context,
      final io.v.x.ref.lib.vdl.testdata.base.NestedArgs nested,
      io.v.v23.Options opts);

  /**
   * Mul tries another data type defined in another package.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Integer> mul(
      io.v.v23.context.VContext context,
      final io.v.x.ref.lib.vdl.testdata.base.NestedArgs nested,
      io.v.v23.options.RpcOptions opts);

  /**
   * GenError shows that it's fine to have no in args, and no out args other
   * than "error".  In addition GenError shows the usage of tags.  Tags are a
   * sequence of constants.  There's no requirement on uniqueness of types or
   * values, and regular const expressions may also be used.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> genError(
      io.v.v23.context.VContext context);

  /**
   * GenError shows that it's fine to have no in args, and no out args other
   * than "error".  In addition GenError shows the usage of tags.  Tags are a
   * sequence of constants.  There's no requirement on uniqueness of types or
   * values, and regular const expressions may also be used.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> genError(
      io.v.v23.context.VContext context, io.v.v23.Options opts);

  /**
   * GenError shows that it's fine to have no in args, and no out args other
   * than "error".  In addition GenError shows the usage of tags.  Tags are a
   * sequence of constants.  There's no requirement on uniqueness of types or
   * values, and regular const expressions may also be used.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> genError(
      io.v.v23.context.VContext context, io.v.v23.options.RpcOptions opts);

  /**
   * Count shows using only an int32 out-stream type, with no in-stream type.
   */
  io.v.v23.vdl.ClientRecvStream<java.lang.Integer, java.lang.Void> count(
      io.v.v23.context.VContext context, final int start);

  /**
   * Count shows using only an int32 out-stream type, with no in-stream type.
   */
  @java.lang.Deprecated
  io.v.v23.vdl.ClientRecvStream<java.lang.Integer, java.lang.Void> count(
      io.v.v23.context.VContext context, final int start, io.v.v23.Options opts);

  /**
   * Count shows using only an int32 out-stream type, with no in-stream type.
   */
  io.v.v23.vdl.ClientRecvStream<java.lang.Integer, java.lang.Void> count(
      io.v.v23.context.VContext context, final int start, io.v.v23.options.RpcOptions opts);

  /**
   * StreamingAdd shows a bidirectional stream.
   */
  io.v.v23.vdl.ClientStream<java.lang.Integer, java.lang.Integer, java.lang.Integer> streamingAdd(
      io.v.v23.context.VContext context);

  /**
   * StreamingAdd shows a bidirectional stream.
   */
  @java.lang.Deprecated
  io.v.v23.vdl.ClientStream<java.lang.Integer, java.lang.Integer, java.lang.Integer> streamingAdd(
      io.v.v23.context.VContext context, io.v.v23.Options opts);

  /**
   * StreamingAdd shows a bidirectional stream.
   */
  io.v.v23.vdl.ClientStream<java.lang.Integer, java.lang.Integer, java.lang.Integer> streamingAdd(
      io.v.v23.context.VContext context, io.v.v23.options.RpcOptions opts);

  /**
   * QuoteAny shows the any built-in type, representing a value of any type.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<io.v.v23.vdl.VdlAny> quoteAny(
      io.v.v23.context.VContext context, final io.v.v23.vdl.VdlAny a);

  /**
   * QuoteAny shows the any built-in type, representing a value of any type.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<io.v.v23.vdl.VdlAny> quoteAny(
      io.v.v23.context.VContext context, final io.v.v23.vdl.VdlAny a, io.v.v23.Options opts);

  /**
   * QuoteAny shows the any built-in type, representing a value of any type.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<io.v.v23.vdl.VdlAny> quoteAny(
      io.v.v23.context.VContext context,
      final io.v.v23.vdl.VdlAny a,
      io.v.v23.options.RpcOptions opts);
}
