// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  advanced.vdl
package io.v.x.ref.lib.vdl.testdata.arith;

/**
 * Wrapper for {@link AdvancedMathServer}.  This wrapper is used by
 * {@link io.v.v23.rpc.ReflectInvoker} to indirectly invoke server methods.
 */
public final class AdvancedMathServerWrapper {
  private final io.v.x.ref.lib.vdl.testdata.arith.AdvancedMathServer server;

  private final io.v.x.ref.lib.vdl.testdata.arith.TrigonometryServerWrapper wrapperTrigonometry;

  private final io.v.x.ref.lib.vdl.testdata.arith.exp.ExpServerWrapper wrapperExp;

  /**
   * Creates a new {@link AdvancedMathServerWrapper} to invoke the methods of the
   * provided server.
   *
   * @param server server whose methods are to be invoked
   */
  public AdvancedMathServerWrapper(io.v.x.ref.lib.vdl.testdata.arith.AdvancedMathServer server) {
    this.server = server;

    this.wrapperTrigonometry =
        new io.v.x.ref.lib.vdl.testdata.arith.TrigonometryServerWrapper(server);

    this.wrapperExp = new io.v.x.ref.lib.vdl.testdata.arith.exp.ExpServerWrapper(server);
  }

  /**
   * Returns a description of this server.
   */
  public io.v.v23.vdlroot.signature.Interface signature() {
    java.util.List<io.v.v23.vdlroot.signature.Embed> embeds =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Embed>();
    java.util.List<io.v.v23.vdlroot.signature.Method> methods =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Method>();

    return new io.v.v23.vdlroot.signature.Interface(
        "AdvancedMath",
        "io.v.x.ref.lib.vdl.testdata.arith",
        "// AdvancedMath is an interface for more advanced math than arith.  It embeds"
            + "// interfaces defined both in the same file and in an external package; and in"
            + "// turn it is embedded by arith.Calculator (which is in the same package but"
            + "// different file) to verify that embedding works in all these scenarios."
            + "",
        embeds,
        methods);
  }

  /**
   * Returns all tags associated with the provided method or {@code null} if the method isn't
   * implemented by this server.
   *
   * @param method method whose tags are to be returned
   */
  @SuppressWarnings("unused")
  public io.v.v23.vdl.VdlValue[] getMethodTags(java.lang.String method)
      throws io.v.v23.verror.VException {

    {
      io.v.v23.vdl.VdlValue[] tags = this.wrapperTrigonometry.getMethodTags(method);
      if (tags != null) {
        return tags;
      }
    }

    {
      io.v.v23.vdl.VdlValue[] tags = this.wrapperExp.getMethodTags(method);
      if (tags != null) {
        return tags;
      }
    }

    return null; // method not found
  }

  public com.google.common.util.concurrent.ListenableFuture<java.lang.Double> exp(
      io.v.v23.context.VContext ctx, io.v.v23.rpc.StreamServerCall call, final double x)
      throws io.v.v23.verror.VException {

    return this.wrapperExp.exp(ctx, call, x);
  }

  public com.google.common.util.concurrent.ListenableFuture<java.lang.Double> cosine(
      io.v.v23.context.VContext ctx, io.v.v23.rpc.StreamServerCall call, final double angle)
      throws io.v.v23.verror.VException {

    return this.wrapperTrigonometry.cosine(ctx, call, angle);
  }

  public com.google.common.util.concurrent.ListenableFuture<java.lang.Double> sine(
      io.v.v23.context.VContext ctx, io.v.v23.rpc.StreamServerCall call, final double angle)
      throws io.v.v23.verror.VException {

    return this.wrapperTrigonometry.sine(ctx, call, angle);
  }
}
