// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  advanced.vdl
package io.v.x.ref.lib.vdl.testdata.arith;

/**
 * Implementation of the {@link AdvancedMathClient} interface.
 */
final class AdvancedMathClientImpl implements io.v.x.ref.lib.vdl.testdata.arith.AdvancedMathClient {
  private final io.v.v23.rpc.Client client;
  private final java.lang.String vName;

  private final io.v.x.ref.lib.vdl.testdata.arith.TrigonometryClient implTrigonometry;

  private final io.v.x.ref.lib.vdl.testdata.arith.exp.ExpClient implExp;

  /**
   * Creates a new instance of {@link AdvancedMathClientImpl}.
   *
   * @param client Vanadium client
   * @param vName  remote server name
   */
  public AdvancedMathClientImpl(io.v.v23.rpc.Client client, java.lang.String vName) {
    this.client = client;
    this.vName = vName;

    {
      io.v.v23.Options opts = new io.v.v23.Options();
      opts.set(io.v.v23.OptionDefs.CLIENT, client);
      this.implTrigonometry =
          io.v.x.ref.lib.vdl.testdata.arith.TrigonometryClientFactory.getTrigonometryClient(
              vName, opts);
    }

    {
      io.v.v23.Options opts = new io.v.v23.Options();
      opts.set(io.v.v23.OptionDefs.CLIENT, client);
      this.implExp =
          io.v.x.ref.lib.vdl.testdata.arith.exp.ExpClientFactory.getExpClient(vName, opts);
    }
  }

  private io.v.v23.rpc.Client getClient(io.v.v23.context.VContext context) {
    return this.client != null ? client : io.v.v23.V.getClient(context);
  }

  // Methods from interface AdvancedMathClient.

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Double> exp(
      io.v.v23.context.VContext _context, final double x) {

    return this.implExp.exp(_context, x);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Double> exp(
      io.v.v23.context.VContext _context, final double x, io.v.v23.Options _opts) {

    return this.implExp.exp(_context, x, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Double> exp(
      io.v.v23.context.VContext _context, final double x, io.v.v23.options.RpcOptions _opts) {

    return this.implExp.exp(_context, x, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Double> cosine(
      io.v.v23.context.VContext _context, final double angle) {

    return this.implTrigonometry.cosine(_context, angle);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Double> cosine(
      io.v.v23.context.VContext _context, final double angle, io.v.v23.Options _opts) {

    return this.implTrigonometry.cosine(_context, angle, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Double> cosine(
      io.v.v23.context.VContext _context, final double angle, io.v.v23.options.RpcOptions _opts) {

    return this.implTrigonometry.cosine(_context, angle, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Double> sine(
      io.v.v23.context.VContext _context, final double angle) {

    return this.implTrigonometry.sine(_context, angle);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Double> sine(
      io.v.v23.context.VContext _context, final double angle, io.v.v23.Options _opts) {

    return this.implTrigonometry.sine(_context, angle, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Double> sine(
      io.v.v23.context.VContext _context, final double angle, io.v.v23.options.RpcOptions _opts) {

    return this.implTrigonometry.sine(_context, angle, _opts);
  }
}
