// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.x.ref.lib.security.bcrypter;

/**
 * WirePrivateKey represents the wire format of the private key corresponding
 * to a blessing.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/x/ref/lib/security/bcrypter.WirePrivateKey")
public class WirePrivateKey extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Blessing", index = 0)
  private java.lang.String blessing;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Params", index = 1)
  private io.v.x.ref.lib.security.bcrypter.WireParams params;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Keys", index = 2)
  private java.util.List<byte[]> keys;

  /**
   * Vdl type for {@link WirePrivateKey}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(WirePrivateKey.class);

  /**
   * Creates a new zero-value instance of {@link WirePrivateKey}.
   */
  public WirePrivateKey() {
    super(VDL_TYPE);

    this.blessing = "";

    this.params = new io.v.x.ref.lib.security.bcrypter.WireParams();

    this.keys = new java.util.ArrayList<byte[]>();
  }

  /**
   * Creates a new instance of {@link WirePrivateKey} with the provided field values.
   */
  public WirePrivateKey(
      java.lang.String blessing,
      io.v.x.ref.lib.security.bcrypter.WireParams params,
      java.util.List<byte[]> keys) {
    super(VDL_TYPE);

    this.blessing = blessing;

    this.params = params;

    this.keys = keys;
  }

  /**
   * Blessing is the blessing for which this private key was extracted for.
   */
  public java.lang.String getBlessing() {
    return this.blessing;
  }

  /**
   * Blessing is the blessing for which this private key was extracted for.
   */
  public void setBlessing(java.lang.String blessing) {
    this.blessing = blessing;
  }

  /**
   * Params are the public parameters of the identity provider that extracted
   * this private key.
   */
  public io.v.x.ref.lib.security.bcrypter.WireParams getParams() {
    return this.params;
  }

  /**
   * Params are the public parameters of the identity provider that extracted
   * this private key.
   */
  public void setParams(io.v.x.ref.lib.security.bcrypter.WireParams params) {
    this.params = params;
  }

  /**
   * Keys contain the extracted IBE private keys for each pattern that is
   * matched by the blessing and is an extension of the identity provider's
   * name. The keys are enumerated in increasing order of the lengths of the
   * corresponding patterns.
   *<p>
   * For example, if the blessing is "google:u:alice:phone" and the identity
   * provider's name is "google:u" then the keys are extracted for the patterns
   * - "google:u"
   * - "google:u:alice"
   * - "google:u:alice:phone"
   * - "google:u:alice:phone:$"
   *<p>
   * The private keys are listed in increasing order of the lengths of the
   * corresponding patterns.
   */
  public java.util.List<byte[]> getKeys() {
    return this.keys;
  }

  /**
   * Keys contain the extracted IBE private keys for each pattern that is
   * matched by the blessing and is an extension of the identity provider's
   * name. The keys are enumerated in increasing order of the lengths of the
   * corresponding patterns.
   *<p>
   * For example, if the blessing is "google:u:alice:phone" and the identity
   * provider's name is "google:u" then the keys are extracted for the patterns
   * - "google:u"
   * - "google:u:alice"
   * - "google:u:alice:phone"
   * - "google:u:alice:phone:$"
   *<p>
   * The private keys are listed in increasing order of the lengths of the
   * corresponding patterns.
   */
  public void setKeys(java.util.List<byte[]> keys) {
    this.keys = keys;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    WirePrivateKey other = (WirePrivateKey) obj;

    if (this.blessing == null) {
      if (other.blessing != null) {
        return false;
      }
    } else if (!this.blessing.equals(other.blessing)) {
      return false;
    }

    if (this.params == null) {
      if (other.params != null) {
        return false;
      }
    } else if (!this.params.equals(other.params)) {
      return false;
    }

    if (this.keys == null) {
      if (other.keys != null) {
        return false;
      }
    } else if (!this.keys.equals(other.keys)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.blessing == null ? 0 : this.blessing.hashCode());

    result = prime * result + (this.params == null ? 0 : this.params.hashCode());

    result = prime * result + (this.keys == null ? 0 : this.keys.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "blessing:" + this.blessing;

    result += ", ";

    result += "params:" + this.params;

    result += ", ";

    result += "keys:" + this.keys;

    return result + "}";
  }
}
